/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.model.generators;

import au.com.dius.pact.model.ContentType;
import au.com.dius.pact.model.InvalidPactException;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.PactSpecVersion;
import au.com.dius.pact.model.generators.Category;
import au.com.dius.pact.model.generators.ContentTypeHandler;
import au.com.dius.pact.model.generators.Generator;
import au.com.dius.pact.model.generators.GeneratorKt;
import au.com.dius.pact.model.generators.GeneratorTestMode;
import au.com.dius.pact.model.generators.Generators;
import au.com.dius.pact.model.generators.Generators$Companion$WhenMappings;
import au.com.dius.pact.model.generators.Generators$WhenMappings;
import au.com.dius.pact.model.generators.GeneratorsKt;
import au.com.dius.pact.model.generators.QueryResult;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 22\u00020\u0001:\u00012B'\u0012 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0004J$\u0010\f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u001a\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0011\u001a\u00020\u0005H\u0007J4\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ2\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u001a\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u001c0\u001eJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0005J!\u0010!\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003H\u00c6\u0003J+\u0010\"\u001a\u00020\u00002 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003H\u00c6\u0001J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0005J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\u0006\u0010*\u001a\u00020&J\u0006\u0010+\u001a\u00020&J6\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010/\u001a\u000200J\t\u00101\u001a\u00020\u0005H\u00d6\u0001R)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00063"}, d2={"Lau/com/dius/pact/model/generators/Generators;", "", "categories", "", "Lau/com/dius/pact/model/generators/Category;", "", "Lau/com/dius/pact/model/generators/Generator;", "(Ljava/util/Map;)V", "getCategories", "()Ljava/util/Map;", "addCategory", "category", "addGenerator", "key", "generator", "addGenerators", "generators", "keyPrefix", "applyBodyGenerators", "Lau/com/dius/pact/model/OptionalBody;", "body", "contentType", "Lau/com/dius/pact/model/ContentType;", "context", "", "mode", "Lau/com/dius/pact/model/generators/GeneratorTestMode;", "applyGenerator", "", "closure", "Lkotlin/Function2;", "applyRootPrefix", "prefix", "component1", "copy", "copyWithUpdatedMatcherRootPrefix", "rootPath", "equals", "", "other", "hashCode", "", "isEmpty", "isNotEmpty", "processBody", "value", "toMap", "pactSpecVersion", "Lau/com/dius/pact/model/PactSpecVersion;", "toString", "Companion", "pact-jvm-model"})
public final class Generators {
    @NotNull
    private final Map<Category, Map<String, Generator>> categories;
    public static final Companion Companion = new Companion(null);

    @JvmOverloads
    @NotNull
    public final Generators addGenerator(@NotNull Category category, @Nullable String key, @NotNull Generator generator) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        if (this.categories.containsKey((Object)category) && this.categories.get((Object)category) != null) {
            Map<String, Generator> map = this.categories.get((Object)category);
            if (map != null) {
                String string = key;
                if (string == null) {
                    string = "";
                }
                map.put(string, generator);
            }
        } else {
            Map<Category, Map<String, Generator>> map = this.categories;
            Pair[] pairArray = new Pair[1];
            String string = key;
            if (string == null) {
                string = "";
            }
            pairArray[0] = TuplesKt.to((Object)string, (Object)generator);
            Map map2 = MapsKt.mutableMapOf((Pair[])pairArray);
            map.put(category, map2);
        }
        return this;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Generators addGenerator$default(Generators generators, Category category, String string, Generator generator, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return generators.addGenerator(category, string, generator);
    }

    @JvmOverloads
    @NotNull
    public final Generators addGenerator(@NotNull Category category, @NotNull Generator generator) {
        return Generators.addGenerator$default(this, category, null, generator, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Generators addGenerators(@NotNull Generators generators, @NotNull String keyPrefix) {
        Map<Category, Map<String, Generator>> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)generators, (String)"generators");
        Intrinsics.checkParameterIsNotNull((Object)keyPrefix, (String)"keyPrefix");
        Map<Category, Map<String, Generator>> map = $receiver$iv = generators.categories;
        Iterator<Map.Entry<Category, Map<String, Generator>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map<String, Generator> map2;
            Map<String, Generator> $receiver$iv2;
            Map.Entry<Category, Map<String, Generator>> element$iv;
            Map.Entry<Category, Map<String, Generator>> $category_map;
            Map.Entry<Category, Map<String, Generator>> entry = $category_map = (element$iv = iterator.next());
            Category category = entry.getKey();
            entry = $category_map;
            Map<String, Generator> map3 = $receiver$iv2 = (map2 = entry.getValue());
            Iterator<Map.Entry<String, Generator>> iterator2 = map3.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Generator> element$iv2;
                Map.Entry<String, Generator> $key_generator;
                Map.Entry<String, Generator> entry2 = $key_generator = (element$iv2 = iterator2.next());
                String key = entry2.getKey();
                entry2 = $key_generator;
                Generator generator = entry2.getValue();
                this.addGenerator(category, keyPrefix + key, generator);
            }
        }
        return this;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Generators addGenerators$default(Generators generators, Generators generators2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return generators.addGenerators(generators2, string);
    }

    @JvmOverloads
    @NotNull
    public final Generators addGenerators(@NotNull Generators generators) {
        return Generators.addGenerators$default(this, generators, null, 2, null);
    }

    @NotNull
    public final Generators addCategory(@NotNull Category category) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        if (!this.categories.containsKey((Object)category)) {
            Map<Category, Map<String, Generator>> map = this.categories;
            Map map2 = new LinkedHashMap();
            map.put(category, map2);
        }
        return this;
    }

    public final void applyGenerator(@NotNull Category category, @NotNull GeneratorTestMode mode, @NotNull Function2<? super String, ? super Generator, Unit> closure) {
        Map<String, Generator> categoryValues;
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        if (this.categories.containsKey((Object)category) && this.categories.get((Object)category) != null && (categoryValues = this.categories.get((Object)category)) != null) {
            Map<String, Generator> map = categoryValues;
            Iterator<Map.Entry<String, Generator>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Generator> entry;
                Map.Entry<String, Generator> entry2 = entry = iterator.next();
                String key = entry2.getKey();
                entry2 = entry;
                Generator generator = entry2.getValue();
                if (!generator.correspondsToMode(mode)) continue;
                closure.invoke((Object)key, (Object)generator);
            }
        }
    }

    @NotNull
    public final OptionalBody applyBodyGenerators(@NotNull OptionalBody body, @NotNull ContentType contentType, @NotNull Map<String, ? extends Object> context, @NotNull GeneratorTestMode mode) {
        OptionalBody optionalBody;
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        switch (Generators$WhenMappings.$EnumSwitchMapping$0[body.getState().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                optionalBody = body;
                break;
            }
            case 4: {
                if (contentType.isJson()) {
                    String string = body.getValue();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    optionalBody = this.processBody(string, "application/json", context, mode);
                    break;
                }
                if (contentType.isXml()) {
                    String string = body.getValue();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    optionalBody = this.processBody(string, "application/xml", context, mode);
                    break;
                }
                optionalBody = body;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return optionalBody;
    }

    private final OptionalBody processBody(String value, String contentType, Map<String, ? extends Object> context, GeneratorTestMode mode) {
        ContentTypeHandler handler = GeneratorsKt.getContentTypeHandlers().get(contentType);
        Object object = handler;
        if (object == null || (object = object.processBody(value, (Function1<? super QueryResult, Unit>)((Function1)new Function1<QueryResult, Unit>(this, mode, handler, context){
            final /* synthetic */ Generators this$0;
            final /* synthetic */ GeneratorTestMode $mode;
            final /* synthetic */ ContentTypeHandler $handler;
            final /* synthetic */ Map $context;

            public final void invoke(@NotNull QueryResult body) {
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                this.this$0.applyGenerator(Category.BODY, this.$mode, (Function2<? super String, ? super Generator, Unit>)((Function2)new Function2<String, Generator, Unit>(this, body){
                    final /* synthetic */ processBody.1 this$0;
                    final /* synthetic */ QueryResult $body;

                    public final void invoke(@NotNull String key, @Nullable Generator generator) {
                        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                        if (generator != null) {
                            this.this$0.$handler.applyKey(this.$body, key, generator, this.this$0.$context);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$body = queryResult;
                        super(2);
                    }
                }));
            }
            {
                this.this$0 = generators;
                this.$mode = generatorTestMode;
                this.$handler = contentTypeHandler;
                this.$context = map;
                super(1);
            }
        }))) == null) {
            object = OptionalBody.Companion.body(value);
        }
        return object;
    }

    public final boolean isEmpty() {
        return this.categories.isEmpty();
    }

    public final boolean isNotEmpty() {
        Map<Category, Map<String, Generator>> map = this.categories;
        return !map.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> toMap(@NotNull PactSpecVersion pactSpecVersion) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        if (pactSpecVersion.compareTo((Enum)PactSpecVersion.V3) < 0) {
            throw (Throwable)new InvalidPactException("Generators are only supported with pact specification version 3+");
        }
        Iterable $receiver$iv = this.categories.entrySet();
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Pair pair;
            Map map = destination$iv$iv;
            Map.Entry $key_value = (Map.Entry)element$iv$iv;
            Object object = $key_value;
            Category key = (Category)((Object)object.getKey());
            object = $key_value;
            Map value = (Map)object.getValue();
            switch (Generators$WhenMappings.$EnumSwitchMapping$1[key.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    Object object2 = object = key.name();
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string = ((String)object2).toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
                    Object v = value.get("");
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    pair = TuplesKt.to((Object)string, ((Generator)v).toMap(pactSpecVersion));
                    break;
                }
                default: {
                    String string;
                    void $receiver$iv$iv2;
                    void $receiver$iv2;
                    Object object3 = object = key.name();
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)((String)object3).toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                    object = value.entrySet();
                    int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10)), (int)16);
                    void var15_15 = $receiver$iv2;
                    Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
                    for (Object element$iv$iv2 : $receiver$iv$iv2) {
                        Map.Entry $genKey_generator;
                        Map map2 = destination$iv$iv2;
                        Map.Entry entry = $genKey_generator = (Map.Entry)element$iv$iv2;
                        String genKey = (String)entry.getKey();
                        entry = $genKey_generator;
                        Generator generator = (Generator)entry.getValue();
                        Pair pair2 = TuplesKt.to((Object)genKey, generator.toMap(pactSpecVersion));
                        map2.put(pair2.getFirst(), pair2.getSecond());
                    }
                    Map map3 = destination$iv$iv2;
                    pair = TuplesKt.to((Object)string, (Object)map3);
                }
            }
            Pair pair3 = pair;
            map.put(pair3.getFirst(), pair3.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void applyRootPrefix(@NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Iterable $receiver$iv = this.categories.keySet();
        for (Object element$iv : $receiver$iv) {
            void $receiver$iv$iv;
            Map<String, Generator> $receiver$iv2;
            Category category = (Category)((Object)element$iv);
            Map<Category, Map<String, Generator>> map = this.categories;
            if (this.categories.get((Object)category) == null) {
                Intrinsics.throwNpe();
            }
            Map<String, Generator> map2 = $receiver$iv2;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv2.size()));
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                void it$iv$iv;
                void entry;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                String string = prefix + (String)entry.getKey();
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                String string2 = string;
                Map map4 = map3;
                Object v = it$iv$iv.getValue();
                map4.put(string2, v);
            }
            Map map5 = MapsKt.toMutableMap((Map)destination$iv$iv);
            map.put(category, map5);
        }
    }

    @NotNull
    public final Generators copyWithUpdatedMatcherRootPrefix(@NotNull String rootPath) {
        Intrinsics.checkParameterIsNotNull((Object)rootPath, (String)"rootPath");
        Generators generators = this.copy(MapsKt.toMutableMap(this.categories));
        generators.applyRootPrefix(rootPath);
        return generators;
    }

    @NotNull
    public final Map<Category, Map<String, Generator>> getCategories() {
        return this.categories;
    }

    public Generators(@NotNull Map<Category, Map<String, Generator>> categories) {
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        this.categories = categories;
    }

    public /* synthetic */ Generators(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new LinkedHashMap();
        }
        this(map);
    }

    public Generators() {
        this(null, 1, null);
    }

    @NotNull
    public final Map<Category, Map<String, Generator>> component1() {
        return this.categories;
    }

    @NotNull
    public final Generators copy(@NotNull Map<Category, Map<String, Generator>> categories) {
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        return new Generators(categories);
    }

    @NotNull
    public static /* synthetic */ Generators copy$default(Generators generators, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = generators.categories;
        }
        return generators.copy(map);
    }

    @NotNull
    public String toString() {
        return "Generators(categories=" + this.categories + ")";
    }

    public int hashCode() {
        Map<Category, Map<String, Generator>> map = this.categories;
        return map != null ? ((Object)map).hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Generators)) break block3;
                Generators generators = (Generators)object;
                if (!Intrinsics.areEqual(this.categories, generators.categories)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Generators fromMap(@Nullable Map<String, ? extends Map<String, ? extends Object>> map) {
        return Companion.fromMap(map);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042 \u0010\u0005\u001a\u001c\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0018\u00010\u0006H\u0007\u00a8\u0006\t"}, d2={"Lau/com/dius/pact/model/generators/Generators$Companion;", "Lmu/KLogging;", "()V", "fromMap", "Lau/com/dius/pact/model/generators/Generators;", "map", "", "", "", "pact-jvm-model"})
    public static final class Companion
    extends KLogging {
        @JvmStatic
        @NotNull
        public final Generators fromMap(@Nullable Map<String, ? extends Map<String, ? extends Object>> map) {
            Generators generators = new Generators(null, 1, null);
            Map<String, ? extends Map<String, ? extends Object>> map2 = map;
            if (map2 != null) {
                Map<String, ? extends Map<String, ? extends Object>> $receiver$iv;
                Map<String, ? extends Map<String, ? extends Object>> map3 = $receiver$iv = map2;
                Iterator<Map.Entry<String, ? extends Map<String, ? extends Object>>> iterator = map3.entrySet().iterator();
                block5: while (iterator.hasNext()) {
                    Map.Entry<String, ? extends Map<String, ? extends Object>> element$iv;
                    Map.Entry<String, ? extends Map<String, ? extends Object>> $key_generatorMap;
                    Map.Entry<String, ? extends Map<String, ? extends Object>> entry = $key_generatorMap = (element$iv = iterator.next());
                    String key = entry.getKey();
                    entry = $key_generatorMap;
                    Map<String, ? extends Object> generatorMap = entry.getValue();
                    try {
                        String string;
                        String string2 = string = key;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.toUpperCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
                        Category category = Category.valueOf(string3);
                        switch (Generators$Companion$WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                if (generatorMap.containsKey("type")) {
                                    Generator generator = GeneratorKt.lookupGenerator(generatorMap);
                                    if (generator != null) {
                                        Generators.addGenerator$default(generators, category, null, generator, 2, null);
                                        break;
                                    }
                                    Companion.getLogger().warn((Function0)new Function0<String>(generatorMap){
                                        final /* synthetic */ Map $generatorMap;

                                        @NotNull
                                        public final String invoke() {
                                            return "Ignoring invalid generator config '" + this.$generatorMap + '\'';
                                        }
                                        {
                                            this.$generatorMap = map;
                                            super(0);
                                        }
                                    });
                                    break;
                                }
                                Companion.getLogger().warn((Function0)new Function0<String>(generatorMap){
                                    final /* synthetic */ Map $generatorMap;

                                    @NotNull
                                    public final String invoke() {
                                        return "Ignoring invalid generator config '" + this.$generatorMap + '\'';
                                    }
                                    {
                                        this.$generatorMap = map;
                                        super(0);
                                    }
                                });
                                break;
                            }
                            default: {
                                Map<String, ? extends Object> $receiver$iv2;
                                Map<String, ? extends Object> map4 = $receiver$iv2 = generatorMap;
                                Iterator<Map.Entry<String, ? extends Object>> iterator2 = map4.entrySet().iterator();
                                while (iterator2.hasNext()) {
                                    String string4;
                                    Map.Entry<String, ? extends Object> element$iv2;
                                    Map.Entry<String, ? extends Object> $generatorKey_generatorValue = element$iv2 = iterator2.next();
                                    Map.Entry<String, ? extends Object> entry2 = $generatorKey_generatorValue;
                                    String generatorKey = entry2.getKey();
                                    entry2 = $generatorKey_generatorValue;
                                    Object generatorValue = entry2.getValue();
                                    if (generatorValue instanceof Map && (entry2 = (Map)generatorValue).containsKey(string4 = "type")) {
                                        Generator generator = GeneratorKt.lookupGenerator((Map)generatorValue);
                                        if (generator != null) {
                                            generators.addGenerator(category, generatorKey, generator);
                                            continue;
                                        }
                                        Companion.getLogger().warn((Function0)new Function0<String>(category, generatorMap, generators){
                                            final /* synthetic */ Category $category$inlined;
                                            final /* synthetic */ Map $generatorMap$inlined;
                                            final /* synthetic */ Generators $generators$inlined;
                                            {
                                                this.$category$inlined = category;
                                                this.$generatorMap$inlined = map;
                                                this.$generators$inlined = generators;
                                                super(0);
                                            }

                                            @NotNull
                                            public final String invoke() {
                                                return "Ignoring invalid generator config '" + this.$generatorMap$inlined + '\'';
                                            }
                                        });
                                        continue;
                                    }
                                    Companion.getLogger().warn((Function0)new Function0<String>(generatorKey, generatorValue){
                                        final /* synthetic */ String $generatorKey;
                                        final /* synthetic */ Object $generatorValue;

                                        @NotNull
                                        public final String invoke() {
                                            return "Ignoring invalid generator config '" + this.$generatorKey + " -> " + this.$generatorValue + '\'';
                                        }
                                        {
                                            this.$generatorKey = string;
                                            this.$generatorValue = object;
                                            super(0);
                                        }
                                    });
                                }
                                continue block5;
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Companion.getLogger().warn((Throwable)e, (Function0)new Function0<String>(key){
                            final /* synthetic */ String $key;

                            @NotNull
                            public final String invoke() {
                                return "Ignoring generator with invalid category '" + this.$key + '\'';
                            }
                            {
                                this.$key = string;
                                super(0);
                            }
                        });
                    }
                }
            }
            return generators;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

