/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.GelfMessage;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

class GelfBuffers {
    GelfBuffers() {
    }

    protected static ByteBuffer[] toUDPBuffers(GelfMessage message, ThreadLocal<ByteBuffer> writeBuffers, ThreadLocal<ByteBuffer> tempBuffers) {
        while (true) {
            try {
                return message.toUDPBuffers(GelfBuffers.getBuffer(writeBuffers), GelfBuffers.getBuffer(tempBuffers));
            }
            catch (BufferOverflowException e) {
                GelfBuffers.enlargeBuffer(writeBuffers);
                GelfBuffers.enlargeBuffer(tempBuffers);
                continue;
            }
            break;
        }
    }

    protected static ByteBuffer toTCPBuffer(GelfMessage message, ThreadLocal<ByteBuffer> writeBuffers) {
        while (true) {
            try {
                return message.toTCPBuffer(GelfBuffers.getBuffer(writeBuffers));
            }
            catch (BufferOverflowException e) {
                GelfBuffers.enlargeBuffer(writeBuffers);
                continue;
            }
            break;
        }
    }

    private static void enlargeBuffer(ThreadLocal<ByteBuffer> buffers) {
        ByteBuffer newBuffer = ByteBuffer.allocateDirect(GelfBuffers.calculateNewBufferSize(buffers.get().capacity()));
        buffers.set(newBuffer);
    }

    private static ByteBuffer getBuffer(ThreadLocal<ByteBuffer> buffers) {
        return (ByteBuffer)buffers.get().clear();
    }

    private static int calculateNewBufferSize(int capacity) {
        return (int)((double)capacity * 1.5);
    }
}

