/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.jul;

import biz.paluch.logging.RuntimeContainer;
import biz.paluch.logging.gelf.GelfMessageAssembler;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.intern.Closer;
import biz.paluch.logging.gelf.intern.ConfigurationSupport;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderFactory;
import biz.paluch.logging.gelf.jul.JulLogEvent;
import biz.paluch.logging.gelf.jul.JulPropertyProvider;
import java.util.Collections;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class GelfLogHandler
extends Handler
implements ErrorReporter {
    protected volatile GelfSender gelfSender;
    protected GelfMessageAssembler gelfMessageAssembler;

    public GelfLogHandler() {
        String additionalFieldTypes;
        RuntimeContainer.initialize(this);
        this.gelfMessageAssembler = this.createGelfMessageAssembler();
        this.initializeDefaultFields();
        JulPropertyProvider propertyProvider = new JulPropertyProvider(GelfLogHandler.class);
        this.gelfMessageAssembler.initialize(propertyProvider);
        String level = propertyProvider.getProperty("level");
        if (null != level) {
            this.setLevel(Level.parse(level.trim()));
        } else {
            this.setLevel(Level.INFO);
        }
        String additionalFields = propertyProvider.getProperty("additionalFields");
        if (null != additionalFields) {
            this.setAdditionalFields(additionalFields);
        }
        if (null != (additionalFieldTypes = propertyProvider.getProperty("additionalFieldTypes"))) {
            this.setAdditionalFieldTypes(additionalFieldTypes);
        }
        String filter = propertyProvider.getProperty("filter");
        try {
            if (null != filter) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(filter);
                this.setFilter((Filter)clazz.newInstance());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initializeDefaultFields() {
        this.gelfMessageAssembler.addFields(LogMessageField.getDefaultMapping(LogMessageField.NamedLogField.Time, LogMessageField.NamedLogField.Severity, LogMessageField.NamedLogField.ThreadName, LogMessageField.NamedLogField.SourceClassName, LogMessageField.NamedLogField.SourceMethodName, LogMessageField.NamedLogField.SourceSimpleClassName, LogMessageField.NamedLogField.LoggerName));
    }

    protected GelfMessageAssembler createGelfMessageAssembler() {
        return new GelfMessageAssembler();
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        block11: {
            if (!this.isLoggable(record)) {
                return;
            }
            try {
                if (null != this.gelfSender) break block11;
                GelfLogHandler gelfLogHandler = this;
                synchronized (gelfLogHandler) {
                    if (null == this.gelfSender) {
                        this.gelfSender = this.createGelfSender();
                    }
                }
            }
            catch (Exception e) {
                this.reportError("Could not send GELF message: " + e.getMessage(), e, 4);
                return;
            }
        }
        try {
            GelfMessage message = this.createGelfMessage(record);
            if (!message.isValid()) {
                this.reportError("GELF Message is invalid: " + message.toJson(), null, 1);
                return;
            }
            if (null == this.gelfSender || !this.gelfSender.sendMessage(message)) {
                this.reportError("Could not send GELF message", null, 1);
            }
        }
        catch (Exception e) {
            this.reportError("Could not send GELF message: " + e.getMessage(), e, 5);
        }
    }

    protected GelfSender createGelfSender() {
        return GelfSenderFactory.createSender(this.gelfMessageAssembler, this, Collections.EMPTY_MAP);
    }

    @Override
    public void reportError(String message, Exception e) {
        this.reportError(message, e, 0);
    }

    @Override
    public void close() {
        if (null != this.gelfSender) {
            Closer.close(this.gelfSender);
            this.gelfSender = null;
        }
    }

    protected GelfMessage createGelfMessage(LogRecord record) {
        return this.gelfMessageAssembler.createGelfMessage(new JulLogEvent(record));
    }

    public void setAdditionalFields(String spec) {
        ConfigurationSupport.setAdditionalFields(spec, this.gelfMessageAssembler);
    }

    public void setAdditionalFieldTypes(String spec) {
        ConfigurationSupport.setAdditionalFieldTypes(spec, this.gelfMessageAssembler);
    }

    public void setMdcFields(String spec) {
        ConfigurationSupport.setMdcFields(spec, this.gelfMessageAssembler);
    }

    public void setDynamicMdcFields(String spec) {
        ConfigurationSupport.setDynamicMdcFields(spec, this.gelfMessageAssembler);
    }

    public String getGraylogHost() {
        return this.gelfMessageAssembler.getHost();
    }

    public void setGraylogHost(String graylogHost) {
        this.gelfMessageAssembler.setHost(graylogHost);
    }

    public String getOriginHost() {
        return this.gelfMessageAssembler.getOriginHost();
    }

    public void setOriginHost(String originHost) {
        this.gelfMessageAssembler.setOriginHost(originHost);
    }

    public String getHost() {
        return this.gelfMessageAssembler.getHost();
    }

    public void setHost(String host) {
        this.gelfMessageAssembler.setHost(host);
    }

    public int getPort() {
        return this.gelfMessageAssembler.getPort();
    }

    public void setPort(int port) {
        this.gelfMessageAssembler.setPort(port);
    }

    public int getGraylogPort() {
        return this.gelfMessageAssembler.getPort();
    }

    public void setGraylogPort(int graylogPort) {
        this.gelfMessageAssembler.setPort(graylogPort);
    }

    public String getFacility() {
        return this.gelfMessageAssembler.getFacility();
    }

    public void setFacility(String facility) {
        this.gelfMessageAssembler.setFacility(facility);
    }

    public String getExtractStackTrace() {
        return this.gelfMessageAssembler.getExtractStackTrace();
    }

    public void setExtractStackTrace(String extractStacktrace) {
        this.gelfMessageAssembler.setExtractStackTrace(extractStacktrace);
    }

    public boolean isFilterStackTrace() {
        return this.gelfMessageAssembler.isFilterStackTrace();
    }

    public void setFilterStackTrace(boolean filterStackTrace) {
        this.gelfMessageAssembler.setFilterStackTrace(filterStackTrace);
    }

    public boolean isIncludeLogMessageParameters() {
        return this.gelfMessageAssembler.isIncludeLogMessageParameters();
    }

    public void setIncludeLogMessageParameters(boolean includeLogMessageParameters) {
        this.gelfMessageAssembler.setIncludeLogMessageParameters(includeLogMessageParameters);
    }

    public String getTimestampPattern() {
        return this.gelfMessageAssembler.getTimestampPattern();
    }

    public void setTimestampPattern(String timestampPattern) {
        this.gelfMessageAssembler.setTimestampPattern(timestampPattern);
    }

    public int getMaximumMessageSize() {
        return this.gelfMessageAssembler.getMaximumMessageSize();
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        this.gelfMessageAssembler.setMaximumMessageSize(maximumMessageSize);
    }

    public String getVersion() {
        return this.gelfMessageAssembler.getVersion();
    }

    public void setVersion(String version) {
        this.gelfMessageAssembler.setVersion(version);
    }
}

