/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.log4j2;

import biz.paluch.logging.RuntimeContainer;
import biz.paluch.logging.gelf.DynamicMdcMessageField;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MdcGelfMessageAssembler;
import biz.paluch.logging.gelf.MdcMessageField;
import biz.paluch.logging.gelf.StaticMessageField;
import biz.paluch.logging.gelf.intern.Closer;
import biz.paluch.logging.gelf.intern.ConfigurationSupport;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderFactory;
import biz.paluch.logging.gelf.log4j2.GelfDynamicMdcLogFields;
import biz.paluch.logging.gelf.log4j2.GelfLogField;
import biz.paluch.logging.gelf.log4j2.Log4j2LogEvent;
import biz.paluch.logging.gelf.log4j2.PatternLogMessageField;
import java.util.Collections;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="Gelf", category="Core", elementType="appender", printObject=true)
public class GelfLogAppender
extends AbstractAppender {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final ErrorReporter ERROR_REPORTER = new ErrorReporter(){

        @Override
        public void reportError(String message, Exception e) {
            LOGGER.error(message, new Object[]{e, 0});
        }
    };
    private final ErrorReporter PROPAGATING_ERROR_REPORTER = new ErrorReporter(){

        @Override
        public void reportError(String message, Exception e) {
            if (e != null) {
                throw new AppenderLoggingException((Throwable)e);
            }
            LOGGER.error(message, new Object[]{null, 0});
        }
    };
    protected GelfSender gelfSender;
    private final MdcGelfMessageAssembler gelfMessageAssembler;
    private final ErrorReporter errorReporter;

    public GelfLogAppender(String name, Filter filter, MdcGelfMessageAssembler gelfMessageAssembler, boolean ignoreExceptions) {
        super(name, filter, null, ignoreExceptions);
        this.gelfMessageAssembler = gelfMessageAssembler;
        this.errorReporter = ignoreExceptions ? ERROR_REPORTER : this.PROPAGATING_ERROR_REPORTER;
    }

    @PluginFactory
    public static GelfLogAppender createAppender(@PluginConfiguration Configuration config, @PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Field") GelfLogField[] fields, @PluginElement(value="DynamicMdcFields") GelfDynamicMdcLogFields[] dynamicFieldArray, @PluginAttribute(value="graylogHost") String graylogHost, @PluginAttribute(value="host") String host, @PluginAttribute(value="graylogPort") String graylogPort, @PluginAttribute(value="port") String port, @PluginAttribute(value="version") String version, @PluginAttribute(value="extractStackTrace") String extractStackTrace, @PluginAttribute(value="originHost") String originHost, @PluginAttribute(value="includeFullMdc") String includeFullMdc, @PluginAttribute(value="facility") String facility, @PluginAttribute(value="filterStackTrace") String filterStackTrace, @PluginAttribute(value="mdcProfiling") String mdcProfiling, @PluginAttribute(value="maximumMessageSize") String maximumMessageSize, @PluginAttribute(value="additionalFieldTypes") String additionalFieldTypes, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean ignoreExceptions) {
        RuntimeContainer.initialize(ERROR_REPORTER);
        MdcGelfMessageAssembler mdcGelfMessageAssembler = new MdcGelfMessageAssembler();
        if (name == null) {
            LOGGER.error("No name provided for " + GelfLogAppender.class.getSimpleName());
            return null;
        }
        if (Strings.isEmpty((CharSequence)host) && Strings.isEmpty((CharSequence)graylogHost)) {
            LOGGER.error("No host provided for " + GelfLogAppender.class.getSimpleName());
            return null;
        }
        if (Strings.isNotEmpty((CharSequence)host)) {
            mdcGelfMessageAssembler.setHost(host);
        }
        if (Strings.isNotEmpty((CharSequence)graylogHost)) {
            mdcGelfMessageAssembler.setHost(graylogHost);
        }
        if (Strings.isNotEmpty((CharSequence)port)) {
            mdcGelfMessageAssembler.setPort(Integer.parseInt(port));
        }
        if (Strings.isNotEmpty((CharSequence)graylogPort)) {
            mdcGelfMessageAssembler.setPort(Integer.parseInt(graylogPort));
        }
        if (Strings.isNotEmpty((CharSequence)version)) {
            mdcGelfMessageAssembler.setVersion(version);
        }
        if (Strings.isNotEmpty((CharSequence)originHost)) {
            PatternLayout patternLayout = PatternLayout.newBuilder().withPattern(originHost).withConfiguration(config).withNoConsoleNoAnsi(false).withAlwaysWriteExceptions(false).build();
            mdcGelfMessageAssembler.setOriginHost(patternLayout.toSerializable((LogEvent)new Log4jLogEvent()));
        }
        if (facility != null) {
            mdcGelfMessageAssembler.setFacility(facility);
        }
        if (extractStackTrace != null) {
            mdcGelfMessageAssembler.setExtractStackTrace(extractStackTrace);
        }
        if (filterStackTrace != null) {
            mdcGelfMessageAssembler.setFilterStackTrace("true".equals(filterStackTrace));
        }
        if (mdcProfiling != null) {
            mdcGelfMessageAssembler.setMdcProfiling("true".equals(mdcProfiling));
        }
        if (includeFullMdc != null) {
            mdcGelfMessageAssembler.setIncludeFullMdc("true".equals(includeFullMdc));
        }
        if (maximumMessageSize != null) {
            mdcGelfMessageAssembler.setMaximumMessageSize(Integer.parseInt(maximumMessageSize));
        }
        if (additionalFieldTypes != null) {
            ConfigurationSupport.setAdditionalFieldTypes(additionalFieldTypes, mdcGelfMessageAssembler);
        }
        GelfLogAppender.configureFields(mdcGelfMessageAssembler, fields, dynamicFieldArray);
        return new GelfLogAppender(name, filter, mdcGelfMessageAssembler, ignoreExceptions);
    }

    private static void configureFields(MdcGelfMessageAssembler mdcGelfMessageAssembler, GelfLogField[] fields, GelfDynamicMdcLogFields[] dynamicFieldArray) {
        if (fields == null || fields.length == 0) {
            mdcGelfMessageAssembler.addFields(LogMessageField.getDefaultMapping(LogMessageField.NamedLogField.Time, LogMessageField.NamedLogField.Severity, LogMessageField.NamedLogField.ThreadName, LogMessageField.NamedLogField.SourceClassName, LogMessageField.NamedLogField.SourceMethodName, LogMessageField.NamedLogField.SourceLineNumber, LogMessageField.NamedLogField.SourceSimpleClassName, LogMessageField.NamedLogField.LoggerName, LogMessageField.NamedLogField.Marker));
            return;
        }
        for (GelfLogField field : fields) {
            if (Strings.isNotEmpty((CharSequence)field.getMdc())) {
                mdcGelfMessageAssembler.addField(new MdcMessageField(field.getName(), field.getMdc()));
            }
            if (Strings.isNotEmpty((CharSequence)field.getLiteral())) {
                mdcGelfMessageAssembler.addField(new StaticMessageField(field.getName(), field.getLiteral()));
            }
            if (field.getPatternLayout() == null) continue;
            mdcGelfMessageAssembler.addField(new PatternLogMessageField(field.getName(), null, field.getPatternLayout()));
        }
        if (dynamicFieldArray != null) {
            for (GelfDynamicMdcLogFields gelfDynamicMdcLogFields : dynamicFieldArray) {
                mdcGelfMessageAssembler.addField(new DynamicMdcMessageField(gelfDynamicMdcLogFields.getRegex()));
            }
        }
    }

    public void append(LogEvent event) {
        if (event == null) {
            return;
        }
        try {
            GelfMessage message = this.createGelfMessage(event);
            if (!message.isValid()) {
                this.reportError("GELF Message is invalid: " + message.toJson(), null);
                return;
            }
            if (null == this.gelfSender || !this.gelfSender.sendMessage(message)) {
                this.reportError("Could not send GELF message", null);
            }
        }
        catch (AppenderLoggingException e) {
            throw e;
        }
        catch (Exception e) {
            this.reportError("Could not send GELF message: " + e.getMessage(), e);
        }
    }

    protected GelfMessage createGelfMessage(LogEvent logEvent) {
        return this.gelfMessageAssembler.createGelfMessage(new Log4j2LogEvent(logEvent));
    }

    public void reportError(String message, Exception exception) {
        this.errorReporter.reportError(message, exception);
    }

    public void stop() {
        if (null != this.gelfSender) {
            Closer.close(this.gelfSender);
            this.gelfSender = null;
        }
        super.stop();
    }

    public void start() {
        if (null == this.gelfSender) {
            this.gelfSender = this.createGelfSender();
        }
        super.start();
    }

    protected GelfSender createGelfSender() {
        return GelfSenderFactory.createSender(this.gelfMessageAssembler, this.errorReporter, Collections.EMPTY_MAP);
    }
}

