/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.app.TestPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ConnectionDialog
extends JDialog {
    private JTextField port;
    private JTextField inPort;
    private JTextField outPort;
    private JTextField host;
    private JRadioButton onePort;
    private TestPanel testPanel;

    public ConnectionDialog(TestPanel testPanel) {
        this.testPanel = testPanel;
        this.initUI();
    }

    private void initUI() {
        Box box = new Box(1);
        this.getContentPane().add(box);
        this.host = new JTextField(20);
        JPanel hostPanel = new JPanel();
        hostPanel.add(new JLabel(" Host:  "));
        hostPanel.add(this.host);
        box.add(hostPanel);
        JRadioButton twoPort = new JRadioButton();
        JPanel twoPortPanel = new JPanel();
        ((FlowLayout)twoPortPanel.getLayout()).setAlignment(0);
        twoPortPanel.add(twoPort);
        twoPortPanel.add(new JLabel(" Separate Inbound & Outbound Ports "));
        box.add(twoPortPanel);
        JPanel twoPortPanel2 = new JPanel();
        ((FlowLayout)twoPortPanel2.getLayout()).setAlignment(0);
        twoPortPanel2.add((Component)new JLabel("     Inbound: "), 0);
        this.inPort = new JTextField(5);
        twoPortPanel2.add(this.inPort);
        twoPortPanel2.add(new JLabel(" Outbound: "));
        this.outPort = new JTextField(5);
        twoPortPanel2.add(this.outPort);
        box.add(twoPortPanel2);
        this.onePort = new JRadioButton();
        this.onePort.setSelected(true);
        this.port = new JTextField(5);
        JPanel onePortPanel = new JPanel();
        ((FlowLayout)onePortPanel.getLayout()).setAlignment(0);
        onePortPanel.add((Component)this.onePort, 0);
        onePortPanel.add(new JLabel(" Single Port "));
        onePortPanel.add(this.port);
        box.add(onePortPanel);
        JPanel buttonPanel = new JPanel();
        JButton OK = new JButton("  OK  ");
        JButton cancel = new JButton(" Cancel ");
        buttonPanel.add(OK);
        buttonPanel.add(cancel);
        box.add(buttonPanel);
        ButtonGroup portSelect = new ButtonGroup();
        portSelect.add(twoPort);
        portSelect.add(this.onePort);
        OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.connect();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.close();
            }
        });
        this.pack();
        this.show();
    }

    private void connect() {
        try {
            if (this.onePort.isSelected()) {
                this.testPanel.connect(this.host.getText(), Integer.parseInt(this.port.getText()));
            } else {
                this.testPanel.connect(this.host.getText(), Integer.parseInt(this.inPort.getText()), Integer.parseInt(this.outPort.getText()));
            }
            this.close();
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Invalid port number", "", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), e.getClass().getName(), 0);
        }
    }

    private void close() {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            ConnectionDialog d = new ConnectionDialog(new TestPanel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

