/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.parser.Pointer;
import ca.uhn.hl7v2.parser.SegmentPointer;

public class GroupPointer
extends Pointer {
    private PipeParser parser;
    private Group parent;
    private String name;
    private boolean repeating;
    private EncodingCharacters encodingChars;
    private Pointer[] children;
    private Group currentGroup = null;
    private int childAtWhichToStart;

    public GroupPointer(PipeParser parser, Group parent, int position, EncodingCharacters encodingChars) throws HL7Exception {
        this.parser = parser;
        this.parent = parent;
        this.name = parent.getNames()[position];
        this.repeating = parent.isRepeating(this.name);
        this.encodingChars = encodingChars;
    }

    public int setSegment(String segment, boolean orderedCorrectly) throws HL7Exception {
        int status;
        if (this.currentGroup == null) {
            this.createNewInstance();
        }
        if (((status = this.tryToFillChildren(segment, orderedCorrectly)) == 1 || status == 3) && this.repeating && orderedCorrectly) {
            this.createNewInstance();
            status = this.tryToFillChildren(segment, orderedCorrectly);
        }
        return status;
    }

    private int tryToFillChildren(String segment, boolean orderedCorrectlyInParent) throws HL7Exception {
        int status = 0;
        int c = 0;
        boolean fullOneExists = false;
        boolean rightSegmentWrongOrder = false;
        while (status != 2 && c < this.children.length) {
            boolean orderedCorrectly = orderedCorrectlyInParent;
            if (c < this.childAtWhichToStart) {
                orderedCorrectly = false;
            }
            if ((status = this.children[c++].setSegment(segment, orderedCorrectly)) == 1) {
                fullOneExists = true;
            }
            if (status != 3) continue;
            rightSegmentWrongOrder = true;
        }
        if (fullOneExists && status == 0) {
            status = 1;
        }
        if (rightSegmentWrongOrder && status == 0) {
            status = 3;
        }
        if (status == 2) {
            this.childAtWhichToStart = c - 1;
        }
        return status;
    }

    private void createNewInstance() throws HL7Exception {
        int nextRepNum = this.parent.getAll(this.name).length;
        this.currentGroup = (Group)this.parent.get(this.name, nextRepNum);
        this.childAtWhichToStart = 0;
        String[] childNames = this.currentGroup.getNames();
        this.children = new Pointer[childNames.length];
        int i = 0;
        while (i < childNames.length) {
            Class childClass = this.currentGroup.getClass(childNames[i]);
            Pointer p = Group.class.isAssignableFrom(childClass) ? new GroupPointer(this.parser, this.currentGroup, i, this.encodingChars) : new SegmentPointer(this.parser, this.currentGroup, i, this.encodingChars);
            this.children[i] = p;
            ++i;
        }
    }
}

