/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.DefaultApplication;
import ca.uhn.hl7v2.app.Responder;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.protocol.ApplicationRouter;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.AppRoutingDataImpl;
import ca.uhn.hl7v2.protocol.impl.AppWrapper;
import ca.uhn.hl7v2.protocol.impl.ParseChecker;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ApplicationRouterImpl
implements ApplicationRouter {
    private static final HapiLog log = HapiLogFactory.getHapiLog(ApplicationRouterImpl.class);
    public static String RAW_MESSAGE_KEY = "raw-message";
    private List myBindings;
    private Parser myParser;
    private BufferedWriter checkWriter = null;

    public ApplicationRouterImpl() {
        this.init(new GenericParser());
    }

    public ApplicationRouterImpl(Parser theParser) {
        this.init(theParser);
    }

    private void init(Parser theParser) {
        this.myBindings = new ArrayList(20);
        this.myParser = theParser;
    }

    public Transportable processMessage(Transportable theMessage) throws HL7Exception {
        String[] result = this.processMessage(theMessage.getMessage(), theMessage.getMetadata());
        TransportableImpl response = new TransportableImpl(result[0]);
        if (result[1] != null) {
            response.getMetadata().put("MSH-18", result[1]);
        }
        return response;
    }

    private String[] processMessage(String incomingMessageString, Map theMetadata) throws HL7Exception {
        HapiLog rawOutbound = HapiLogFactory.getHapiLog("ca.uhn.hl7v2.raw.outbound");
        HapiLog rawInbound = HapiLogFactory.getHapiLog("ca.uhn.hl7v2.raw.inbound");
        log.info("ApplicationRouterImpl got message: " + incomingMessageString);
        rawInbound.info(incomingMessageString);
        Message incomingMessageObject = null;
        String outgoingMessageString = null;
        String outgoingMessageCharset = null;
        try {
            incomingMessageObject = this.myParser.parse(incomingMessageString);
        }
        catch (HL7Exception e) {
            outgoingMessageString = Responder.logAndMakeErrorMessage(e, this.myParser.getCriticalResponseData(incomingMessageString), this.myParser, this.myParser.getEncoding(incomingMessageString));
        }
        if (outgoingMessageString == null) {
            try {
                String check = System.getProperty("ca.uhn.hl7v2.protocol.impl.check_parse");
                if (check != null && check.equals("TRUE")) {
                    ParseChecker.checkParse(incomingMessageString, incomingMessageObject, this.myParser);
                }
                ReceivingApplication app = this.findApplication(incomingMessageObject);
                theMetadata.put(RAW_MESSAGE_KEY, incomingMessageString);
                if (log.isDebugEnabled()) {
                    log.debug("Sending message to application: " + app.toString());
                }
                Message response = app.processMessage(incomingMessageObject, theMetadata);
                outgoingMessageString = this.myParser.encode(response, this.myParser.getEncoding(incomingMessageString));
                Terser t = new Terser(response);
                outgoingMessageCharset = t.get("MSH-18");
            }
            catch (Exception e) {
                outgoingMessageString = Responder.logAndMakeErrorMessage(e, (Segment)incomingMessageObject.get("MSH"), this.myParser, this.myParser.getEncoding(incomingMessageString));
            }
        }
        log.info("ApplicationRouterImpl sending message: " + outgoingMessageString);
        rawOutbound.info(outgoingMessageString);
        return new String[]{outgoingMessageString, outgoingMessageCharset};
    }

    public boolean hasActiveBinding(ApplicationRouter.AppRoutingData theRoutingData) {
        boolean result = false;
        ReceivingApplication app = this.findDestination(theRoutingData);
        if (app != null) {
            result = true;
        }
        return result;
    }

    private ReceivingApplication findDestination(ApplicationRouter.AppRoutingData theRoutingData) {
        ReceivingApplication result = null;
        int i = 0;
        while (i < this.myBindings.size() && result == null) {
            Binding binding = (Binding)this.myBindings.get(i);
            if (ApplicationRouterImpl.matches(theRoutingData, binding.routingData) && binding.active) {
                result = binding.application;
            }
            ++i;
        }
        return result;
    }

    private Binding findBinding(ApplicationRouter.AppRoutingData theRoutingData) {
        Binding result = null;
        int i = 0;
        while (i < this.myBindings.size() && result == null) {
            Binding binding = (Binding)this.myBindings.get(i);
            if (theRoutingData.equals(binding.routingData)) {
                result = binding;
            }
            ++i;
        }
        return result;
    }

    public void bindApplication(ApplicationRouter.AppRoutingData theRoutingData, ReceivingApplication theApplication) {
        Binding binding = new Binding(theRoutingData, true, theApplication);
        this.myBindings.add(binding);
    }

    public void disableBinding(ApplicationRouter.AppRoutingData theRoutingData) {
        Binding b = this.findBinding(theRoutingData);
        if (b != null) {
            b.active = false;
        }
    }

    public void enableBinding(ApplicationRouter.AppRoutingData theRoutingData) {
        Binding b = this.findBinding(theRoutingData);
        if (b != null) {
            b.active = true;
        }
    }

    public Parser getParser() {
        return this.myParser;
    }

    public static boolean matches(ApplicationRouter.AppRoutingData theMessageData, ApplicationRouter.AppRoutingData theReferenceData) {
        boolean result = false;
        ApplicationRouter.AppRoutingData ref = theReferenceData;
        ApplicationRouter.AppRoutingData msg = theMessageData;
        if (ApplicationRouterImpl.matches(msg.getMessageType(), ref.getMessageType()) && ApplicationRouterImpl.matches(msg.getTriggerEvent(), ref.getTriggerEvent()) && ApplicationRouterImpl.matches(msg.getProcessingId(), ref.getProcessingId()) && ApplicationRouterImpl.matches(msg.getVersion(), ref.getVersion())) {
            result = true;
        }
        return result;
    }

    private static boolean matches(String theMessageData, String theReferenceData) {
        boolean result = false;
        if (theMessageData.equals(theReferenceData) || theReferenceData.equals("*") || Pattern.matches(theReferenceData, theMessageData)) {
            result = true;
        }
        return result;
    }

    private ReceivingApplication findApplication(Message theMessage) throws HL7Exception {
        Terser t = new Terser(theMessage);
        AppRoutingDataImpl msgData = new AppRoutingDataImpl(t.get("/MSH-9-1"), t.get("/MSH-9-2"), t.get("/MSH-11-1"), t.get("/MSH-12"));
        ReceivingApplication app = this.findDestination(msgData);
        if (app == null) {
            app = new AppWrapper(new DefaultApplication());
        }
        return app;
    }

    private static class Binding {
        public ApplicationRouter.AppRoutingData routingData;
        public boolean active;
        public ReceivingApplication application;

        public Binding(ApplicationRouter.AppRoutingData theRoutingData, boolean isActive, ReceivingApplication theApplication) {
            this.routingData = theRoutingData;
            this.active = isActive;
            this.application = theApplication;
        }
    }
}

