/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageQuery {
    public static Result query(Message theMessage, String theQuery) {
        Properties clauses = MessageQuery.getClauses(theQuery);
        StringTokenizer select = new StringTokenizer(clauses.getProperty("select"), ", ", false);
        ArrayList<String> fieldPaths = new ArrayList<String>(10);
        HashMap<String, Integer> names = new HashMap<String, Integer>(10);
        while (select.hasMoreTokens()) {
            String token = select.nextToken();
            if (token.equals("as")) {
                if (!select.hasMoreTokens()) {
                    throw new IllegalArgumentException("Keyword 'as' must be followed by a field label");
                }
                names.put(select.nextToken(), new Integer(fieldPaths.size() - 1));
                continue;
            }
            fieldPaths.add(token);
        }
        StringTokenizer loop = new StringTokenizer(clauses.getProperty("loop", ""), ",", false);
        ArrayList<String> loopPoints = new ArrayList<String>(10);
        HashMap<String, Integer> loopPointNames = new HashMap<String, Integer>(10);
        while (loop.hasMoreTokens()) {
            String pointDecl = loop.nextToken();
            StringTokenizer tok = new StringTokenizer(pointDecl, "=", false);
            String name = tok.nextToken().trim();
            String path = tok.nextToken().trim();
            loopPoints.add(path);
            loopPointNames.put(name, new Integer(loopPoints.size() - 1));
        }
        StringTokenizer where = new StringTokenizer(clauses.getProperty("where", ""), ",", false);
        ArrayList<String> filters = new ArrayList<String>();
        while (where.hasMoreTokens()) {
            filters.add(where.nextToken());
        }
        String[] filterPaths = new String[filters.size()];
        String[] filterPatterns = new String[filters.size()];
        boolean[] exactFlags = new boolean[filters.size()];
        int i = 0;
        while (i < filters.size()) {
            exactFlags[i] = true;
            String filter = (String)filters.get(i);
            String[] parts = MessageQuery.splitFromEnd(filter, "=");
            if (parts[1] != null) {
                parts[1] = parts[1].substring(1);
            } else {
                exactFlags[i] = false;
                parts = MessageQuery.splitFromEnd(filter, "like");
                parts[1] = parts[1].substring(4);
            }
            filterPaths[i] = parts[0].trim();
            parts[1] = parts[1].trim();
            filterPatterns[i] = parts[1].substring(1, parts[1].length() - 1);
            ++i;
        }
        return new ResultImpl(theMessage, loopPoints.toArray(new String[0]), loopPointNames, fieldPaths.toArray(new String[0]), names, filterPaths, filterPatterns, exactFlags);
    }

    private static Properties getClauses(String theQuery) {
        Properties clauses = new Properties();
        String[] split = MessageQuery.splitFromEnd(theQuery, "where ");
        MessageQuery.setClause(clauses, "where", split[1]);
        split = MessageQuery.splitFromEnd(split[0], "loop ");
        MessageQuery.setClause(clauses, "loop", split[1]);
        MessageQuery.setClause(clauses, "select", split[0]);
        if (clauses.getProperty("where", "").indexOf("loop ") >= 0) {
            throw new IllegalArgumentException("The loop clause must precede the where clause");
        }
        if (clauses.getProperty("select") == null) {
            throw new IllegalArgumentException("The query must begin with a select clause");
        }
        return clauses;
    }

    private static void setClause(Properties theClauses, String theName, String theClause) {
        if (theClause != null) {
            theClauses.setProperty(theName, theClause.substring(theName.length()).trim());
        }
    }

    private static String[] splitFromEnd(String theString, String theMarker) {
        String[] result = new String[2];
        int begin = theString.indexOf(theMarker);
        if (begin >= 0) {
            result[0] = theString.substring(0, begin);
            result[1] = theString.substring(begin);
        } else {
            result[0] = theString;
        }
        return result;
    }

    public static interface Result {
        public String get(int var1);

        public String get(String var1);

        public String[] getNamedFields();

        public boolean next() throws HL7Exception;
    }

    private static class ResultImpl
    implements Result {
        private Terser myTerser;
        private String[] myValues;
        private String[] myLoopPoints;
        private Map myLoopPointNames;
        private String[] myFieldPaths;
        private Map myFieldNames;
        private int[] myIndices;
        private int[] myNumEmpty;
        private int[] myMaxNumEmpty;
        private boolean myNonLoopingQuery = false;
        private String[] myWherePaths;
        private String[] myWhereValues;
        private String[] myWherePatterns;
        private boolean[] myExactMatchFlags;

        public ResultImpl(Message theMessage, String[] theLoopPoints, Map theLoopPointNames, String[] theFieldPaths, Map theFieldNames, String[] theWherePaths, String[] theWherePatterns, boolean[] theExactMatchFlags) {
            this.myTerser = new Terser(theMessage);
            this.myLoopPoints = theLoopPoints;
            this.myIndices = new int[theLoopPoints.length];
            this.myNumEmpty = new int[theLoopPoints.length];
            this.myMaxNumEmpty = this.getMaxNumEmpty(theLoopPoints);
            this.myLoopPointNames = theLoopPointNames;
            this.myFieldPaths = theFieldPaths;
            this.myValues = new String[theFieldPaths.length];
            this.myFieldNames = theFieldNames;
            this.myWherePaths = theWherePaths;
            this.myWherePatterns = theWherePatterns;
            this.myExactMatchFlags = theExactMatchFlags;
            if (theLoopPoints.length == 0) {
                this.myNonLoopingQuery = true;
            } else {
                this.myIndices[this.myIndices.length - 1] = -1;
            }
        }

        private int[] getMaxNumEmpty(String[] theLoopPoints) {
            int[] retVal = new int[theLoopPoints.length];
            int i = 0;
            while (i < theLoopPoints.length) {
                retVal[i] = this.getMaxNumEmpty(theLoopPoints[i]);
                ++i;
            }
            return retVal;
        }

        private int getMaxNumEmpty(String theLoopPoint) {
            int retVal = 0;
            Matcher m = Pattern.compile("\\*(\\d+)").matcher(theLoopPoint);
            if (m.find()) {
                String num = m.group(1);
                retVal = Integer.parseInt(num);
            }
            return retVal;
        }

        private boolean currentRowValued(int theLoopPoint) {
            int i = 0;
            while (i < this.myFieldPaths.length) {
                String value;
                if (this.referencesLoop(this.myFieldPaths[i], theLoopPoint) && (value = this.myValues[i]) != null && value.length() > 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean currentRowMatchesFilter() {
            int i = 0;
            while (i < this.myWhereValues.length) {
                if (this.myExactMatchFlags[i] ? !this.myWherePatterns[i].equals(this.myWhereValues[i]) : !Pattern.matches(this.myWherePatterns[i], this.myWhereValues[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean referencesLoop(String theFieldPath, int theLoopPoint) {
            int lp;
            String path = theFieldPath;
            while ((lp = this.getLoopPointReference(path)) >= 0) {
                if (lp == theLoopPoint) {
                    return true;
                }
                path = this.myLoopPoints[lp];
            }
            return false;
        }

        private String[] getCurrentValues(String[] thePaths) throws HL7Exception {
            String[] paths = this.composePaths(thePaths);
            String[] values = new String[paths.length];
            int i = 0;
            while (i < paths.length) {
                values[i] = this.myTerser.get(paths[i]);
                if (values[i] == null) {
                    values[i] = "";
                }
                ++i;
            }
            return values;
        }

        private String[] composePaths(String[] thePaths) {
            String[] currentLoopPoints = this.composeLoopPoints();
            String[] result = new String[thePaths.length];
            int i = 0;
            while (i < thePaths.length) {
                result[i] = thePaths[i];
                int ref = this.getLoopPointReference(thePaths[i]);
                if (ref >= 0) {
                    result[i] = this.expandLoopPointReference(result[i], currentLoopPoints[ref]);
                }
                ++i;
            }
            return result;
        }

        private String[] composeLoopPoints() {
            String[] result = new String[this.myLoopPoints.length];
            int i = 0;
            while (i < this.myLoopPoints.length) {
                result[i] = this.myLoopPoints[i].replaceAll("\\*\\d*", String.valueOf(this.myIndices[i]));
                int ref = this.getLoopPointReference(this.myLoopPoints[i]);
                if (ref >= i) {
                    throw new IllegalStateException("Loop point must be defined after the one it references: " + this.myLoopPoints[i]);
                }
                if (ref >= 0) {
                    result[i] = this.expandLoopPointReference(result[i], result[ref]);
                }
                ++i;
            }
            return result;
        }

        private int getLoopPointReference(String thePath) {
            StringTokenizer tok = new StringTokenizer(thePath, "{}", false);
            if (thePath.indexOf(123) >= 0 && tok.hasMoreTokens()) {
                String ref = tok.nextToken();
                return (Integer)this.myLoopPointNames.get(ref);
            }
            return -1;
        }

        private String expandLoopPointReference(String thePath, String theLoopPoint) {
            return thePath.replaceAll("\\{.*\\}", theLoopPoint);
        }

        public String get(int theFieldNumber) {
            if (theFieldNumber < 0 || theFieldNumber >= this.myValues.length) {
                throw new IllegalArgumentException("Field number must be between 0 and " + (this.myValues.length - 1));
            }
            return this.myValues[theFieldNumber];
        }

        public String get(String theFieldName) {
            Integer fieldNum = (Integer)this.myFieldNames.get(theFieldName);
            if (fieldNum == null) {
                throw new IllegalArgumentException("Field name not recognized: " + theFieldName);
            }
            return this.get(fieldNum);
        }

        public boolean next() throws HL7Exception {
            if (this.myNonLoopingQuery) {
                this.myNonLoopingQuery = false;
                this.myValues = this.getCurrentValues(this.myFieldPaths);
                this.myWhereValues = this.getCurrentValues(this.myWherePaths);
                return this.currentRowMatchesFilter();
            }
            boolean hasNext = false;
            int i = this.myIndices.length - 1;
            while (i >= 0) {
                boolean gotMatch = false;
                while (!gotMatch && this.myNumEmpty[i] <= this.myMaxNumEmpty[i]) {
                    int n = i;
                    this.myIndices[n] = this.myIndices[n] + 1;
                    this.myValues = this.getCurrentValues(this.myFieldPaths);
                    this.myWhereValues = this.getCurrentValues(this.myWherePaths);
                    if (!this.currentRowValued(i)) {
                        int n2 = i;
                        this.myNumEmpty[n2] = this.myNumEmpty[n2] + 1;
                    } else {
                        this.myNumEmpty[i] = 0;
                    }
                    if (!this.currentRowMatchesFilter()) continue;
                    gotMatch = true;
                }
                boolean bl = hasNext = this.myNumEmpty[i] <= this.myMaxNumEmpty[i];
                if (hasNext) break;
                this.myIndices[i] = 0;
                this.myNumEmpty[i] = 0;
                --i;
            }
            return hasNext;
        }

        public String[] getNamedFields() {
            return this.myFieldNames.keySet().toArray(new String[0]);
        }
    }
}

