/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.FilterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ReadOnlyMessageIterator
implements Iterator {
    private List myRemaining = new ArrayList(40);

    public ReadOnlyMessageIterator(Group theRoot) {
        this.addChildren(theRoot);
    }

    public static Iterator createPopulatedSegmentIterator(Group theRoot) {
        ReadOnlyMessageIterator allIterator = new ReadOnlyMessageIterator(theRoot);
        FilterIterator.Predicate segmentsOnly = new FilterIterator.Predicate(){

            public boolean evaluate(Object obj) {
                return Segment.class.isAssignableFrom(obj.getClass());
            }
        };
        FilterIterator segmentIterator = new FilterIterator(allIterator, segmentsOnly);
        final EncodingCharacters ec = new EncodingCharacters('|', "^~\\&");
        FilterIterator.Predicate populatedOnly = new FilterIterator.Predicate(){

            public boolean evaluate(Object obj) {
                String encoded = PipeParser.encode((Segment)obj, ec);
                return encoded.length() > 3;
            }
        };
        return new FilterIterator(segmentIterator, populatedOnly);
    }

    private void addChildren(Group theParent) {
        String[] names = theParent.getNames();
        int i = names.length - 1;
        while (i >= 0) {
            try {
                Structure[] reps = theParent.getAll(names[i]);
                int j = reps.length - 1;
                while (j >= 0) {
                    this.myRemaining.add(reps[j]);
                    --j;
                }
            }
            catch (HL7Exception e) {
                throw new Error("Internal error: an invalid child name was obtained from its parent.");
            }
            --i;
        }
    }

    public boolean hasNext() {
        return !this.myRemaining.isEmpty();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more nodes in message");
        }
        Structure next = (Structure)this.myRemaining.remove(this.myRemaining.size() - 1);
        if (next instanceof Group) {
            this.addChildren((Group)next);
        }
        return next;
    }

    public void remove() {
        throw new UnsupportedOperationException("Can't remove a node from a message");
    }
}

