/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.BRP_O30_TIMING;
import ca.uhn.hl7v2.model.v251.segment.BPO;
import ca.uhn.hl7v2.model.v251.segment.BPX;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class BRP_O30_ORDER
extends AbstractGroup {
    public BRP_O30_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(BRP_O30_TIMING.class, false, true);
            this.add(BPO.class, false, false);
            this.add(BPX.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating BRP_O30_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BRP_O30_TIMING getTIMING() {
        BRP_O30_TIMING ret = null;
        try {
            ret = (BRP_O30_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BRP_O30_TIMING getTIMING(int rep) {
        BRP_O30_TIMING ret = null;
        try {
            ret = (BRP_O30_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTIMING(BRP_O30_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public BRP_O30_TIMING insertTIMING(int rep) throws HL7Exception {
        return (BRP_O30_TIMING)super.insertRepetition("TIMING", rep);
    }

    public BRP_O30_TIMING removeTIMING(int rep) throws HL7Exception {
        return (BRP_O30_TIMING)super.removeRepetition("TIMING", rep);
    }

    public BPO getBPO() {
        BPO ret = null;
        try {
            ret = (BPO)this.get("BPO");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BPX getBPX() {
        BPX ret = null;
        try {
            ret = (BPX)this.get("BPX");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BPX getBPX(int rep) {
        BPX ret = null;
        try {
            ret = (BPX)this.get("BPX", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getBPXReps() {
        int reps = -1;
        try {
            reps = this.getAll("BPX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertBPX(BPX structure, int rep) throws HL7Exception {
        super.insertRepetition("BPX", (Structure)structure, rep);
    }

    public BPX insertBPX(int rep) throws HL7Exception {
        return (BPX)super.insertRepetition("BPX", rep);
    }

    public BPX removeBPX(int rep) throws HL7Exception {
        return (BPX)super.removeRepetition("BPX", rep);
    }
}

