/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.common.util;

import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class URLEncoder {
    public static String encode(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 0; i < s.length(); ++i) {
                byte[] bytes;
                char c = s.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~') {
                    sb.append(c);
                    continue;
                }
                for (byte b : bytes = ("" + c).getBytes("UTF-8")) {
                    sb.append('%');
                    int upper = b >> 4 & 0xF;
                    sb.append(Integer.toHexString(upper).toUpperCase(Locale.US));
                    int lower = b & 0xF;
                    sb.append(Integer.toHexString(lower).toUpperCase(Locale.US));
                }
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("UTF-8 unsupported!?", uee);
        }
    }
}

