/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.care;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.message.Media;
import com.riversoft.weixin.common.message.News;
import com.riversoft.weixin.common.message.Text;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.care.bean.Card;
import com.riversoft.weixin.mp.care.bean.Music;
import com.riversoft.weixin.mp.care.bean.Video;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CareMessages {
    private static Logger logger = LoggerFactory.getLogger(CareMessages.class);
    private WxClient wxClient;

    public static CareMessages defaultCareMessages() {
        return CareMessages.with(AppSetting.defaultSettings());
    }

    public static CareMessages with(AppSetting appSetting) {
        CareMessages messages = new CareMessages();
        messages.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return messages;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public void text(String openId, String text) {
        this.text(openId, text, null);
    }

    public void text(String openId, String text, String from) {
        Map<String, Object> request = this.initMessage(openId, "text", from);
        request.put("text", new Text(text));
        String url = WxEndpoint.get("url.care.message.send");
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(request));
    }

    public void image(String openId, String image) {
        this.image(openId, image, null);
    }

    public void image(String openId, String image, String from) {
        Map<String, Object> request = this.initMessage(openId, "image", from);
        request.put("image", new Media(image));
        String url = WxEndpoint.get("url.care.message.send");
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(request));
    }

    public void voice(String openId, String voice) {
        this.voice(openId, voice, null);
    }

    public void voice(String openId, String voice, String from) {
        Map<String, Object> request = this.initMessage(openId, "voice", from);
        request.put("voice", new Media(voice));
        String url = WxEndpoint.get("url.care.message.send");
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(request));
    }

    public void video(String openId, Video video) {
        this.video(openId, video, null);
    }

    public void video(String openId, Video video, String from) {
        Map<String, Object> request = this.initMessage(openId, "video", from);
        request.put("video", video);
        String url = WxEndpoint.get("url.care.message.send");
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(request));
    }

    public void music(String openId, Music music) {
        this.music(openId, music, null);
    }

    public void music(String openId, Music music, String from) {
        Map<String, Object> request = this.initMessage(openId, "music", from);
        request.put("music", music);
        String url = WxEndpoint.get("url.care.message.send");
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(request));
    }

    public void news(String openId, News news) {
        this.news(openId, news, null);
    }

    public void news(String openId, News news, String from) {
        Map<String, Object> request = this.initMessage(openId, "news", from);
        request.put("news", news);
        String url = WxEndpoint.get("url.care.message.send");
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(request));
    }

    public void mpNews(String openId, String mpNews) {
        this.mpNews(openId, mpNews, null);
    }

    public void mpNews(String openId, String mpNews, String from) {
        Map<String, Object> request = this.initMessage(openId, "mpnews", from);
        request.put("mpnews", new Media(mpNews));
        String url = WxEndpoint.get("url.care.message.send");
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(request));
    }

    public void card(String openId, String cardId) {
        this.card(openId, cardId, null);
    }

    public void card(String openId, String cardId, String from) {
        Map<String, Object> request = this.initMessage(openId, "wxcard", from);
        request.put("wxcard", new Card(cardId));
        String url = WxEndpoint.get("url.care.message.send");
        this.wxClient.post(url, JsonMapper.defaultMapper().toJson(request));
    }

    private Map<String, Object> initMessage(String openId, String msgType, String from) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("msgtype", msgType);
        request.put("touser", openId);
        if (from != null && !"".equals(from)) {
            request.put("customservice", new KfAccount(from));
        }
        return request;
    }

    public static class KfAccount {
        @JsonProperty(value="kf_account")
        private String account;

        public KfAccount(String account) {
            this.account = account;
        }

        public String getAccount() {
            return this.account;
        }

        public void setAccount(String account) {
            this.account = account;
        }
    }
}

