/*
 * Decompiled with CFR 0.152.
 */
package com.riversoft.weixin.mp.shop;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.riversoft.weixin.common.WxClient;
import com.riversoft.weixin.common.util.JsonMapper;
import com.riversoft.weixin.mp.MpWxClientFactory;
import com.riversoft.weixin.mp.base.AppSetting;
import com.riversoft.weixin.mp.base.WxEndpoint;
import com.riversoft.weixin.mp.shop.Order;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Orders {
    private static Logger logger = LoggerFactory.getLogger(Orders.class);
    private WxClient wxClient;

    public static Orders defaultOrders() {
        return Orders.with(AppSetting.defaultSettings());
    }

    public static Orders with(AppSetting appSetting) {
        Orders orders = new Orders();
        orders.setWxClient(MpWxClientFactory.getInstance().with(appSetting));
        return orders;
    }

    public void setWxClient(WxClient wxClient) {
        this.wxClient = wxClient;
    }

    public Order get(String id) {
        String url = WxEndpoint.get("shop.order.get");
        String body = String.format("{\"order_id\":\"%s\"}", id);
        logger.debug("shop: get order by id: {}", (Object)id);
        String response = this.wxClient.post(url, body);
        OrderWrapper orderWrapper = (OrderWrapper)JsonMapper.defaultMapper().fromJson(response, OrderWrapper.class);
        return orderWrapper.getOrder();
    }

    public List<Order> query(Integer status, Date start, Date end) {
        String url = WxEndpoint.get("shop.order.query");
        HashMap<String, Number> map = new HashMap<String, Number>();
        if (status != null) {
            map.put("status", status);
        }
        if (start != null) {
            map.put("begintime", start.getTime() / 1000L);
        }
        if (end != null) {
            map.put("endtime", start.getTime() / 1000L);
        }
        String body = JsonMapper.defaultMapper().toJson(map);
        logger.debug("shop: query orders: {}", (Object)body);
        String response = this.wxClient.post(url, body);
        OrderList orderList = (OrderList)JsonMapper.defaultMapper().fromJson(response, OrderList.class);
        return orderList.getOrders();
    }

    public static class OrderList {
        private int errcode;
        private String errmsg;
        @JsonProperty(value="order_list")
        private List<Order> orders;

        public int getErrcode() {
            return this.errcode;
        }

        public void setErrcode(int errcode) {
            this.errcode = errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public List<Order> getOrders() {
            return this.orders;
        }

        public void setOrders(List<Order> orders) {
            this.orders = orders;
        }
    }

    public static class OrderWrapper {
        private Order order;

        public Order getOrder() {
            return this.order;
        }

        public void setOrder(Order order) {
            this.order = order;
        }
    }
}

