/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.bloomfilter.filter;

import cn.hutool.bloomfilter.BloomFilter;
import cn.hutool.bloomfilter.bitMap.BitMap;
import cn.hutool.bloomfilter.bitMap.IntMap;
import cn.hutool.bloomfilter.bitMap.LongMap;

public abstract class AbstractFilter
implements BloomFilter {
    private BitMap bm = null;
    protected long size = 0L;

    public AbstractFilter(long maxValue, int machineNum) {
        this.init(maxValue, machineNum);
    }

    public AbstractFilter(long maxValue) {
        this(maxValue, 32);
    }

    public void init(long maxValue, int machineNum) {
        this.size = maxValue;
        switch (machineNum) {
            case 32: {
                this.bm = new IntMap((int)(this.size / (long)machineNum));
                break;
            }
            case 64: {
                this.bm = new LongMap((int)(this.size / (long)machineNum));
                break;
            }
            default: {
                throw new RuntimeException("Error Machine number!");
            }
        }
    }

    @Override
    public boolean contains(String str) {
        return this.bm.contains(Math.abs(this.hash(str)));
    }

    @Override
    public boolean add(String str) {
        long hash = Math.abs(this.hash(str));
        if (this.bm.contains(hash)) {
            return false;
        }
        this.bm.add(hash);
        return true;
    }

    public abstract long hash(String var1);
}

