/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.reader;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.reader.AbstractSheetReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;

public class MapSheetReader
extends AbstractSheetReader<List<Map<String, Object>>> {
    private final int headerRowIndex;

    public MapSheetReader(int headerRowIndex, int startRowIndex, int endRowIndex) {
        super(startRowIndex, endRowIndex);
        this.headerRowIndex = headerRowIndex;
    }

    @Override
    public List<Map<String, Object>> read(Sheet sheet) {
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum < 0) {
            return ListUtil.empty();
        }
        if (this.headerRowIndex < firstRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format("Header row index {} is lower than first row index {}.", this.headerRowIndex, firstRowNum));
        }
        if (this.headerRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format("Header row index {} is greater than last row index {}.", this.headerRowIndex, lastRowNum));
        }
        if (this.startRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format("startRowIndex row index {} is greater than last row index {}.", this.startRowIndex, lastRowNum));
        }
        int startRowIndex = Math.max(this.startRowIndex, firstRowNum);
        int endRowIndex = Math.min(this.endRowIndex, lastRowNum);
        List<String> headerList = this.aliasHeader(this.readRow(sheet, this.headerRowIndex));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(endRowIndex - startRowIndex + 1);
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList;
            if (i == this.headerRowIndex || !CollUtil.isNotEmpty(rowList = this.readRow(sheet, i)) && this.ignoreEmptyRow) continue;
            result.add(IterUtil.toMap(headerList, rowList, true));
        }
        return result;
    }
}

