/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class VariableWidthHistogramAggregation
implements AggregationVariant,
JsonpSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final Integer buckets;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Integer initialBuffer;
    public static final JsonpDeserializer<VariableWidthHistogramAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VariableWidthHistogramAggregation::setupVariableWidthHistogramAggregationDeserializer);

    private VariableWidthHistogramAggregation(Builder builder) {
        this.field = builder.field;
        this.buckets = builder.buckets;
        this.shardSize = builder.shardSize;
        this.initialBuffer = builder.initialBuffer;
    }

    public static VariableWidthHistogramAggregation of(Function<Builder, ObjectBuilder<VariableWidthHistogramAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.VariableWidthHistogram;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Integer buckets() {
        return this.buckets;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final Integer initialBuffer() {
        return this.initialBuffer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.buckets != null) {
            generator.writeKey("buckets");
            generator.write(this.buckets.intValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.initialBuffer != null) {
            generator.writeKey("initial_buffer");
            generator.write(this.initialBuffer.intValue());
        }
    }

    protected static void setupVariableWidthHistogramAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::buckets, JsonpDeserializer.integerDeserializer(), "buckets");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::initialBuffer, JsonpDeserializer.integerDeserializer(), "initial_buffer");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<VariableWidthHistogramAggregation> {
        @Nullable
        private String field;
        @Nullable
        private Integer buckets;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Integer initialBuffer;

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder buckets(@Nullable Integer value) {
            this.buckets = value;
            return this;
        }

        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public final Builder initialBuffer(@Nullable Integer value) {
            this.initialBuffer = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public VariableWidthHistogramAggregation build() {
            this._checkSingleUse();
            return new VariableWidthHistogramAggregation(this);
        }
    }
}

