/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class FingerprintTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final int maxOutputSize;
    private final String separator;
    public static final JsonpDeserializer<FingerprintTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FingerprintTokenFilter::setupFingerprintTokenFilterDeserializer);

    private FingerprintTokenFilter(Builder builder) {
        super(builder);
        this.maxOutputSize = ApiTypeHelper.requireNonNull(builder.maxOutputSize, this, "maxOutputSize");
        this.separator = ApiTypeHelper.requireNonNull(builder.separator, this, "separator");
    }

    public static FingerprintTokenFilter of(Function<Builder, ObjectBuilder<FingerprintTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Fingerprint;
    }

    public final int maxOutputSize() {
        return this.maxOutputSize;
    }

    public final String separator() {
        return this.separator;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "fingerprint");
        super.serializeInternal(generator, mapper);
        generator.writeKey("max_output_size");
        generator.write(this.maxOutputSize);
        generator.writeKey("separator");
        generator.write(this.separator);
    }

    protected static void setupFingerprintTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::maxOutputSize, JsonpDeserializer.integerDeserializer(), "max_output_size");
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FingerprintTokenFilter> {
        private Integer maxOutputSize;
        private String separator;

        public final Builder maxOutputSize(int value) {
            this.maxOutputSize = value;
            return this;
        }

        public final Builder separator(String value) {
            this.separator = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FingerprintTokenFilter build() {
            this._checkSingleUse();
            return new FingerprintTokenFilter(this);
        }
    }
}

