/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.GoogleAiServiceType;
import co.elastic.clients.elasticsearch.inference.GoogleAiStudioServiceSettings;
import co.elastic.clients.elasticsearch.inference.GoogleAiStudioTaskType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutGoogleaistudioResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutGoogleaistudioRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String googleaistudioInferenceId;
    private final GoogleAiServiceType service;
    private final GoogleAiStudioServiceSettings serviceSettings;
    private final GoogleAiStudioTaskType taskType;
    public static final JsonpDeserializer<PutGoogleaistudioRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutGoogleaistudioRequest::setupPutGoogleaistudioRequestDeserializer);
    public static final Endpoint<PutGoogleaistudioRequest, PutGoogleaistudioResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutGoogleaistudioRequest, PutGoogleaistudioResponse>("es/inference.put_googleaistudio", request -> "PUT", request -> {
        boolean _googleaistudioInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.googleaistudioInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _googleaistudioInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("googleaistudioInferenceId", request.googleaistudioInferenceId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutGoogleaistudioResponse._DESERIALIZER);

    private PutGoogleaistudioRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.googleaistudioInferenceId = ApiTypeHelper.requireNonNull(builder.googleaistudioInferenceId, this, "googleaistudioInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
    }

    public static PutGoogleaistudioRequest of(Function<Builder, ObjectBuilder<PutGoogleaistudioRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String googleaistudioInferenceId() {
        return this.googleaistudioInferenceId;
    }

    public final GoogleAiServiceType service() {
        return this.service;
    }

    public final GoogleAiStudioServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    public final GoogleAiStudioTaskType taskType() {
        return this.taskType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
    }

    protected static void setupPutGoogleaistudioRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, GoogleAiServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, GoogleAiStudioServiceSettings._DESERIALIZER, "service_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutGoogleaistudioRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String googleaistudioInferenceId;
        private GoogleAiServiceType service;
        private GoogleAiStudioServiceSettings serviceSettings;
        private GoogleAiStudioTaskType taskType;

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder googleaistudioInferenceId(String value) {
            this.googleaistudioInferenceId = value;
            return this;
        }

        public final Builder service(GoogleAiServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(GoogleAiStudioServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<GoogleAiStudioServiceSettings.Builder, ObjectBuilder<GoogleAiStudioServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new GoogleAiStudioServiceSettings.Builder()).build());
        }

        public final Builder taskType(GoogleAiStudioTaskType value) {
            this.taskType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutGoogleaistudioRequest build() {
            this._checkSingleUse();
            return new PutGoogleaistudioRequest(this);
        }
    }
}

