/*
 * Decompiled with CFR 0.152.
 */
package com.aeon.retail.middleend.sdk.service;

import com.aeon.retail.middleend.sdk.enums.VersionEnum;
import com.aeon.retail.middleend.sdk.util.AesUtils;
import com.aeon.retail.middleend.sdk.util.SignUtils;
import java.net.URLEncoder;
import java.util.Map;

public class InvoiceUrlGenerator {
    @Deprecated
    public static String getInvoiceUrl(String url, Map<String, Object> params, String signKey) throws Exception {
        String channel = InvoiceUrlGenerator.convertObj2Str(params.get("channel"));
        String version = InvoiceUrlGenerator.convertObj2Str(params.get("version"));
        VersionEnum versionEnum = VersionEnum.getEnumByVersion(version);
        String aesData = InvoiceUrlGenerator.getAesData(versionEnum, params);
        String sign = SignUtils.getEcdsaSign(params, signKey);
        String urlEncodeSign = URLEncoder.encode(sign, "UTF-8");
        return InvoiceUrlGenerator.getUrl(url, aesData, channel, versionEnum, urlEncodeSign);
    }

    public static String getInvoiceUrl(String url, Map<String, Object> params, String salt, Integer times) throws Exception {
        String channel = InvoiceUrlGenerator.convertObj2Str(params.get("channel"));
        String version = InvoiceUrlGenerator.convertObj2Str(params.get("version"));
        VersionEnum versionEnum = VersionEnum.getEnumByVersion(version);
        String aesData = InvoiceUrlGenerator.getAesData(versionEnum, params);
        String sign = SignUtils.getMd5Sign(params, salt, times);
        String urlEncodeSign = URLEncoder.encode(sign, "UTF-8");
        return InvoiceUrlGenerator.getUrl(url, aesData, channel, versionEnum, urlEncodeSign);
    }

    private static String getAesData(VersionEnum version, Map<String, Object> params) throws Exception {
        String aesData = null;
        if (version != null) {
            switch (version) {
                case first: {
                    aesData = InvoiceUrlGenerator.getFirstVersionAesData(params);
                    break;
                }
                case second: {
                    aesData = InvoiceUrlGenerator.getSecondVersionAesData(params);
                }
            }
        }
        return aesData;
    }

    private static String getUrl(String url, String data, String channel, VersionEnum version, String sign) {
        String invoiceUrl = url;
        invoiceUrl = url != null && url.indexOf("?") == -1 ? invoiceUrl + "?" : invoiceUrl + "&";
        invoiceUrl = version == VersionEnum.first ? invoiceUrl + "data=" + data + "&channel=" + channel + "&version=" + version.getVersion() + "&sign=" + sign : (version == VersionEnum.second ? invoiceUrl + "d=" + data + "_" + channel + "_" + version.getVersion() + "_" + sign : invoiceUrl + "d=");
        return invoiceUrl;
    }

    private static String getFirstVersionAesData(Map<String, Object> params) throws Exception {
        String outerOrderId = InvoiceUrlGenerator.convertObj2Str(params.get("outerOrderId"));
        String key = InvoiceUrlGenerator.convertObj2Str(params.get("key"));
        String printTime = InvoiceUrlGenerator.convertObj2Str(params.get("printTime"));
        String shopId = InvoiceUrlGenerator.convertObj2Str(params.get("shopId"));
        String userId = InvoiceUrlGenerator.convertObj2Str(params.get("userId"));
        String _data = "outerOrderId=" + outerOrderId + "&printTime=" + printTime + "&shopId=" + shopId + "&userId=" + userId;
        String data = AesUtils.encrypt(_data, key);
        String urlEncodeData = URLEncoder.encode(data, "UTF-8");
        return urlEncodeData;
    }

    private static String getSecondVersionAesData(Map<String, Object> params) throws Exception {
        String outerOrderId = InvoiceUrlGenerator.convertObj2Str(params.get("outerOrderId"));
        String key = InvoiceUrlGenerator.convertObj2Str(params.get("key"));
        String userId = InvoiceUrlGenerator.convertObj2Str(params.get("userId"));
        String _data = outerOrderId + "/" + userId;
        String data = AesUtils.encrypt(_data, key);
        String urlEncodeData = URLEncoder.encode(data, "UTF-8");
        return urlEncodeData;
    }

    private static String convertObj2Str(Object obj) {
        if (obj != null) {
            return obj.toString().trim();
        }
        return "";
    }
}

