/*
 * Decompiled with CFR 0.152.
 */
package com.aeon.retail.middleend.sdk.util;

import com.aeon.retail.middleend.sdk.util.EcDsaUtils;
import com.aeon.retail.middleend.sdk.util.Md5Utils;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class SignUtils {
    public static String getEcdsaSign(Map<String, Object> params, String signKey) throws Exception {
        String content = SignUtils.getSignContent(params);
        String sign = null;
        if (content != null && content.length() > 0) {
            sign = EcDsaUtils.sign(content, signKey);
        }
        return sign;
    }

    public static String getMd5Sign(Map<String, Object> params, String salt, Integer times) throws Exception {
        String content = SignUtils.getSignContent(params);
        String sign = null;
        if (content != null && content.length() > 0) {
            sign = Md5Utils.md5(content, salt, times);
        }
        return sign;
    }

    private static String getSignContent(Map<String, Object> map) {
        String content = "";
        Map<String, Object> sortMap = SignUtils.sortMapByKey(map);
        if (sortMap != null && !sortMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : sortMap.entrySet()) {
                String value = entry.getValue() != null ? String.valueOf(entry.getValue()).trim() : "";
                content = content + value;
            }
        }
        return content;
    }

    private static Map<String, Object> sortMapByKey(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        TreeMap<String, Object> sortMap = new TreeMap<String, Object>(Comparator.naturalOrder());
        sortMap.putAll(map);
        return sortMap;
    }
}

