/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.test;

import java.util.HashSet;
import java.util.LinkedList;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionMatcher<T extends Throwable>
extends BaseMatcher<T> {
    private final Matcher<?> exceptionMatcher;
    private final Matcher<?> causeExceptionMatcher;
    private final Matcher<?> messageMatcher;
    private final Class<? extends Throwable> cause;

    public ExceptionMatcher(String ... snippets) {
        this((Class<Throwable>)null, snippets);
    }

    public ExceptionMatcher(Class<? extends Throwable> cause, String ... snippets) {
        LinkedList<Matcher> matchers = new LinkedList<Matcher>();
        matchers.add(Matchers.notNullValue());
        matchers.add(Matchers.instanceOf(Throwable.class));
        this.exceptionMatcher = Matchers.allOf(matchers);
        if (cause != null) {
            matchers = new LinkedList();
            matchers.add(Matchers.notNullValue());
            matchers.add(Matchers.instanceOf(cause));
            this.causeExceptionMatcher = Matchers.allOf(matchers);
        } else {
            this.causeExceptionMatcher = null;
        }
        this.cause = cause;
        if (snippets != null && snippets.length > 0) {
            matchers = new LinkedList();
            for (String snippet : snippets) {
                matchers.add(Matchers.containsString((String)snippet));
            }
            this.messageMatcher = Matchers.allOf(matchers);
        } else {
            this.messageMatcher = null;
        }
    }

    public boolean matches(Object item) {
        Throwable top;
        Throwable t;
        if (!this.exceptionMatcher.matches(item)) {
            return false;
        }
        if (this.causeExceptionMatcher != null) {
            HashSet<Throwable> visited = new HashSet<Throwable>();
            for (t = top = (Throwable)item; t != null && !this.cause.isInstance(t) && !visited.contains(t); t = t.getCause()) {
                visited.add(t);
            }
            if (!this.causeExceptionMatcher.matches((Object)t)) {
                return false;
            }
        }
        if (this.messageMatcher == null) {
            return true;
        }
        String message = t.getMessage();
        if (t != top) {
            message = message + "\n" + top.getMessage();
        }
        return this.messageMatcher.matches((Object)message);
    }

    public void describeTo(Description description) {
        description.appendText("An exception that is ").appendDescriptionOf(this.exceptionMatcher);
        if (this.causeExceptionMatcher != null) {
            description.appendText("\n  and its cause exception is ").appendDescriptionOf(this.causeExceptionMatcher);
        }
        if (this.messageMatcher != null) {
            description.appendText("\n  and its message is ").appendDescriptionOf(this.messageMatcher);
        }
    }
}

