/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.test;

import com.alibaba.citrus.logconfig.LogConfigurator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

public class TestEnv {
    private Params params = this.createParams();
    private File basedir;
    private File srcdir;
    private File destdir;

    public TestEnv setBasedir(String basedir) {
        this.getParams().basedirParam = basedir;
        return this;
    }

    public TestEnv setSrcdir(String srcdir) {
        this.getParams().srcdirParam = srcdir;
        return this;
    }

    public TestEnv setDestdir(String destdir) {
        this.getParams().destdirParam = destdir;
        return this;
    }

    public TestEnv setLogbackConfig(String logbackConfig) {
        this.getParams().logbackConfigParam = logbackConfig;
        return this;
    }

    public TestEnv setInitFailure(Exception initFailure) {
        this.getParams().initFailure = initFailure;
        return this;
    }

    public TestEnv init() {
        Params params = this.getParams();
        if (params.inited) {
            return this;
        }
        params.inited = true;
        try {
            this.setupDirectories();
            URL logConfigFile = null;
            if (this.getParams().logbackConfigParam != null) {
                logConfigFile = this.findLogbackXml();
            }
            System.out.println("+-----------------------------------------------------------------------------");
            this.setupLogback(logConfigFile);
        }
        catch (Exception e) {
            params.initFailure = e;
        }
        return this;
    }

    private void setupDirectories() throws IOException {
        Params params = this.getParams();
        this.basedir = new File(params.basedirParam).getCanonicalFile();
        this.srcdir = new File(this.basedir, params.srcdirParam);
        this.destdir = new File(this.basedir, params.destdirParam);
        if (!this.destdir.exists()) {
            this.destdir.mkdirs();
        }
        if (!this.destdir.isDirectory() || !this.destdir.exists()) {
            throw new IllegalArgumentException("Destination directory does not exist: " + this.destdir);
        }
        System.out.println("+-----------------------------------------------------------------------------");
        System.out.println("| Set base dir to:          " + this.basedir);
        System.out.println("| Set source dir to:        " + this.srcdir);
        System.out.println("| Set destination dir to:   " + this.destdir);
    }

    private void setupLogback(URL logConfigFile) throws IOException {
        if (logConfigFile == null) {
            return;
        }
        LogConfigurator configurator = LogConfigurator.getConfigurator((String)"logback");
        Map props = configurator.getDefaultProperties(Boolean.valueOf(false));
        props.put("basedir", this.basedir.getAbsolutePath());
        props.put("srcdir", this.srcdir.getAbsolutePath());
        props.put("destdir", this.destdir.getAbsolutePath());
        props.put("loggingRoot", this.destdir.getAbsolutePath());
        configurator.configure(logConfigFile, props);
    }

    private URL findLogbackXml() throws IOException {
        URL logbackXml;
        File test = new File(this.srcdir, this.getParams().logbackConfigParam);
        if (test.exists()) {
            logbackXml = test.toURI().toURL();
        } else {
            URL testURL = this.getClass().getResource("logback-test-default.xml");
            if (testURL == null) {
                throw new IllegalArgumentException("missing logback-test-default.xml");
            }
            logbackXml = testURL;
        }
        System.out.println("| Initializing log system:  " + logbackXml.toExternalForm());
        return logbackXml;
    }

    public File getBasedir() {
        this.assertInited();
        return this.basedir;
    }

    public File getSrcdir() {
        this.assertInited();
        return this.srcdir;
    }

    public File getDestdir() {
        this.assertInited();
        return this.destdir;
    }

    protected final void assertInited() {
        if (this.params == null) {
            return;
        }
        if (!this.params.inited) {
            throw new IllegalStateException("Not inited yet!");
        }
        Exception initFailure = this.params.initFailure;
        this.params = null;
        if (initFailure != null) {
            if (initFailure instanceof RuntimeException) {
                throw (RuntimeException)initFailure;
            }
            throw new RuntimeException(initFailure);
        }
    }

    protected final Params getParams() {
        if (this.params == null) {
            throw new IllegalStateException();
        }
        return this.params;
    }

    protected Params createParams() {
        return new Params();
    }

    protected class Params {
        public String basedirParam = ".";
        public String srcdirParam = "src/test/config/";
        public String destdirParam = "target/test/";
        public String logbackConfigParam = "logback.xml";
        public Exception initFailure = null;
        public boolean inited = false;

        protected Params() {
        }
    }
}

