/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.test;

import com.alibaba.citrus.test.ExceptionMatcher;
import com.alibaba.citrus.test.RegexMatcher;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtil {
    private static final ThreadLocal<String> TEST_NAME_HOLDER = new ThreadLocal();

    public static String getTestName() {
        return TEST_NAME_HOLDER.get();
    }

    public static void setTestName(String name) {
        if (name == null) {
            TEST_NAME_HOLDER.remove();
            MDC.remove((String)"testName");
        } else {
            TEST_NAME_HOLDER.set(name);
            MDC.put((String)"testName", (String)name);
        }
    }

    public static <T extends Throwable> Matcher<T> exception(Class<? extends Throwable> cause, String ... snippets) {
        return new ExceptionMatcher(cause, snippets);
    }

    public static <T extends Throwable> Matcher<T> exception(String ... snippets) {
        return new ExceptionMatcher(snippets);
    }

    public static Matcher<String> containsRegex(String regex) {
        return new RegexMatcher(regex);
    }

    public static Matcher<String> containsAll(String ... strs) {
        ArrayList<Matcher> list = new ArrayList<Matcher>();
        for (String str : strs) {
            list.add(Matchers.containsString((String)str));
        }
        return Matchers.allOf(list);
    }

    public static Matcher<String> containsAllRegex(String ... regexes) {
        ArrayList<Matcher<String>> list = new ArrayList<Matcher<String>>();
        for (String regex : regexes) {
            list.add(TestUtil.containsRegex(regex));
        }
        return Matchers.allOf(list);
    }

    public static File getJavaHome() {
        File javaHome = new File(System.getProperty("java.home"));
        if ("jre".equals(javaHome.getName())) {
            javaHome = javaHome.getParentFile();
        }
        return javaHome;
    }

    public static File getClassesDir(Class<?> classWithinDir) {
        return TestUtil.getClassesDir(classWithinDir == null ? null : classWithinDir.getName());
    }

    public static File getClassesDir(String classWithinDir) {
        File classesdir;
        File classFile;
        String clazzResourceName = TestUtil.getResourceNameOfClass(classWithinDir) + ".class";
        try {
            classFile = new File(Thread.currentThread().getContextClassLoader().getResource(clazzResourceName).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not find classes dir of " + classWithinDir, e);
        }
        for (classesdir = classFile.getParentFile(); classesdir != null && classesdir.isDirectory() && !new File(classesdir, clazzResourceName).equals(classFile); classesdir = classesdir.getParentFile()) {
        }
        if (!classFile.equals(new File(classesdir, clazzResourceName))) {
            throw new RuntimeException("Could not find classes dir of " + classWithinDir);
        }
        return classesdir;
    }

    public static File[] getClassDirs(Class<?> ... classes) {
        LinkedHashSet<File> dirs = new LinkedHashSet<File>();
        for (Class<?> clazz : classes) {
            dirs.add(TestUtil.getClassesDir(clazz));
        }
        return dirs.toArray(new File[dirs.size()]);
    }

    private static String getResourceNameOfClass(String className) {
        if (className == null) {
            return null;
        }
        return className.trim().replace('.', '/');
    }

    public static Field getAccessibleField(Class<?> targetType, String fieldName) {
        Assert.assertNotNull((String)"missing targetType", targetType);
        Field field = null;
        for (Class<?> c = targetType; c != null && field == null; c = c.getSuperclass()) {
            try {
                field = c.getDeclaredField(fieldName);
                continue;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                Assert.fail((String)e.toString());
                return null;
            }
        }
        Assert.assertNotNull((String)("field " + fieldName + " not found in " + targetType), (Object)field);
        field.setAccessible(true);
        return field;
    }

    public static Method getAccessibleMethod(Class<?> targetType, String methodName, Class<?>[] argTypes) {
        Assert.assertNotNull((String)"missing targetType", targetType);
        Method method = null;
        for (Class<?> c = targetType; c != null && method == null; c = c.getSuperclass()) {
            try {
                method = c.getDeclaredMethod(methodName, argTypes);
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (Exception e) {
                Assert.fail((String)e.toString());
                return null;
            }
        }
        Assert.assertNotNull((String)("method " + methodName + " not found in " + targetType), (Object)method);
        method.setAccessible(true);
        return method;
    }

    public static <T> T getFieldValue(Object target, String fieldName, Class<T> fieldType) {
        return TestUtil.getFieldValue(target, null, fieldName, fieldType);
    }

    public static <T> T getFieldValue(Object target, Class<?> targetType, String fieldName, Class<T> fieldType) {
        if (targetType == null && target != null) {
            targetType = target.getClass();
        }
        Field field = TestUtil.getAccessibleField(targetType, fieldName);
        Object value = null;
        try {
            value = field.get(target);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            return null;
        }
        if (fieldType != null) {
            return fieldType.cast(value);
        }
        return (T)value;
    }

    public static <T> T invokeMethod(Object target, String methodName, Class<?>[] argTypes, Object[] args, Class<T> returnType) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return TestUtil.invokeMethod(target, null, methodName, argTypes, args, returnType);
    }

    public static <T> T invokeMethod(Object target, Class<?> targetType, String methodName, Class<?>[] argTypes, Object[] args, Class<T> returnType) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (targetType == null && target != null) {
            targetType = target.getClass();
        }
        Method method = TestUtil.getAccessibleMethod(targetType, methodName, argTypes);
        Object value = method.invoke(target, args);
        if (returnType != null) {
            return returnType.cast(value);
        }
        return (T)value;
    }
}

