/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.test.context;

import com.alibaba.citrus.service.resource.support.context.ResourceLoadingXmlApplicationContext;
import com.alibaba.citrus.test.TestEnvStatic;
import com.alibaba.citrus.test.context.SpringextContextLoader;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.io.StreamUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextLoader
extends org.springframework.test.context.support.AbstractContextLoader {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final ApplicationContext testResourceLoader = AbstractContextLoader.getTestResourceLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ApplicationContext getTestResourceLoader() {
        try {
            System.setProperty("test.srcdir", TestEnvStatic.srcdir.getAbsolutePath());
            System.setProperty("test.destdir", TestEnvStatic.destdir.getAbsolutePath());
            ClassPathResource testResourceConfig = new ClassPathResource(ClassUtil.getResourceNameForPackage(SpringextContextLoader.class) + "/test-resources.xml");
            ResourceLoadingXmlApplicationContext resourceLoadingXmlApplicationContext = new ResourceLoadingXmlApplicationContext((Resource)testResourceConfig);
            return resourceLoadingXmlApplicationContext;
        }
        finally {
            System.clearProperty("test.srcdir");
            System.clearProperty("test.destdir");
        }
    }

    protected final String[] generateDefaultLocations(Class<?> clazz) {
        File configLocation;
        Assert.assertNotNull(clazz, (String)"Class must not be null", (Object[])new Object[0]);
        String location = "/" + StringUtil.toCamelCase((String)clazz.getSimpleName()) + (String)Assert.assertNotNull((Object)StringUtil.trimToNull((String)this.getResourceSuffix()), (String)"Resource suffix must not be empty", (Object[])new Object[0]);
        if (this.isGenerateContextConfigurations() && !(configLocation = new File(TestEnvStatic.srcdir, location)).exists()) {
            try {
                configLocation.getParentFile().mkdirs();
                FileOutputStream os = new FileOutputStream(configLocation);
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("context-template.xml");
                StreamUtil.io((InputStream)is, (OutputStream)os, (boolean)true, (boolean)true);
                this.log.warn("Generated context configuration file: " + configLocation.getAbsolutePath());
            }
            catch (IOException e) {
                this.log.warn("Could not generate context configuration file: " + configLocation.getAbsolutePath(), (Throwable)e);
            }
        }
        return new String[]{location};
    }

    protected final String[] modifyLocations(Class<?> clazz, String ... locations) {
        return locations;
    }

    protected boolean isGenerateContextConfigurations() {
        return true;
    }

    protected String getResourceSuffix() {
        return "-context.xml";
    }
}

