/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.test.context;

import com.alibaba.citrus.service.resource.support.context.ResourceLoadingXmlApplicationContext;
import com.alibaba.citrus.springext.support.context.AbstractXmlApplicationContext;
import com.alibaba.citrus.springext.util.ClassCompatibilityAssert;
import com.alibaba.citrus.test.context.AbstractContextLoader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.StringUtils;

public class SpringextContextLoader
extends AbstractContextLoader {
    public final ApplicationContext loadContext(String ... locations) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Loading ApplicationContext for locations [" + StringUtils.arrayToCommaDelimitedString((Object[])locations) + "].");
        }
        ResourceLoadingXmlApplicationContext context = new ResourceLoadingXmlApplicationContext(locations, testResourceLoader, false);
        this.prepareContext((AbstractXmlApplicationContext)context);
        context.refresh();
        context.registerShutdownHook();
        return context;
    }

    public final ConfigurableApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Loading ApplicationContext for merged context configuration [" + mergedConfig + "].");
        }
        ResourceLoadingXmlApplicationContext context = new ResourceLoadingXmlApplicationContext(mergedConfig.getLocations(), testResourceLoader, false);
        context.getEnvironment().setActiveProfiles(mergedConfig.getActiveProfiles());
        this.prepareContext((AbstractXmlApplicationContext)context);
        context.refresh();
        context.registerShutdownHook();
        return context;
    }

    protected void prepareContext(AbstractXmlApplicationContext context) {
    }

    static {
        ClassCompatibilityAssert.assertSpring3_1_x();
    }
}

