/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.test.runner;

import com.alibaba.citrus.test.TestUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prototyped
extends Suite {
    public Prototyped(Class<?> klass) throws Throwable {
        super(klass, Prototyped.getRunners(klass));
    }

    private static List<Runner> getRunners(Class<?> klass) throws Throwable, InitializationError {
        ArrayList<Runner> runners = new ArrayList<Runner>();
        int i = 0;
        for (Object each : Prototyped.getPrototypesList(klass)) {
            runners.add((Runner)new TestClassRunnerForPrototypes(klass, each, i++));
        }
        return runners;
    }

    private static Collection<Object> getPrototypesList(Class<?> klass) throws Throwable {
        ArrayList<Object> prototypeList = new ArrayList<Object>();
        for (FrameworkMethod method : Prototyped.getPrototypesMethods(klass)) {
            Collection results = (Collection)method.invokeExplosively(null, new Object[0]);
            for (Object each : results) {
                if (klass.isInstance(each)) continue;
                throw new Exception(String.format("%s.%s() must return a Collection of test object.", klass.getName(), method.getName()));
            }
            prototypeList.addAll(results);
        }
        return prototypeList;
    }

    private static List<FrameworkMethod> getPrototypesMethods(Class<?> testClass) throws Exception {
        List methods = new TestClass(testClass).getAnnotatedMethods(Prototypes.class);
        if (methods.isEmpty()) {
            throw new Exception("No public static prototypes method on class " + testClass.getName());
        }
        for (FrameworkMethod each : methods) {
            int modifiers = each.getMethod().getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers)) continue;
            throw new Exception(String.format("%s.%s() should be public static method: ", testClass.getName(), each.getName()));
        }
        return methods;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestClassRunnerForPrototypes
    extends BlockJUnit4ClassRunner {
        private final Object fPrototype;
        private final int fPrototypeNumber;

        TestClassRunnerForPrototypes(Class<?> type, Object prototype, int i) throws InitializationError {
            super(type);
            this.fPrototype = prototype;
            this.fPrototypeNumber = i;
        }

        public Object createTest() throws Exception {
            if (this.fPrototype instanceof Cloneable && this.getTestClass().getJavaClass().isInstance(this.fPrototype)) {
                Method cloneMethod = null;
                for (Class<?> clazz = this.fPrototype.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    try {
                        cloneMethod = clazz.getDeclaredMethod("clone", new Class[0]);
                        cloneMethod.setAccessible(true);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue;
                    }
                }
                return cloneMethod.invoke(this.fPrototype, new Object[0]);
            }
            Assert.fail((String)String.format("Class %s is not Cloneable", this.getTestClass().getJavaClass().getSimpleName()));
            return null;
        }

        protected String getName() {
            ArrayList methods = new ArrayList(this.getTestClass().getAnnotatedMethods(TestName.class));
            Iterator i$ = methods.iterator();
            if (i$.hasNext()) {
                FrameworkMethod each = (FrameworkMethod)i$.next();
                int modifiers = each.getMethod().getModifiers();
                if (!Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && String.class.equals(each.getMethod().getReturnType()) && each.getMethod().getParameterTypes().length == 0) {
                    String name = null;
                    try {
                        name = (String)each.invokeExplosively(this.fPrototype, new Object[0]);
                        Assert.assertNotNull((String)String.format("%s.%s() returned null", this.getTestClass().getName(), each.getName()), (Object)name);
                        return String.format("[%s] %s", this.fPrototypeNumber, name);
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException(String.format("%s.%s() should be public, non-static, accept no arguments, and return String", this.getTestClass().getName(), each.getName()));
            }
            return String.format("[%s]", this.fPrototypeNumber);
        }

        protected String testName(FrameworkMethod method) {
            return String.format("%s[%s]", method.getName(), this.fPrototypeNumber);
        }

        protected void validateZeroArgConstructor(List<Throwable> errors) {
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runChild(FrameworkMethod method, RunNotifier notifier) {
            TestUtil.setTestName(method.getName());
            try {
                super.runChild(method, notifier);
            }
            finally {
                TestUtil.setTestName(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestData<T>
    extends LinkedList<T> {
        private static final long serialVersionUID = 2818372350747718688L;
        private final Class<T> prototypeClass;

        public static <T> TestData<T> getInstance(Class<T> prototypeClass) {
            return new TestData<T>(prototypeClass);
        }

        public TestData(Class<T> prototypeClass) {
            Assert.assertNotNull((String)"prototypeClass not specified", prototypeClass);
            this.prototypeClass = prototypeClass;
        }

        public T newPrototype() {
            T prototype = null;
            try {
                prototype = this.prototypeClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            super.add(prototype);
            return prototype;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Prototypes {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface TestName {
    }
}

