/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.test.util;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.RequestContextChainingService;
import com.alibaba.citrus.springext.support.parser.AbstractNamedBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.Servlet3Util;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.InvocationContext;
import com.meterware.servletunit.PatchedServletRunner;
import com.meterware.servletunit.ServletRunner;
import com.meterware.servletunit.ServletUnitClient;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletTestContainer {
    protected final ServletRunner servletRunner = new PatchedServletRunner();
    protected final ServletUnitClient client;
    private InvocationContext invocationContext;
    private HttpServletRequest rawRequest;
    private HttpServletResponse rawResponse;
    private ServletContext servletContext;
    private RequestContextChainingService requestContexts;
    private RequestContext requestContext;
    private WebResponse clientResponse;

    public ServletTestContainer() {
        this.servletRunner.registerServlet("/noop/*", NoopServlet.class.getName());
        this.init(this.servletRunner);
        this.client = this.servletRunner.newClient();
    }

    protected void init(ServletRunner runner) {
    }

    public void setMappings(Map<String, String> mappings) {
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            String pattern = entry.getKey();
            String servletClass = StringUtil.defaultIfEmpty((String)entry.getValue(), (String)NoopServlet.class.getName());
            this.servletRunner.registerServlet(pattern, servletClass);
        }
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpServletRequest getRawRequest() {
        return this.rawRequest;
    }

    public HttpServletResponse getRawResponse() {
        return this.rawResponse;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public HttpServletRequest getRequest() {
        return this.requestContext == null ? this.rawRequest : this.requestContext.getRequest();
    }

    public HttpServletResponse getResponse() {
        return this.requestContext == null ? this.rawResponse : this.requestContext.getResponse();
    }

    public WebResponse getClientResponse() {
        return this.clientResponse;
    }

    @Autowired(required=false)
    public void setRequestContexts(RequestContextChainingService requestContexts) {
        this.requestContexts = requestContexts;
    }

    public void request(String uri) {
        uri = uri != null && uri.startsWith("http") ? URI.create(uri).normalize().toString() : URI.create("http://www.test.com/" + StringUtil.trimToEmpty((String)uri)).normalize().toString();
        this.request((WebRequest)new GetMethodWebRequest(uri));
    }

    public void request(WebRequest webRequest) {
        try {
            this.invocationContext = this.client.newInvocation(webRequest);
            this.rawRequest = new MyHttpRequest(this.invocationContext.getRequest(), webRequest.getURL().toExternalForm());
            this.rawResponse = new MyHttpResponse(this.invocationContext.getResponse());
            this.servletContext = this.invocationContext.getServlet().getServletConfig().getServletContext();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.requestContexts != null) {
            this.requestContext = this.requestContexts.getRequestContext(this.servletContext, this.rawRequest, this.rawResponse);
        }
    }

    public void commit() {
        try {
            if (this.requestContexts != null && this.requestContext != null) {
                this.requestContexts.commitRequestContext(this.requestContext);
            }
            this.clientResponse = this.client.getResponse(this.invocationContext);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanup() {
        RequestContextHolder.resetRequestAttributes();
        this.invocationContext = null;
        this.rawRequest = null;
        this.rawResponse = null;
        this.servletContext = null;
        this.requestContext = null;
    }

    static {
        Servlet3Util.setDisableServlet3Features((boolean)true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractNamedBeanDefinitionParser<ServletTestContainer> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            Map mappings = SpringExtUtil.createManagedMap((Element)element, (ParserContext)parserContext);
            for (Element mappingElement : DomUtil.subElements((Element)element, (DomUtil.ElementSelector)DomUtil.and((DomUtil.ElementSelector[])new DomUtil.ElementSelector[]{DomUtil.sameNs((Element)element), DomUtil.name((String)"mapping")}))) {
                String pattern = (String)Assert.assertNotNull((Object)StringUtil.trimToNull((String)mappingElement.getAttribute("pattern")), (String)"pattern", (Object[])new Object[0]);
                String servletClass = StringUtil.trimToNull((String)mappingElement.getAttribute("servletClass"));
                mappings.put(pattern, servletClass);
            }
            if (!mappings.isEmpty()) {
                builder.addPropertyValue("mappings", (Object)mappings);
            }
        }

        protected String getDefaultName() {
            return "servletTestContainer";
        }
    }

    public static class MyHttpResponse
    extends HttpServletResponseWrapper {
        private boolean committed;

        public MyHttpResponse(HttpServletResponse response) {
            super(response);
        }

        public boolean isCommitted() {
            return super.isCommitted() || this.committed;
        }

        public void sendError(int sc, String msg) throws IOException {
            this.ensureNotCommited();
            super.sendError(sc, msg);
            this.committed = true;
        }

        public void sendError(int sc) throws IOException {
            this.ensureNotCommited();
            super.sendError(sc);
            this.committed = true;
        }

        public void sendRedirect(String location) throws IOException {
            this.ensureNotCommited();
            super.sendRedirect(location);
            this.committed = true;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            this.ensureNotCommited();
            return super.getOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            this.ensureNotCommited();
            return super.getWriter();
        }

        public void reset() {
            this.ensureNotCommited();
            super.reset();
        }

        public void resetBuffer() {
            this.ensureNotCommited();
            super.resetBuffer();
        }

        public void setLocale(Locale locale) {
        }

        public void setContentType(String type) {
            if (type == null || type.indexOf("charset=") == -1) {
                this.setCharacterEncoding(null);
            }
            super.setContentType(type);
        }

        public void setBufferSize(int size) {
            this.ensureNotCommited();
            super.setBufferSize(size);
        }

        private void ensureNotCommited() {
            if (this.isCommitted()) {
                throw new IllegalStateException();
            }
        }
    }

    public static class MyHttpRequest
    extends HttpServletRequestWrapper {
        private String charset;
        private String overrideQueryString;
        private String server = "www.test.com";
        private int port = 80;
        private boolean sessionCreated;

        public MyHttpRequest(HttpServletRequest request, String uri) {
            super(request);
            int index;
            if (uri != null && (index = uri.indexOf("?")) >= 0) {
                this.overrideQueryString = uri.substring(index + 1);
            }
        }

        public String getQueryString() {
            if (this.overrideQueryString == null) {
                return super.getQueryString();
            }
            return this.overrideQueryString;
        }

        public String getCharacterEncoding() {
            return this.charset;
        }

        public void setCharacterEncoding(String charset) throws UnsupportedEncodingException {
            this.charset = charset;
        }

        public String getServerName() {
            return this.server;
        }

        public void setServerName(String server) {
            this.server = server;
        }

        public int getServerPort() {
            return this.port;
        }

        public void setServerPort(int port) {
            this.port = port;
        }

        public boolean isSessionCreated() {
            return this.sessionCreated;
        }

        public HttpSession getSession() {
            this.sessionCreated = true;
            return super.getSession();
        }

        public HttpSession getSession(boolean create) {
            if (create) {
                this.sessionCreated = true;
            }
            return super.getSession(create);
        }
    }

    public static class NoopServlet
    extends HttpServlet {
        private static final long serialVersionUID = 3034658026956449398L;

        protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        }
    }
}

