/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.cookies;

import com.alibaba.citrus.test.TestUtil;
import com.meterware.httpunit.cookies.Cookie;
import com.meterware.httpunit.cookies.CookieJar;
import com.meterware.httpunit.cookies.CookieSource;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class PatchedCookieJar
extends CookieJar {
    public PatchedCookieJar() {
    }

    public PatchedCookieJar(CookieSource source) {
        try {
            TestUtil.getAccessibleField(((Object)((Object)this)).getClass(), "_press").set((Object)this, (Object)new PatchedCookiePress(source.getURL()));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.findCookies(source.getHeaderFields("Set-Cookie"), (CookieJar.CookieRecipe)new PatchedRFC2109CookieRecipe());
        this.findCookies(source.getHeaderFields("Set-Cookie2"), (CookieJar.CookieRecipe)new CookieJar.RFC2965CookieRecipe((CookieJar)this));
    }

    private void findCookies(String[] cookieHeader, CookieJar.CookieRecipe recipe) {
        for (String element : cookieHeader) {
            recipe.findCookies(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PatchedCookiePress
    extends CookieJar.CookiePress {
        public PatchedCookiePress(URL sourceURL) {
            super((CookieJar)PatchedCookieJar.this, sourceURL);
        }

        public void addTokenWithEqualsSign(CookieJar.CookieRecipe recipe, String token, int equalsIndex) {
            String name = token.substring(0, equalsIndex).trim();
            String value = token.substring(equalsIndex + 1).trim();
            StringBuffer _value = this.getFieldValue("_value", StringBuffer.class);
            _value.insert(0, value);
            HashMap _attributes = this.getFieldValue("_attributes", HashMap.class);
            if (recipe.isCookieAttribute(name.toLowerCase())) {
                _attributes.put(name.toLowerCase(), _value.toString());
            } else {
                try {
                    TestUtil.getAccessibleMethod(CookieJar.CookiePress.class, "addCookieIfValid", new Class[]{Cookie.class}).invoke((Object)this, new Cookie(name, _value.toString(), (Map)_attributes));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                _attributes.clear();
            }
            _value.setLength(0);
        }

        private <T> T getFieldValue(String name, Class<T> type) {
            try {
                return type.cast(TestUtil.getAccessibleField(((Object)((Object)this)).getClass(), name).get((Object)this));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class PatchedRFC2109CookieRecipe
    extends CookieJar.RFC2109CookieRecipe {
        private PatchedRFC2109CookieRecipe() {
            super((CookieJar)PatchedCookieJar.this);
        }

        protected boolean isCookieReservedWord(String token) {
            return token.equalsIgnoreCase("httpOnly") || super.isCookieReservedWord(token);
        }
    }
}

