/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.parser.impl;

import com.alibaba.citrus.service.requestcontext.parser.AbstractValueParser;
import com.alibaba.citrus.service.requestcontext.parser.CookieParser;
import com.alibaba.citrus.service.requestcontext.parser.ParserRequestContext;
import com.alibaba.citrus.util.StringUtil;
import javax.servlet.http.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieParserImpl
extends AbstractValueParser
implements CookieParser {
    private static final Logger log = LoggerFactory.getLogger(CookieParser.class);

    public CookieParserImpl(ParserRequestContext requestContext) {
        super(requestContext);
        Cookie[] cookies = requestContext.getRequest().getCookies();
        if (cookies != null) {
            if (log.isDebugEnabled()) {
                log.debug("Number of Cookies " + cookies.length);
            }
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                String value = cookie.getValue();
                if (log.isDebugEnabled()) {
                    log.debug("Adding " + name + " = " + value);
                }
                this.add(name, value);
            }
        }
    }

    protected Logger getLogger() {
        return log;
    }

    public void setCookie(String name, String value) {
        this.setCookie(name, value, -1);
    }

    public void setCookie(String name, String value, int seconds_age) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(seconds_age);
        cookie.setDomain(this.getCookieDomain());
        cookie.setPath(this.getCookiePath());
        this.requestContext.getResponse().addCookie(cookie);
    }

    protected String getCookieDomain() {
        String domain = StringUtil.defaultIfEmpty(this.requestContext.getRequest().getServerName(), "");
        String[] parts = StringUtil.split(domain, ".");
        int length = parts.length;
        if (length < 2) {
            return domain;
        }
        return "." + parts[length - 2] + "." + parts[length - 1];
    }

    protected String getCookiePath() {
        return StringUtil.defaultIfEmpty(this.requestContext.getRequest().getContextPath(), "/");
    }

    public void removeCookie(String name) {
        this.setCookie(name, " ", 0);
    }
}

