/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.ResourceTraceElement;
import com.alibaba.citrus.util.Assert;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTrace
implements Iterable<ResourceTraceElement> {
    private final ResourceTraceElement[] elements;
    private final Resource resource;

    public ResourceTrace(Collection<ResourceTraceElement> elements, Resource resource) {
        this.elements = elements == null ? new ResourceTraceElement[]{} : elements.toArray(new ResourceTraceElement[elements.size()]);
        this.resource = resource;
    }

    public Resource getResult() {
        return this.resource;
    }

    public int length() {
        return this.elements.length;
    }

    @Override
    public Iterator<ResourceTraceElement> iterator() {
        return new Iterator<ResourceTraceElement>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < ResourceTrace.this.elements.length;
            }

            @Override
            public ResourceTraceElement next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ResourceTrace.this.elements[this.i++];
            }

            @Override
            public void remove() {
                Assert.unsupportedOperation("remove()", new Object[0]);
            }
        };
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.elements.length; ++i) {
            buf.append(this.elements[i]);
            if (i >= this.elements.length - 1) continue;
            buf.append("\n");
        }
        return buf.toString();
    }
}

