/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.upload.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.upload.UploadException;
import com.alibaba.citrus.service.upload.UploadParameters;
import com.alibaba.citrus.service.upload.UploadService;
import com.alibaba.citrus.service.upload.UploadSizeLimitExceededException;
import com.alibaba.citrus.service.upload.impl.cfu.DiskFileItemFactory;
import com.alibaba.citrus.service.upload.impl.cfu.ServletFileUpload;
import com.alibaba.citrus.util.HumanReadableSize;
import java.io.File;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadServiceImpl
extends AbstractService<UploadService>
implements UploadService {
    private final UploadParameters params = new UploadParameters();
    private ServletFileUpload fileUpload;

    @Override
    public File getRepository() {
        return this.params.getRepository();
    }

    @Override
    public HumanReadableSize getSizeMax() {
        return this.params.getSizeMax();
    }

    @Override
    public HumanReadableSize getFileSizeMax() {
        return this.params.getFileSizeMax();
    }

    @Override
    public HumanReadableSize getSizeThreshold() {
        return this.params.getSizeThreshold();
    }

    @Override
    public boolean isKeepFormFieldInMemory() {
        return this.params.isKeepFormFieldInMemory();
    }

    public void setSizeMax(HumanReadableSize sizeMax) {
        this.params.setSizeMax(sizeMax);
    }

    public void setFileSizeMax(HumanReadableSize fileSizeMax) {
        this.params.setFileSizeMax(fileSizeMax);
    }

    public void setSizeThreshold(HumanReadableSize sizeThreshold) {
        this.params.setSizeThreshold(sizeThreshold);
    }

    public void setKeepFormFieldInMemory(boolean keepFormFieldInMemory) {
        this.params.setKeepFormFieldInMemory(keepFormFieldInMemory);
    }

    public void setRepository(File repository) {
        this.params.setRepository(repository);
    }

    @Override
    public String[] getFileNameKey() {
        return this.params.getFileNameKey();
    }

    public void setFileNameKey(String[] fileNameKey) {
        this.params.setFileNameKey(fileNameKey);
    }

    @Override
    protected void init() {
        this.params.applyDefaultValues();
        this.getLogger().info("Upload Parameters: {}", (Object)this.params);
        this.fileUpload = this.getFileUpload(this.params, false);
    }

    @Override
    public boolean isMultipartContent(HttpServletRequest request) {
        return org.apache.commons.fileupload.servlet.ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    @Override
    public FileItem[] parseRequest(HttpServletRequest request) {
        return this.parseRequest(request, null);
    }

    @Override
    public FileItem[] parseRequest(HttpServletRequest request, UploadParameters params) {
        List<?> fileItems;
        this.assertInitialized();
        ServletFileUpload fileUpload = params == null || params.equals(this.params) ? this.fileUpload : this.getFileUpload(params, true);
        try {
            fileItems = fileUpload.parseRequest(request);
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            throw new UploadSizeLimitExceededException(e);
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            throw new UploadSizeLimitExceededException(e);
        }
        catch (FileUploadException e) {
            throw new UploadException(e);
        }
        return fileItems.toArray(new FileItem[fileItems.size()]);
    }

    private ServletFileUpload getFileUpload(UploadParameters params, boolean applyDefaultValues) {
        if (applyDefaultValues) {
            params.applyDefaultValues();
            this.getLogger().debug("Upload Parameters: {}", (Object)params);
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setRepository(params.getRepository());
        factory.setSizeThreshold((int)params.getSizeThreshold().getValue());
        factory.setKeepFormFieldInMemory(params.isKeepFormFieldInMemory());
        ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)factory);
        fileUpload.setSizeMax(params.getSizeMax().getValue());
        fileUpload.setFileSizeMax(params.getFileSizeMax().getValue());
        fileUpload.setFileNameKey(params.getFileNameKey());
        return fileUpload;
    }
}

