/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.internal.InterfaceImplementorBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Servlet3Util {
    public static final Enum<?> DISPATCHER_TYPE_FORWARD = Servlet3Util.getEnum("javax.servlet.DispatcherType", "FORWARD");
    public static final Enum<?> DISPATCHER_TYPE_INCLUDE = Servlet3Util.getEnum("javax.servlet.DispatcherType", "INCLUDE");
    public static final Enum<?> DISPATCHER_TYPE_REQUEST = Servlet3Util.getEnum("javax.servlet.DispatcherType", "REQUEST");
    public static final Enum<?> DISPATCHER_TYPE_ASYNC = Servlet3Util.getEnum("javax.servlet.DispatcherType", "ASYNC");
    public static final Enum<?> DISPATCHER_TYPE_ERROR = Servlet3Util.getEnum("javax.servlet.DispatcherType", "ERROR");
    public static final Class<?> asyncContextClass = Servlet3Util.loadClass("javax.servlet.AsyncContext");
    public static final Class<?> asyncListenerClass = Servlet3Util.loadClass("javax.servlet.AsyncListener");
    public static final Class<?> asyncEventClass = Servlet3Util.loadClass("javax.servlet.AsyncEvent");
    private static final MethodInfo[] methods;
    private static final int request_isAsyncStarted;
    private static final int request_getAsyncContext;
    private static final int request_getDispatcherType;
    private static final int asyncContext_addListener;
    private static final int asyncEvent_getAsyncContext;
    private static final boolean servlet3;
    private static boolean disableServlet3Features;

    public static boolean isServlet3() {
        return servlet3;
    }

    public static boolean setDisableServlet3Features(boolean disabled) {
        boolean originalValue = disableServlet3Features;
        disableServlet3Features = disabled;
        return originalValue;
    }

    public static boolean request_isAsyncStarted(HttpServletRequest request) {
        return (Boolean)Servlet3Util.invoke(request_isAsyncStarted, request, new Object[0]);
    }

    public static Object request_getAsyncContext(HttpServletRequest request) {
        int index = request_getAsyncContext;
        if (methods[index].isDisabled()) {
            throw new IllegalStateException("request.getAsyncContext");
        }
        return Servlet3Util.invoke(index, request, new Object[0]);
    }

    public static boolean request_isDispatcherType(HttpServletRequest request, Enum<?> type) {
        Enum dispatcherType = (Enum)Servlet3Util.invoke(request_getDispatcherType, request, new Object[0]);
        if (dispatcherType == null || type == null) {
            return false;
        }
        return dispatcherType == type;
    }

    public static Object asyncEvent_getAsyncContext(Object event) {
        return Servlet3Util.invoke(asyncEvent_getAsyncContext, event, new Object[0]);
    }

    public static void asyncContext_addAsyncListener(Object asyncContext, Object listener) {
        Servlet3Util.invoke(asyncContext_addListener, asyncContext, listener);
    }

    public static void request_registerAsyncListener(HttpServletRequest request, Object listenerImpl) {
        Object asyncContext = Servlet3Util.request_getAsyncContext(request);
        Object listener = new InterfaceImplementorBuilder().addInterface(asyncListenerClass).setOverrider(listenerImpl).toObject();
        Servlet3Util.invoke(asyncContext_addListener, asyncContext, listener);
    }

    private static Class<?> loadClass(String className) {
        try {
            return Servlet3Util.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Object invoke(int methodIndex, Object target, Object ... args) {
        MethodInfo method = methods[methodIndex];
        if (method.isDisabled()) {
            return method.defaultReturnValue;
        }
        try {
            if (method.returnValueType == null) {
                method.method.invoke(target, args);
                return null;
            }
            return method.returnValueType.cast(method.method.invoke(target, args));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static Enum<?> getEnum(String className, String name) {
        Class<?> enumClass = null;
        try {
            enumClass = Servlet3Util.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Assert.assertTrue(Enum.class.isAssignableFrom(enumClass), "%s is not a enum class", enumClass.getName());
        try {
            return (Enum)enumClass.getField(name).get(null);
        }
        catch (Exception e) {
            Assert.unexpectedException(e);
            return null;
        }
    }

    static {
        servlet3 = asyncContextClass != null;
        disableServlet3Features = false;
        LinkedList<MethodInfo> methodList = CollectionUtil.createLinkedList();
        int count = 0;
        methodList.add(new MethodInfo(Boolean.class, false, HttpServletRequest.class, "isAsyncStarted", new Class[0]));
        request_isAsyncStarted = count++;
        methodList.add(new MethodInfo(Object.class, null, HttpServletRequest.class, "getAsyncContext", new Class[0]));
        request_getAsyncContext = count++;
        methodList.add(new MethodInfo(Enum.class, null, HttpServletRequest.class, "getDispatcherType", new Class[0]));
        request_getDispatcherType = count++;
        methodList.add(new MethodInfo(null, null, asyncContextClass, "addListener", asyncListenerClass));
        asyncContext_addListener = count++;
        methodList.add(new MethodInfo(asyncContextClass, null, asyncEventClass, "getAsyncContext", new Class[0]));
        asyncEvent_getAsyncContext = count++;
        methods = methodList.toArray(new MethodInfo[methodList.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInfo {
        private final FastMethod method;
        private final Object defaultReturnValue;
        private final Class<?> returnValueType;

        public <T> MethodInfo(Class<T> returnValueType, T defaultReturnValue, Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
            this.returnValueType = returnValueType;
            this.defaultReturnValue = defaultReturnValue;
            FastMethod method = null;
            if (declaringClass != null) {
                try {
                    Method javaMethod = declaringClass.getMethod(methodName, parameterTypes);
                    method = FastClass.create((ClassLoader)this.getClass().getClassLoader(), declaringClass).getMethod(javaMethod);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            this.method = method;
        }

        public boolean isDisabled() {
            return disableServlet3Features || this.method == null;
        }
    }
}

