/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic;

import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterParamFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.flow.statistic.ClusterMetricNode;
import com.alibaba.csp.sentinel.cluster.flow.statistic.ClusterMetricStatistics;
import com.alibaba.csp.sentinel.cluster.flow.statistic.ClusterParamMetricStatistics;
import com.alibaba.csp.sentinel.cluster.flow.statistic.data.ClusterFlowEvent;
import com.alibaba.csp.sentinel.cluster.flow.statistic.metric.ClusterMetric;
import com.alibaba.csp.sentinel.cluster.flow.statistic.metric.ClusterParamMetric;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterMetricNodeGenerator {
    public static Map<String, List<ClusterMetricNode>> generateCurrentNodeMap(String namespace) {
        ClusterMetricNode node;
        HashMap<String, List<ClusterMetricNode>> map = new HashMap<String, List<ClusterMetricNode>>();
        Set<Long> flowIds = ClusterFlowRuleManager.getFlowIdSet(namespace);
        Set<Long> paramFlowIds = ClusterParamFlowRuleManager.getFlowIdSet(namespace);
        for (Long id : flowIds) {
            node = ClusterMetricNodeGenerator.flowToMetricNode(id);
            if (node == null) continue;
            ClusterMetricNodeGenerator.putToMap(map, node);
        }
        for (Long id : paramFlowIds) {
            node = ClusterMetricNodeGenerator.paramToMetricNode(id);
            if (node == null) continue;
            ClusterMetricNodeGenerator.putToMap(map, node);
        }
        return map;
    }

    private static void putToMap(Map<String, List<ClusterMetricNode>> map, ClusterMetricNode node) {
        List<ClusterMetricNode> nodeList = map.get(node.getResourceName());
        if (nodeList == null) {
            nodeList = new ArrayList<ClusterMetricNode>();
            map.put(node.getResourceName(), nodeList);
        }
        nodeList.add(node);
    }

    public static ClusterMetricNode flowToMetricNode(long flowId) {
        FlowRule rule = ClusterFlowRuleManager.getFlowRuleById(flowId);
        if (rule == null) {
            return null;
        }
        ClusterMetric metric = ClusterMetricStatistics.getMetric(flowId);
        if (metric == null) {
            return new ClusterMetricNode().setFlowId(flowId).setResourceName(rule.getResource());
        }
        return new ClusterMetricNode().setFlowId(flowId).setResourceName(rule.getResource()).setBlockQps(metric.getAvg(ClusterFlowEvent.BLOCK)).setPassQps(metric.getAvg(ClusterFlowEvent.PASS)).setTimestamp(TimeUtil.currentTimeMillis());
    }

    public static ClusterMetricNode paramToMetricNode(long flowId) {
        ParamFlowRule rule = ClusterParamFlowRuleManager.getParamRuleById(flowId);
        if (rule == null) {
            return null;
        }
        ClusterParamMetric metric = ClusterParamMetricStatistics.getMetric(flowId);
        if (metric == null) {
            return new ClusterMetricNode().setFlowId(flowId).setResourceName(rule.getResource()).setTimestamp(TimeUtil.currentTimeMillis()).setTopParams(new HashMap<Object, Double>(0));
        }
        return new ClusterMetricNode().setFlowId(flowId).setResourceName(rule.getResource()).setTimestamp(TimeUtil.currentTimeMillis()).setTopParams(metric.getTopValues(5));
    }
}

