/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.param;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slotchain.AbstractLinkedProcessorSlot;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slotchain.StringResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowChecker;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowException;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetric;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ParamFlowSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    private static final Map<ResourceWrapper, ParameterMetric> metricsMap = new ConcurrentHashMap<ResourceWrapper, ParameterMetric>();
    private final Object LOCK = new Object();

    public void entry(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, boolean prioritized, Object ... args) throws Throwable {
        if (!ParamFlowRuleManager.hasRules(resourceWrapper.getName())) {
            this.fireEntry(context, resourceWrapper, node, count, prioritized, args);
            return;
        }
        this.checkFlow(resourceWrapper, count, args);
        this.fireEntry(context, resourceWrapper, node, count, prioritized, args);
    }

    public void exit(Context context, ResourceWrapper resourceWrapper, int count, Object ... args) {
        this.fireExit(context, resourceWrapper, count, args);
    }

    void checkFlow(ResourceWrapper resourceWrapper, int count, Object ... args) throws BlockException {
        if (ParamFlowRuleManager.hasRules(resourceWrapper.getName())) {
            List<ParamFlowRule> rules = ParamFlowRuleManager.getRulesOfResource(resourceWrapper.getName());
            if (rules == null) {
                return;
            }
            for (ParamFlowRule rule : rules) {
                this.initHotParamMetricsFor(resourceWrapper, rule.getParamIdx());
                if (ParamFlowChecker.passCheck(resourceWrapper, rule, count, args)) continue;
                this.addBlockCount(resourceWrapper, count, args);
                String message = "";
                if (args.length > rule.getParamIdx()) {
                    Object value = args[rule.getParamIdx()];
                    message = String.valueOf(value);
                }
                throw new ParamFlowException(resourceWrapper.getName(), message);
            }
        }
    }

    private void addBlockCount(ResourceWrapper resourceWrapper, int count, Object ... args) {
        ParameterMetric parameterMetric = ParamFlowSlot.getParamMetric(resourceWrapper);
        if (parameterMetric != null) {
            parameterMetric.addBlock(count, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initHotParamMetricsFor(ResourceWrapper resourceWrapper, int index) {
        ParameterMetric metric = metricsMap.get(resourceWrapper);
        if (metric == null) {
            Object object = this.LOCK;
            synchronized (object) {
                metric = metricsMap.get(resourceWrapper);
                if (metric == null) {
                    metric = new ParameterMetric();
                    metricsMap.put(resourceWrapper, metric);
                    RecordLog.info((String)("[ParamFlowSlot] Creating parameter metric for: " + resourceWrapper.getName()), (Object[])new Object[0]);
                }
            }
        }
        metric.initializeForIndex(index);
    }

    public static ParameterMetric getParamMetric(ResourceWrapper resourceWrapper) {
        if (resourceWrapper == null || resourceWrapper.getName() == null) {
            return null;
        }
        return metricsMap.get(resourceWrapper);
    }

    public static ParameterMetric getHotParamMetricForName(String resourceName) {
        if (StringUtil.isBlank((String)resourceName)) {
            return null;
        }
        for (EntryType nodeType : EntryType.values()) {
            ParameterMetric metric = metricsMap.get(new StringResourceWrapper(resourceName, nodeType));
            if (metric == null) continue;
            return metric;
        }
        return null;
    }

    static void clearHotParamMetricForName(String resourceName) {
        if (StringUtil.isBlank((String)resourceName)) {
            return;
        }
        for (EntryType nodeType : EntryType.values()) {
            metricsMap.remove(new StringResourceWrapper(resourceName, nodeType));
        }
        RecordLog.info((String)("[ParamFlowSlot] Clearing parameter metric for: " + resourceName), (Object[])new Object[0]);
    }

    public static Map<ResourceWrapper, ParameterMetric> getMetricsMap() {
        return metricsMap;
    }
}

