/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final NumberCodec instance = new NumberCodec();
    private DecimalFormat decimalFormat = null;

    private NumberCodec() {
    }

    public NumberCodec(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public NumberCodec(String decimalFormat) {
        this(new DecimalFormat(decimalFormat));
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            if ((out.features & SerializerFeature.WriteNullNumberAsZero.mask) != 0) {
                out.write(48);
            } else {
                out.writeNull();
            }
            return;
        }
        if (object instanceof Float) {
            float floatValue = ((Float)object).floatValue();
            if (Float.isNaN(floatValue)) {
                out.writeNull();
            } else if (Float.isInfinite(floatValue)) {
                out.writeNull();
            } else {
                String floatText = Float.toString(floatValue);
                if (floatText.endsWith(".0")) {
                    floatText = floatText.substring(0, floatText.length() - 2);
                }
                out.write(floatText);
                if ((out.features & SerializerFeature.WriteClassName.mask) != 0) {
                    out.write(70);
                }
            }
            return;
        }
        double doubleValue = (Double)object;
        if (Double.isNaN(doubleValue)) {
            out.writeNull();
        } else if (Double.isInfinite(doubleValue)) {
            out.writeNull();
        } else {
            String doubleText;
            if (this.decimalFormat == null) {
                doubleText = Double.toString(doubleValue);
                if (doubleText.endsWith(".0")) {
                    doubleText = doubleText.substring(0, doubleText.length() - 2);
                }
            } else {
                doubleText = this.decimalFormat.format(doubleValue);
            }
            out.append(doubleText);
            if ((out.features & SerializerFeature.WriteClassName.mask) != 0) {
                out.write(68);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        JSONLexer lexer = parser.lexer;
        int token = lexer.token();
        if (token == 2) {
            if (clazz == Double.TYPE || clazz == Double.class) {
                String val = lexer.numberString();
                lexer.nextToken(16);
                return (T)Double.valueOf(Double.parseDouble(val));
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                String val = lexer.numberString();
                lexer.nextToken(16);
                return (T)Float.valueOf(Float.parseFloat(val));
            }
            long val = lexer.longValue();
            lexer.nextToken(16);
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (T)Short.valueOf((short)val);
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (T)Byte.valueOf((byte)val);
            }
            if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
                return (T)Integer.valueOf((int)val);
            }
            return (T)Long.valueOf(val);
        }
        if (token == 3) {
            if (clazz == Double.TYPE || clazz == Double.class) {
                String val = lexer.numberString();
                lexer.nextToken(16);
                return (T)Double.valueOf(Double.parseDouble(val));
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                String val = lexer.numberString();
                lexer.nextToken(16);
                return (T)Float.valueOf(Float.parseFloat(val));
            }
            BigDecimal val = lexer.decimalValue();
            lexer.nextToken(16);
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (T)Short.valueOf(val.shortValue());
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (T)Byte.valueOf(val.byteValue());
            }
            return (T)val;
        }
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)TypeUtils.castToDouble(value);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)TypeUtils.castToFloat(value);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)TypeUtils.castToShort(value);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (T)TypeUtils.castToByte(value);
        }
        return (T)TypeUtils.castToBigDecimal(value);
    }
}

