/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.util.FieldInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldDeserializer {
    public final FieldInfo fieldInfo;
    public final Class<?> clazz;
    protected Enum[] enums;
    protected long[] enumNameHashCodes;

    public FieldDeserializer(Class<?> clazz, FieldInfo fieldInfo, int fastMatchToken) {
        this.clazz = clazz;
        this.fieldInfo = fieldInfo;
        if (fieldInfo == null) {
            return;
        }
        Class<?> fieldClass = fieldInfo.fieldClass;
        if (fieldClass.isEnum()) {
            int i;
            Enum[] enums = (Enum[])fieldClass.getEnumConstants();
            long[] enumNameHashCodes = new long[enums.length];
            this.enumNameHashCodes = new long[enums.length];
            for (i = 0; i < enums.length; ++i) {
                String name = enums[i].name();
                long hash = -3750763034362895579L;
                for (int j = 0; j < name.length(); ++j) {
                    char ch = name.charAt(j);
                    hash ^= (long)ch;
                    hash *= 1099511628211L;
                }
                enumNameHashCodes[i] = hash;
                this.enumNameHashCodes[i] = hash;
            }
            Arrays.sort(this.enumNameHashCodes);
            this.enums = new Enum[enums.length];
            block2: for (i = 0; i < this.enumNameHashCodes.length; ++i) {
                for (int j = 0; j < enumNameHashCodes.length; ++j) {
                    if (this.enumNameHashCodes[i] != enumNameHashCodes[j]) continue;
                    this.enums[i] = enums[j];
                    continue block2;
                }
            }
        }
    }

    public Enum getEnumByHashCode(long hashCode) {
        if (this.enums == null) {
            return null;
        }
        int enumIndex = Arrays.binarySearch(this.enumNameHashCodes, hashCode);
        if (enumIndex < 0) {
            return null;
        }
        return this.enums[enumIndex];
    }

    public abstract void parseField(DefaultJSONParser var1, Object var2, Type var3, Map<String, Object> var4);

    public void setValue(Object object, int value) throws IllegalAccessException {
        this.fieldInfo.field.setInt(object, value);
    }

    public void setValue(Object object, long value) throws IllegalAccessException {
        this.fieldInfo.field.setLong(object, value);
    }

    public void setValue(Object object, float value) throws IllegalAccessException {
        this.fieldInfo.field.setFloat(object, value);
    }

    public void setValue(Object object, double value) throws IllegalAccessException {
        this.fieldInfo.field.setDouble(object, value);
    }

    public void setValue(Object object, Object value) {
        Class<?> fieldClass;
        if (value == null && (fieldClass = this.fieldInfo.fieldClass).isPrimitive()) {
            return;
        }
        Field field = this.fieldInfo.field;
        Method method = this.fieldInfo.method;
        try {
            if (this.fieldInfo.fieldAccess) {
                if (this.fieldInfo.getOnly) {
                    if (Map.class.isAssignableFrom(this.fieldInfo.fieldClass)) {
                        Map map = (Map)field.get(object);
                        if (map != null) {
                            map.putAll((Map)value);
                        }
                    } else {
                        Collection collection = (Collection)field.get(object);
                        if (collection != null) {
                            collection.addAll((Collection)value);
                        }
                    }
                } else {
                    field.set(object, value);
                }
            } else if (this.fieldInfo.getOnly) {
                if (Map.class.isAssignableFrom(this.fieldInfo.fieldClass)) {
                    Map map = (Map)method.invoke(object, new Object[0]);
                    if (map != null) {
                        map.putAll((Map)value);
                    }
                } else {
                    Collection collection = (Collection)method.invoke(object, new Object[0]);
                    if (collection != null) {
                        collection.addAll((Collection)value);
                    }
                }
            } else {
                method.invoke(object, value);
            }
        }
        catch (Exception e) {
            throw new JSONException("set property error, " + this.fieldInfo.name, e);
        }
    }
}

