/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class LoggingSpringApplicationRunListener
implements SpringApplicationRunListener,
Ordered {
    private static final String DEFAULT_NACOS_LOGBACK_LOCATION = "classpath:META-INF/logback/nacos.xml";
    private static final Logger logger = LoggerFactory.getLogger(LoggingSpringApplicationRunListener.class);
    private final SpringApplication application;
    private final String[] args;

    public LoggingSpringApplicationRunListener(SpringApplication application, String[] args) {
        this.application = application;
        this.args = args;
    }

    public void starting() {
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
        if (!environment.containsProperty("logging.config")) {
            System.setProperty("logging.config", DEFAULT_NACOS_LOGBACK_LOCATION);
            if (logger.isInfoEnabled()) {
                logger.info("There is no property named \"{}\" in Spring Boot Environment, and whose value is {} will be set into System's Properties", (Object)"logging.config", (Object)DEFAULT_NACOS_LOGBACK_LOCATION);
            }
        }
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void started(ConfigurableApplicationContext context) {
    }

    public void running(ConfigurableApplicationContext context) {
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

