/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.client.impl;

import com.alibaba.rocketmq.client.VirtualEnvUtil;
import com.alibaba.rocketmq.client.consumer.PullCallback;
import com.alibaba.rocketmq.client.consumer.PullResult;
import com.alibaba.rocketmq.client.consumer.PullStatus;
import com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.impl.ClientRemotingProcessor;
import com.alibaba.rocketmq.client.impl.CommunicationMode;
import com.alibaba.rocketmq.client.impl.consumer.PullResultExt;
import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.client.producer.SendCallback;
import com.alibaba.rocketmq.client.producer.SendResult;
import com.alibaba.rocketmq.client.producer.SendStatus;
import com.alibaba.rocketmq.common.MQVersion;
import com.alibaba.rocketmq.common.MixAll;
import com.alibaba.rocketmq.common.TopicConfig;
import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.admin.ConsumeStats;
import com.alibaba.rocketmq.common.admin.TopicStatsTable;
import com.alibaba.rocketmq.common.message.Message;
import com.alibaba.rocketmq.common.message.MessageDecoder;
import com.alibaba.rocketmq.common.message.MessageExt;
import com.alibaba.rocketmq.common.message.MessageQueue;
import com.alibaba.rocketmq.common.namesrv.TopAddressing;
import com.alibaba.rocketmq.common.protocol.body.ClusterInfo;
import com.alibaba.rocketmq.common.protocol.body.ConsumeMessageDirectlyResult;
import com.alibaba.rocketmq.common.protocol.body.ConsumerConnection;
import com.alibaba.rocketmq.common.protocol.body.ConsumerRunningInfo;
import com.alibaba.rocketmq.common.protocol.body.GetConsumerStatusBody;
import com.alibaba.rocketmq.common.protocol.body.GroupList;
import com.alibaba.rocketmq.common.protocol.body.KVTable;
import com.alibaba.rocketmq.common.protocol.body.LockBatchRequestBody;
import com.alibaba.rocketmq.common.protocol.body.LockBatchResponseBody;
import com.alibaba.rocketmq.common.protocol.body.ProducerConnection;
import com.alibaba.rocketmq.common.protocol.body.QueryConsumeTimeSpanBody;
import com.alibaba.rocketmq.common.protocol.body.QueryCorrectionOffsetBody;
import com.alibaba.rocketmq.common.protocol.body.QueueTimeSpan;
import com.alibaba.rocketmq.common.protocol.body.ResetOffsetBody;
import com.alibaba.rocketmq.common.protocol.body.TopicList;
import com.alibaba.rocketmq.common.protocol.body.UnlockBatchRequestBody;
import com.alibaba.rocketmq.common.protocol.header.CloneGroupOffsetRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.ConsumeMessageDirectlyResultRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.ConsumerSendMsgBackRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.CreateTopicRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.DeleteSubscriptionGroupRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.DeleteTopicRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.EndTransactionRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.GetConsumeStatsRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.GetConsumerConnectionListRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.GetConsumerListByGroupRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.GetConsumerListByGroupResponseBody;
import com.alibaba.rocketmq.common.protocol.header.GetConsumerRunningInfoRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.GetConsumerStatusRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.GetEarliestMsgStoretimeRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.GetEarliestMsgStoretimeResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.GetMaxOffsetRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.GetMaxOffsetResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.GetMinOffsetRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.GetMinOffsetResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.GetProducerConnectionListRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.GetTopicStatsInfoRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.GetTopicsByClusterRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.PullMessageRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.PullMessageResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.QueryConsumeTimeSpanRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.QueryConsumerOffsetRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.QueryConsumerOffsetResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.QueryCorrectionOffsetHeader;
import com.alibaba.rocketmq.common.protocol.header.QueryMessageRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.QueryTopicConsumeByWhoRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.ResetOffsetRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.SearchOffsetRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.SearchOffsetResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.SendMessageRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.SendMessageRequestHeaderV2;
import com.alibaba.rocketmq.common.protocol.header.SendMessageResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.UnregisterClientRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.UpdateConsumerOffsetRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.ViewMessageRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.filtersrv.RegisterMessageFilterClassRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.namesrv.DeleteKVConfigRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.namesrv.GetKVConfigRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.namesrv.GetKVConfigResponseHeader;
import com.alibaba.rocketmq.common.protocol.header.namesrv.GetKVListByNamespaceRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.namesrv.GetRouteInfoRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.namesrv.PutKVConfigRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.namesrv.WipeWritePermOfBrokerRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.namesrv.WipeWritePermOfBrokerResponseHeader;
import com.alibaba.rocketmq.common.protocol.heartbeat.ConsumerData;
import com.alibaba.rocketmq.common.protocol.heartbeat.HeartbeatData;
import com.alibaba.rocketmq.common.protocol.heartbeat.ProducerData;
import com.alibaba.rocketmq.common.protocol.heartbeat.SubscriptionData;
import com.alibaba.rocketmq.common.protocol.route.TopicRouteData;
import com.alibaba.rocketmq.common.subscription.SubscriptionGroupConfig;
import com.alibaba.rocketmq.remoting.CommandCustomHeader;
import com.alibaba.rocketmq.remoting.InvokeCallback;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.RemotingClient;
import com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.alibaba.rocketmq.remoting.exception.RemotingCommandException;
import com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.alibaba.rocketmq.remoting.exception.RemotingException;
import com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.alibaba.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import com.alibaba.rocketmq.remoting.netty.NettyClientConfig;
import com.alibaba.rocketmq.remoting.netty.NettyRemotingClient;
import com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.alibaba.rocketmq.remoting.netty.ResponseFuture;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.alibaba.rocketmq.remoting.protocol.RemotingSerializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class MQClientAPIImpl {
    private static final Logger log;
    private final RemotingClient remotingClient;
    private final TopAddressing topAddressing = new TopAddressing(MixAll.WS_ADDR);
    private final ClientRemotingProcessor clientRemotingProcessor;
    private String nameSrvAddr = null;
    private String projectGroupPrefix;
    public static boolean sendSmartMsg;

    public MQClientAPIImpl(NettyClientConfig nettyClientConfig, ClientRemotingProcessor clientRemotingProcessor, RPCHook rpcHook) {
        this.remotingClient = new NettyRemotingClient(nettyClientConfig, null);
        this.clientRemotingProcessor = clientRemotingProcessor;
        this.remotingClient.registerRPCHook(rpcHook);
        this.remotingClient.registerProcessor(39, (NettyRequestProcessor)this.clientRemotingProcessor, null);
        this.remotingClient.registerProcessor(40, (NettyRequestProcessor)this.clientRemotingProcessor, null);
        this.remotingClient.registerProcessor(220, (NettyRequestProcessor)this.clientRemotingProcessor, null);
        this.remotingClient.registerProcessor(221, (NettyRequestProcessor)this.clientRemotingProcessor, null);
        this.remotingClient.registerProcessor(307, (NettyRequestProcessor)this.clientRemotingProcessor, null);
        this.remotingClient.registerProcessor(309, (NettyRequestProcessor)this.clientRemotingProcessor, null);
    }

    public MQClientAPIImpl(NettyClientConfig nettyClientConfig, ClientRemotingProcessor clientRemotingProcessor) {
        this(nettyClientConfig, clientRemotingProcessor, null);
    }

    public List<String> getNameServerAddressList() {
        return this.remotingClient.getNameServerAddressList();
    }

    public RemotingClient getRemotingClient() {
        return this.remotingClient;
    }

    public String fetchNameServerAddr() {
        try {
            String addrs = this.topAddressing.fetchNSAddr();
            if (addrs != null && !addrs.equals(this.nameSrvAddr)) {
                log.info("name server address changed, old: " + this.nameSrvAddr + " new: " + addrs);
                this.updateNameServerAddressList(addrs);
                this.nameSrvAddr = addrs;
                return this.nameSrvAddr;
            }
        }
        catch (Exception e) {
            log.error("fetchNameServerAddr Exception", (Throwable)e);
        }
        return this.nameSrvAddr;
    }

    public void updateNameServerAddressList(String addrs) {
        ArrayList<String> lst = new ArrayList<String>();
        String[] addrArray = addrs.split(";");
        if (addrArray != null) {
            for (String addr : addrArray) {
                lst.add(addr);
            }
            this.remotingClient.updateNameServerAddressList(lst);
        }
    }

    public void start() {
        this.remotingClient.start();
        try {
            String localAddress = RemotingUtil.getLocalAddress();
            this.projectGroupPrefix = this.getProjectGroupByIp(localAddress, 3000L);
            log.info("The client[{}] in project group: {}", (Object)localAddress, (Object)this.projectGroupPrefix);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.remotingClient.shutdown();
    }

    public void createSubscriptionGroup(String addr, SubscriptionGroupConfig config, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            config.setGroupName(VirtualEnvUtil.buildWithProjectGroup(config.getGroupName(), this.projectGroupPrefix));
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)200, null);
        byte[] body = RemotingSerializable.encode((Object)config);
        request.setBody(body);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void createTopic(String addr, String defaultTopic, TopicConfig topicConfig, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        String topicWithProjectGroup = topicConfig.getTopicName();
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            topicWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(topicConfig.getTopicName(), this.projectGroupPrefix);
        }
        CreateTopicRequestHeader requestHeader = new CreateTopicRequestHeader();
        requestHeader.setTopic(topicWithProjectGroup);
        requestHeader.setDefaultTopic(defaultTopic);
        requestHeader.setReadQueueNums(Integer.valueOf(topicConfig.getReadQueueNums()));
        requestHeader.setWriteQueueNums(Integer.valueOf(topicConfig.getWriteQueueNums()));
        requestHeader.setPerm(Integer.valueOf(topicConfig.getPerm()));
        requestHeader.setTopicFilterType(topicConfig.getTopicFilterType().name());
        requestHeader.setTopicSysFlag(Integer.valueOf(topicConfig.getTopicSysFlag()));
        requestHeader.setOrder(Boolean.valueOf(topicConfig.isOrder()));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)17, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public SendResult sendMessage(String addr, String brokerName, Message msg, SendMessageRequestHeader requestHeader, long timeoutMillis, CommunicationMode communicationMode, SendCallback sendCallback) throws RemotingException, MQBrokerException, InterruptedException {
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            msg.setTopic(VirtualEnvUtil.buildWithProjectGroup(msg.getTopic(), this.projectGroupPrefix));
            requestHeader.setProducerGroup(VirtualEnvUtil.buildWithProjectGroup(requestHeader.getProducerGroup(), this.projectGroupPrefix));
            requestHeader.setTopic(VirtualEnvUtil.buildWithProjectGroup(requestHeader.getTopic(), this.projectGroupPrefix));
        }
        RemotingCommand request = null;
        if (sendSmartMsg) {
            SendMessageRequestHeaderV2 requestHeaderV2 = SendMessageRequestHeaderV2.createSendMessageRequestHeaderV2((SendMessageRequestHeader)requestHeader);
            request = RemotingCommand.createRequestCommand((int)310, (CommandCustomHeader)requestHeaderV2);
        } else {
            request = RemotingCommand.createRequestCommand((int)10, (CommandCustomHeader)requestHeader);
        }
        request.setBody(msg.getBody());
        switch (communicationMode) {
            case ONEWAY: {
                this.remotingClient.invokeOneway(addr, request, timeoutMillis);
                return null;
            }
            case ASYNC: {
                this.sendMessageAsync(addr, brokerName, msg, timeoutMillis, request, sendCallback);
                return null;
            }
            case SYNC: {
                return this.sendMessageSync(addr, brokerName, msg, timeoutMillis, request);
            }
        }
        assert (false);
        return null;
    }

    private SendResult sendMessageSync(String addr, String brokerName, Message msg, long timeoutMillis, RemotingCommand request) throws RemotingException, MQBrokerException, InterruptedException {
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        return this.processSendResponse(brokerName, msg, response);
    }

    private void sendMessageAsync(String addr, final String brokerName, final Message msg, long timeoutMillis, RemotingCommand request, final SendCallback sendCallback) throws RemotingException, InterruptedException {
        this.remotingClient.invokeAsync(addr, request, timeoutMillis, new InvokeCallback(){

            public void operationComplete(ResponseFuture responseFuture) {
                if (null == sendCallback) {
                    return;
                }
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    try {
                        SendResult sendResult = MQClientAPIImpl.this.processSendResponse(brokerName, msg, response);
                        assert (sendResult != null);
                        sendCallback.onSuccess(sendResult);
                    }
                    catch (Exception e) {
                        sendCallback.onException(e);
                    }
                } else if (!responseFuture.isSendRequestOK()) {
                    sendCallback.onException(new MQClientException("send request failed", responseFuture.getCause()));
                } else if (responseFuture.isTimeout()) {
                    sendCallback.onException(new MQClientException("wait response timeout " + responseFuture.getTimeoutMillis() + "ms", responseFuture.getCause()));
                } else {
                    sendCallback.onException(new MQClientException("unknow reseaon", responseFuture.getCause()));
                }
            }
        });
    }

    private SendResult processSendResponse(String brokerName, Message msg, RemotingCommand response) throws MQBrokerException, RemotingCommandException {
        switch (response.getCode()) {
            case 0: 
            case 10: 
            case 11: 
            case 12: {
                SendStatus sendStatus = SendStatus.SEND_OK;
                switch (response.getCode()) {
                    case 10: {
                        sendStatus = SendStatus.FLUSH_DISK_TIMEOUT;
                        break;
                    }
                    case 12: {
                        sendStatus = SendStatus.FLUSH_SLAVE_TIMEOUT;
                        break;
                    }
                    case 11: {
                        sendStatus = SendStatus.SLAVE_NOT_AVAILABLE;
                        break;
                    }
                    case 0: {
                        sendStatus = SendStatus.SEND_OK;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                SendMessageResponseHeader responseHeader = (SendMessageResponseHeader)response.decodeCommandCustomHeader(SendMessageResponseHeader.class);
                MessageQueue messageQueue = new MessageQueue(msg.getTopic(), brokerName, responseHeader.getQueueId().intValue());
                return new SendResult(sendStatus, responseHeader.getMsgId(), messageQueue, responseHeader.getQueueOffset(), this.projectGroupPrefix);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public PullResult pullMessage(String addr, PullMessageRequestHeader requestHeader, long timeoutMillis, CommunicationMode communicationMode, PullCallback pullCallback) throws RemotingException, MQBrokerException, InterruptedException {
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            requestHeader.setConsumerGroup(VirtualEnvUtil.buildWithProjectGroup(requestHeader.getConsumerGroup(), this.projectGroupPrefix));
            requestHeader.setTopic(VirtualEnvUtil.buildWithProjectGroup(requestHeader.getTopic(), this.projectGroupPrefix));
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)11, (CommandCustomHeader)requestHeader);
        switch (communicationMode) {
            case ONEWAY: {
                assert (false);
                return null;
            }
            case ASYNC: {
                this.pullMessageAsync(addr, request, timeoutMillis, pullCallback);
                return null;
            }
            case SYNC: {
                return this.pullMessageSync(addr, request, timeoutMillis);
            }
        }
        assert (false);
        return null;
    }

    private void pullMessageAsync(String addr, RemotingCommand request, long timeoutMillis, final PullCallback pullCallback) throws RemotingException, InterruptedException {
        this.remotingClient.invokeAsync(addr, request, timeoutMillis, new InvokeCallback(){

            public void operationComplete(ResponseFuture responseFuture) {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    try {
                        PullResult pullResult = MQClientAPIImpl.this.processPullResponse(response);
                        assert (pullResult != null);
                        pullCallback.onSuccess(pullResult);
                    }
                    catch (Exception e) {
                        pullCallback.onException(e);
                    }
                } else if (!responseFuture.isSendRequestOK()) {
                    pullCallback.onException(new MQClientException("send request failed", responseFuture.getCause()));
                } else if (responseFuture.isTimeout()) {
                    pullCallback.onException(new MQClientException("wait response timeout " + responseFuture.getTimeoutMillis() + "ms", responseFuture.getCause()));
                } else {
                    pullCallback.onException(new MQClientException("unknow reseaon", responseFuture.getCause()));
                }
            }
        });
    }

    private PullResult processPullResponse(RemotingCommand response) throws MQBrokerException, RemotingCommandException {
        PullStatus pullStatus = PullStatus.NO_NEW_MSG;
        switch (response.getCode()) {
            case 0: {
                pullStatus = PullStatus.FOUND;
                break;
            }
            case 19: {
                pullStatus = PullStatus.NO_NEW_MSG;
                break;
            }
            case 20: {
                pullStatus = PullStatus.NO_MATCHED_MSG;
                break;
            }
            case 21: {
                pullStatus = PullStatus.OFFSET_ILLEGAL;
                break;
            }
            default: {
                throw new MQBrokerException(response.getCode(), response.getRemark());
            }
        }
        PullMessageResponseHeader responseHeader = (PullMessageResponseHeader)response.decodeCommandCustomHeader(PullMessageResponseHeader.class);
        return new PullResultExt(pullStatus, responseHeader.getNextBeginOffset(), responseHeader.getMinOffset(), responseHeader.getMaxOffset(), null, responseHeader.getSuggestWhichBrokerId(), response.getBody());
    }

    private PullResult pullMessageSync(String addr, RemotingCommand request, long timeoutMillis) throws RemotingException, InterruptedException, MQBrokerException {
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        return this.processPullResponse(response);
    }

    public MessageExt viewMessage(String addr, long phyoffset, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        ViewMessageRequestHeader requestHeader = new ViewMessageRequestHeader();
        requestHeader.setOffset(Long.valueOf(phyoffset));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)33, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(response.getBody());
                MessageExt messageExt = MessageDecoder.decode((ByteBuffer)byteBuffer);
                if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
                    messageExt.setTopic(VirtualEnvUtil.clearProjectGroup(messageExt.getTopic(), this.projectGroupPrefix));
                }
                return messageExt;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public long searchOffset(String addr, String topic, int queueId, long timestamp, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        String topicWithProjectGroup = topic;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            topicWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(topic, this.projectGroupPrefix);
        }
        SearchOffsetRequestHeader requestHeader = new SearchOffsetRequestHeader();
        requestHeader.setTopic(topicWithProjectGroup);
        requestHeader.setQueueId(Integer.valueOf(queueId));
        requestHeader.setTimestamp(Long.valueOf(timestamp));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)29, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                SearchOffsetResponseHeader responseHeader = (SearchOffsetResponseHeader)response.decodeCommandCustomHeader(SearchOffsetResponseHeader.class);
                return responseHeader.getOffset();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public long getMaxOffset(String addr, String topic, int queueId, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        String topicWithProjectGroup = topic;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            topicWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(topic, this.projectGroupPrefix);
        }
        GetMaxOffsetRequestHeader requestHeader = new GetMaxOffsetRequestHeader();
        requestHeader.setTopic(topicWithProjectGroup);
        requestHeader.setQueueId(Integer.valueOf(queueId));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)30, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetMaxOffsetResponseHeader responseHeader = (GetMaxOffsetResponseHeader)response.decodeCommandCustomHeader(GetMaxOffsetResponseHeader.class);
                return responseHeader.getOffset();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public List<String> getConsumerIdListByGroup(String addr, String consumerGroup, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQBrokerException, InterruptedException {
        String consumerGroupWithProjectGroup = consumerGroup;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            consumerGroupWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(consumerGroup, this.projectGroupPrefix);
        }
        GetConsumerListByGroupRequestHeader requestHeader = new GetConsumerListByGroupRequestHeader();
        requestHeader.setConsumerGroup(consumerGroupWithProjectGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)38, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                if (response.getBody() == null) break;
                GetConsumerListByGroupResponseBody body = (GetConsumerListByGroupResponseBody)GetConsumerListByGroupResponseBody.decode((byte[])response.getBody(), GetConsumerListByGroupResponseBody.class);
                return body.getConsumerIdList();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public long getMinOffset(String addr, String topic, int queueId, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        String topicWithProjectGroup = topic;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            topicWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(topic, this.projectGroupPrefix);
        }
        GetMinOffsetRequestHeader requestHeader = new GetMinOffsetRequestHeader();
        requestHeader.setTopic(topicWithProjectGroup);
        requestHeader.setQueueId(Integer.valueOf(queueId));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)31, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetMinOffsetResponseHeader responseHeader = (GetMinOffsetResponseHeader)response.decodeCommandCustomHeader(GetMinOffsetResponseHeader.class);
                return responseHeader.getOffset();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public long getEarliestMsgStoretime(String addr, String topic, int queueId, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        String topicWithProjectGroup = topic;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            topicWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(topic, this.projectGroupPrefix);
        }
        GetEarliestMsgStoretimeRequestHeader requestHeader = new GetEarliestMsgStoretimeRequestHeader();
        requestHeader.setTopic(topicWithProjectGroup);
        requestHeader.setQueueId(Integer.valueOf(queueId));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)32, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetEarliestMsgStoretimeResponseHeader responseHeader = (GetEarliestMsgStoretimeResponseHeader)response.decodeCommandCustomHeader(GetEarliestMsgStoretimeResponseHeader.class);
                return responseHeader.getTimestamp();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public long queryConsumerOffset(String addr, QueryConsumerOffsetRequestHeader requestHeader, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            requestHeader.setConsumerGroup(VirtualEnvUtil.buildWithProjectGroup(requestHeader.getConsumerGroup(), this.projectGroupPrefix));
            requestHeader.setTopic(VirtualEnvUtil.buildWithProjectGroup(requestHeader.getTopic(), this.projectGroupPrefix));
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)14, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                QueryConsumerOffsetResponseHeader responseHeader = (QueryConsumerOffsetResponseHeader)response.decodeCommandCustomHeader(QueryConsumerOffsetResponseHeader.class);
                return responseHeader.getOffset();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void updateConsumerOffset(String addr, UpdateConsumerOffsetRequestHeader requestHeader, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            requestHeader.setConsumerGroup(VirtualEnvUtil.buildWithProjectGroup(requestHeader.getConsumerGroup(), this.projectGroupPrefix));
            requestHeader.setTopic(VirtualEnvUtil.buildWithProjectGroup(requestHeader.getTopic(), this.projectGroupPrefix));
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)15, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void updateConsumerOffsetOneway(String addr, UpdateConsumerOffsetRequestHeader requestHeader, long timeoutMillis) throws RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException, InterruptedException {
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            requestHeader.setConsumerGroup(VirtualEnvUtil.buildWithProjectGroup(requestHeader.getConsumerGroup(), this.projectGroupPrefix));
            requestHeader.setTopic(VirtualEnvUtil.buildWithProjectGroup(requestHeader.getTopic(), this.projectGroupPrefix));
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)15, (CommandCustomHeader)requestHeader);
        this.remotingClient.invokeOneway(addr, request, timeoutMillis);
    }

    public void sendHearbeat(String addr, HeartbeatData heartbeatData, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            Set consumerDatas = heartbeatData.getConsumerDataSet();
            for (ConsumerData consumerData : consumerDatas) {
                consumerData.setGroupName(VirtualEnvUtil.buildWithProjectGroup(consumerData.getGroupName(), this.projectGroupPrefix));
                Set subscriptionDatas = consumerData.getSubscriptionDataSet();
                for (SubscriptionData subscriptionData : subscriptionDatas) {
                    subscriptionData.setTopic(VirtualEnvUtil.buildWithProjectGroup(subscriptionData.getTopic(), this.projectGroupPrefix));
                }
            }
            Set producerDatas = heartbeatData.getProducerDataSet();
            for (ProducerData producerData : producerDatas) {
                producerData.setGroupName(VirtualEnvUtil.buildWithProjectGroup(producerData.getGroupName(), this.projectGroupPrefix));
            }
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)34, null);
        request.setBody(heartbeatData.encode());
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void unregisterClient(String addr, String clientID, String producerGroup, String consumerGroup, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        String producerGroupWithProjectGroup = producerGroup;
        String consumerGroupWithProjectGroup = consumerGroup;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            producerGroupWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(producerGroup, this.projectGroupPrefix);
            consumerGroupWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(consumerGroup, this.projectGroupPrefix);
        }
        UnregisterClientRequestHeader requestHeader = new UnregisterClientRequestHeader();
        requestHeader.setClientID(clientID);
        requestHeader.setProducerGroup(producerGroupWithProjectGroup);
        requestHeader.setConsumerGroup(consumerGroupWithProjectGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)35, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void endTransactionOneway(String addr, EndTransactionRequestHeader requestHeader, String remark, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            requestHeader.setProducerGroup(VirtualEnvUtil.buildWithProjectGroup(requestHeader.getProducerGroup(), this.projectGroupPrefix));
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)37, (CommandCustomHeader)requestHeader);
        request.setRemark(remark);
        this.remotingClient.invokeOneway(addr, request, timeoutMillis);
    }

    public void queryMessage(String addr, QueryMessageRequestHeader requestHeader, long timeoutMillis, InvokeCallback invokeCallback) throws RemotingException, MQBrokerException, InterruptedException {
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            requestHeader.setTopic(VirtualEnvUtil.buildWithProjectGroup(requestHeader.getTopic(), this.projectGroupPrefix));
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)12, (CommandCustomHeader)requestHeader);
        this.remotingClient.invokeAsync(addr, request, timeoutMillis, invokeCallback);
    }

    public boolean registerClient(String addr, HeartbeatData heartbeat, long timeoutMillis) throws RemotingException, InterruptedException {
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            Set consumerDatas = heartbeat.getConsumerDataSet();
            for (ConsumerData consumerData : consumerDatas) {
                consumerData.setGroupName(VirtualEnvUtil.buildWithProjectGroup(consumerData.getGroupName(), this.projectGroupPrefix));
                Set subscriptionDatas = consumerData.getSubscriptionDataSet();
                for (SubscriptionData subscriptionData : subscriptionDatas) {
                    subscriptionData.setTopic(VirtualEnvUtil.buildWithProjectGroup(subscriptionData.getTopic(), this.projectGroupPrefix));
                }
            }
            Set producerDatas = heartbeat.getProducerDataSet();
            for (ProducerData producerData : producerDatas) {
                producerData.setGroupName(VirtualEnvUtil.buildWithProjectGroup(producerData.getGroupName(), this.projectGroupPrefix));
            }
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)34, null);
        request.setBody(heartbeat.encode());
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        return response.getCode() == 0;
    }

    public void consumerSendMessageBack(String addr, MessageExt msg, String consumerGroup, int delayLevel, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        String consumerGroupWithProjectGroup = consumerGroup;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            consumerGroupWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(consumerGroup, this.projectGroupPrefix);
            msg.setTopic(VirtualEnvUtil.buildWithProjectGroup(msg.getTopic(), this.projectGroupPrefix));
        }
        ConsumerSendMsgBackRequestHeader requestHeader = new ConsumerSendMsgBackRequestHeader();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)36, (CommandCustomHeader)requestHeader);
        requestHeader.setGroup(consumerGroupWithProjectGroup);
        requestHeader.setOriginTopic(msg.getTopic());
        requestHeader.setOffset(Long.valueOf(msg.getCommitLogOffset()));
        requestHeader.setDelayLevel(Integer.valueOf(delayLevel));
        requestHeader.setOriginMsgId(msg.getMsgId());
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public Set<MessageQueue> lockBatchMQ(String addr, LockBatchRequestBody requestBody, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException {
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            requestBody.setConsumerGroup(VirtualEnvUtil.buildWithProjectGroup(requestBody.getConsumerGroup(), this.projectGroupPrefix));
            Set messageQueues = requestBody.getMqSet();
            for (MessageQueue messageQueue : messageQueues) {
                messageQueue.setTopic(VirtualEnvUtil.buildWithProjectGroup(messageQueue.getTopic(), this.projectGroupPrefix));
            }
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)41, null);
        request.setBody(requestBody.encode());
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                LockBatchResponseBody responseBody = (LockBatchResponseBody)LockBatchResponseBody.decode((byte[])response.getBody(), LockBatchResponseBody.class);
                Set messageQueues = responseBody.getLockOKMQSet();
                if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
                    for (MessageQueue messageQueue : messageQueues) {
                        messageQueue.setTopic(VirtualEnvUtil.clearProjectGroup(messageQueue.getTopic(), this.projectGroupPrefix));
                    }
                }
                return messageQueues;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void unlockBatchMQ(String addr, UnlockBatchRequestBody requestBody, long timeoutMillis, boolean oneway) throws RemotingException, MQBrokerException, InterruptedException {
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            requestBody.setConsumerGroup(VirtualEnvUtil.buildWithProjectGroup(requestBody.getConsumerGroup(), this.projectGroupPrefix));
            Set messageQueues = requestBody.getMqSet();
            for (MessageQueue messageQueue : messageQueues) {
                messageQueue.setTopic(VirtualEnvUtil.buildWithProjectGroup(messageQueue.getTopic(), this.projectGroupPrefix));
            }
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)42, null);
        request.setBody(requestBody.encode());
        if (!oneway) {
            RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
            switch (response.getCode()) {
                case 0: {
                    return;
                }
            }
            throw new MQBrokerException(response.getCode(), response.getRemark());
        }
        this.remotingClient.invokeOneway(addr, request, timeoutMillis);
    }

    public TopicStatsTable getTopicStatsInfo(String addr, String topic, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        String topicWithProjectGroup = topic;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            topicWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(topic, this.projectGroupPrefix);
        }
        GetTopicStatsInfoRequestHeader requestHeader = new GetTopicStatsInfoRequestHeader();
        requestHeader.setTopic(topicWithProjectGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)202, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                TopicStatsTable topicStatsTable = (TopicStatsTable)TopicStatsTable.decode((byte[])response.getBody(), TopicStatsTable.class);
                if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
                    HashMap newTopicOffsetMap = new HashMap();
                    for (Map.Entry messageQueue : topicStatsTable.getOffsetTable().entrySet()) {
                        MessageQueue key = (MessageQueue)messageQueue.getKey();
                        key.setTopic(VirtualEnvUtil.clearProjectGroup(key.getTopic(), this.projectGroupPrefix));
                        newTopicOffsetMap.put(key, messageQueue.getValue());
                    }
                    topicStatsTable.setOffsetTable(newTopicOffsetMap);
                }
                return topicStatsTable;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public ConsumeStats getConsumeStats(String addr, String consumerGroup, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        String consumerGroupWithProjectGroup = consumerGroup;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            consumerGroupWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(consumerGroup, this.projectGroupPrefix);
        }
        GetConsumeStatsRequestHeader requestHeader = new GetConsumeStatsRequestHeader();
        requestHeader.setConsumerGroup(consumerGroupWithProjectGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)208, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                ConsumeStats consumeStats = (ConsumeStats)ConsumeStats.decode((byte[])response.getBody(), ConsumeStats.class);
                if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
                    HashMap newTopicOffsetMap = new HashMap();
                    for (Map.Entry messageQueue : consumeStats.getOffsetTable().entrySet()) {
                        MessageQueue key = (MessageQueue)messageQueue.getKey();
                        key.setTopic(VirtualEnvUtil.clearProjectGroup(key.getTopic(), this.projectGroupPrefix));
                        newTopicOffsetMap.put(key, messageQueue.getValue());
                    }
                    consumeStats.setOffsetTable(newTopicOffsetMap);
                }
                return consumeStats;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public ProducerConnection getProducerConnectionList(String addr, String producerGroup, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        String producerGroupWithProjectGroup = producerGroup;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            producerGroupWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(producerGroup, this.projectGroupPrefix);
        }
        GetProducerConnectionListRequestHeader requestHeader = new GetProducerConnectionListRequestHeader();
        requestHeader.setProducerGroup(producerGroupWithProjectGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)204, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                return (ProducerConnection)ProducerConnection.decode((byte[])response.getBody(), ProducerConnection.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public ConsumerConnection getConsumerConnectionList(String addr, String consumerGroup, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        String consumerGroupWithProjectGroup = consumerGroup;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            consumerGroupWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(consumerGroup, this.projectGroupPrefix);
        }
        GetConsumerConnectionListRequestHeader requestHeader = new GetConsumerConnectionListRequestHeader();
        requestHeader.setConsumerGroup(consumerGroupWithProjectGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)203, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                ConsumerConnection consumerConnection = (ConsumerConnection)ConsumerConnection.decode((byte[])response.getBody(), ConsumerConnection.class);
                if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
                    ConcurrentHashMap subscriptionDataConcurrentHashMap = consumerConnection.getSubscriptionTable();
                    for (Map.Entry subscriptionDataEntry : subscriptionDataConcurrentHashMap.entrySet()) {
                        SubscriptionData subscriptionData = (SubscriptionData)subscriptionDataEntry.getValue();
                        ((SubscriptionData)subscriptionDataEntry.getValue()).setTopic(VirtualEnvUtil.clearProjectGroup(subscriptionData.getTopic(), this.projectGroupPrefix));
                    }
                }
                return consumerConnection;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public KVTable getBrokerRuntimeInfo(String addr, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)28, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                return (KVTable)KVTable.decode((byte[])response.getBody(), KVTable.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public void updateBrokerConfig(String addr, Properties properties, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException, UnsupportedEncodingException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)25, null);
        String str = MixAll.properties2String((Properties)properties);
        if (str != null && str.length() > 0) {
            request.setBody(str.getBytes("UTF-8"));
            RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
            switch (response.getCode()) {
                case 0: {
                    return;
                }
            }
            throw new MQBrokerException(response.getCode(), response.getRemark());
        }
    }

    public ClusterInfo getBrokerClusterInfo(long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)106, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                ClusterInfo responseBody = (ClusterInfo)ClusterInfo.decode((byte[])response.getBody(), ClusterInfo.class);
                return responseBody;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public TopicRouteData getDefaultTopicRouteInfoFromNameServer(String topic, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        GetRouteInfoRequestHeader requestHeader = new GetRouteInfoRequestHeader();
        requestHeader.setTopic(topic);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)105, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 17: {
                break;
            }
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                return (TopicRouteData)TopicRouteData.decode((byte[])body, TopicRouteData.class);
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public TopicRouteData getTopicRouteInfoFromNameServer(String topic, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        String topicWithProjectGroup = topic;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            topicWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(topic, this.projectGroupPrefix);
        }
        GetRouteInfoRequestHeader requestHeader = new GetRouteInfoRequestHeader();
        requestHeader.setTopic(topicWithProjectGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)105, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 17: {
                log.warn("get Topic [{}] RouteInfoFromNameServer is not exist value", (Object)topic);
                break;
            }
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                return (TopicRouteData)TopicRouteData.decode((byte[])body, TopicRouteData.class);
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public TopicList getTopicListFromNameServer(long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)206, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])body, TopicList.class);
                if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
                    HashSet<String> newTopicSet = new HashSet<String>();
                    for (String topic : topicList.getTopicList()) {
                        newTopicSet.add(VirtualEnvUtil.clearProjectGroup(topic, this.projectGroupPrefix));
                    }
                    topicList.setTopicList(newTopicSet);
                }
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public int wipeWritePermOfBroker(String namesrvAddr, String brokerName, long timeoutMillis) throws RemotingCommandException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQClientException {
        WipeWritePermOfBrokerRequestHeader requestHeader = new WipeWritePermOfBrokerRequestHeader();
        requestHeader.setBrokerName(brokerName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)205, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                WipeWritePermOfBrokerResponseHeader responseHeader = (WipeWritePermOfBrokerResponseHeader)response.decodeCommandCustomHeader(WipeWritePermOfBrokerResponseHeader.class);
                return responseHeader.getWipeTopicCount();
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void deleteTopicInBroker(String addr, String topic, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        String topicWithProjectGroup = topic;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            topicWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(topic, this.projectGroupPrefix);
        }
        DeleteTopicRequestHeader requestHeader = new DeleteTopicRequestHeader();
        requestHeader.setTopic(topicWithProjectGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)215, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void deleteTopicInNameServer(String addr, String topic, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        String topicWithProjectGroup = topic;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            topicWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(topic, this.projectGroupPrefix);
        }
        DeleteTopicRequestHeader requestHeader = new DeleteTopicRequestHeader();
        requestHeader.setTopic(topicWithProjectGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)216, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void deleteSubscriptionGroup(String addr, String groupName, long timeoutMillis) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        String groupWithProjectGroup = groupName;
        if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
            groupWithProjectGroup = VirtualEnvUtil.buildWithProjectGroup(groupName, this.projectGroupPrefix);
        }
        DeleteSubscriptionGroupRequestHeader requestHeader = new DeleteSubscriptionGroupRequestHeader();
        requestHeader.setGroupName(groupWithProjectGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)207, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public String getKVConfigValue(String namespace, String key, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        GetKVConfigRequestHeader requestHeader = new GetKVConfigRequestHeader();
        requestHeader.setNamespace(namespace);
        requestHeader.setKey(key);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)101, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetKVConfigResponseHeader responseHeader = (GetKVConfigResponseHeader)response.decodeCommandCustomHeader(GetKVConfigResponseHeader.class);
                return responseHeader.getValue();
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void putKVConfigValue(String namespace, String key, String value, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        PutKVConfigRequestHeader requestHeader = new PutKVConfigRequestHeader();
        requestHeader.setNamespace(namespace);
        requestHeader.setKey(key);
        requestHeader.setValue(value);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)100, (CommandCustomHeader)requestHeader);
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        if (nameServerAddressList != null) {
            RemotingCommand errResponse = null;
            block3: for (String namesrvAddr : nameServerAddressList) {
                RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, timeoutMillis);
                assert (response != null);
                switch (response.getCode()) {
                    case 0: {
                        continue block3;
                    }
                }
                errResponse = response;
            }
            if (errResponse != null) {
                throw new MQClientException(errResponse.getCode(), errResponse.getRemark());
            }
        }
    }

    public void deleteKVConfigValue(String namespace, String key, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        DeleteKVConfigRequestHeader requestHeader = new DeleteKVConfigRequestHeader();
        requestHeader.setNamespace(namespace);
        requestHeader.setKey(key);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)102, (CommandCustomHeader)requestHeader);
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        if (nameServerAddressList != null) {
            RemotingCommand errResponse = null;
            block3: for (String namesrvAddr : nameServerAddressList) {
                RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, timeoutMillis);
                assert (response != null);
                switch (response.getCode()) {
                    case 0: {
                        continue block3;
                    }
                }
                errResponse = response;
            }
            if (errResponse != null) {
                throw new MQClientException(errResponse.getCode(), errResponse.getRemark());
            }
        }
    }

    public String getProjectGroupByIp(String ip, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        return this.getKVConfigValue("PROJECT_CONFIG", ip, timeoutMillis);
    }

    public String getKVConfigByValue(String namespace, String value, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        GetKVConfigRequestHeader requestHeader = new GetKVConfigRequestHeader();
        requestHeader.setNamespace(namespace);
        requestHeader.setKey(value);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)217, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                GetKVConfigResponseHeader responseHeader = (GetKVConfigResponseHeader)response.decodeCommandCustomHeader(GetKVConfigResponseHeader.class);
                return responseHeader.getValue();
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public KVTable getKVListByNamespace(String namespace, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        GetKVListByNamespaceRequestHeader requestHeader = new GetKVListByNamespaceRequestHeader();
        requestHeader.setNamespace(namespace);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)219, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (KVTable)KVTable.decode((byte[])response.getBody(), KVTable.class);
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void deleteKVConfigByValue(String namespace, String projectGroup, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        DeleteKVConfigRequestHeader requestHeader = new DeleteKVConfigRequestHeader();
        requestHeader.setNamespace(namespace);
        requestHeader.setKey(projectGroup);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)218, (CommandCustomHeader)requestHeader);
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        if (nameServerAddressList != null) {
            RemotingCommand errResponse = null;
            block3: for (String namesrvAddr : nameServerAddressList) {
                RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, timeoutMillis);
                assert (response != null);
                switch (response.getCode()) {
                    case 0: {
                        continue block3;
                    }
                }
                errResponse = response;
            }
            if (errResponse != null) {
                throw new MQClientException(errResponse.getCode(), errResponse.getRemark());
            }
        }
    }

    public Map<MessageQueue, Long> invokeBrokerToResetOffset(String addr, String topic, String group, long timestamp, boolean isForce, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        ResetOffsetRequestHeader requestHeader = new ResetOffsetRequestHeader();
        requestHeader.setTopic(topic);
        requestHeader.setGroup(group);
        requestHeader.setTimestamp(timestamp);
        requestHeader.setForce(isForce);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)222, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                if (response.getBody() == null) break;
                ResetOffsetBody body = (ResetOffsetBody)ResetOffsetBody.decode((byte[])response.getBody(), ResetOffsetBody.class);
                return body.getOffsetTable();
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public Map<String, Map<MessageQueue, Long>> invokeBrokerToGetConsumerStatus(String addr, String topic, String group, String clientAddr, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        GetConsumerStatusRequestHeader requestHeader = new GetConsumerStatusRequestHeader();
        requestHeader.setTopic(topic);
        requestHeader.setGroup(group);
        requestHeader.setClientAddr(clientAddr);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)223, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                if (response.getBody() == null) break;
                GetConsumerStatusBody body = (GetConsumerStatusBody)GetConsumerStatusBody.decode((byte[])response.getBody(), GetConsumerStatusBody.class);
                return body.getConsumerTable();
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public GroupList queryTopicConsumeByWho(String addr, String topic, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        QueryTopicConsumeByWhoRequestHeader requestHeader = new QueryTopicConsumeByWhoRequestHeader();
        requestHeader.setTopic(topic);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)300, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                GroupList groupList = (GroupList)GroupList.decode((byte[])response.getBody(), GroupList.class);
                return groupList;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public Set<QueueTimeSpan> queryConsumeTimeSpan(String addr, String topic, String group, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        QueryConsumeTimeSpanRequestHeader requestHeader = new QueryConsumeTimeSpanRequestHeader();
        requestHeader.setTopic(topic);
        requestHeader.setGroup(group);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)303, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                QueryConsumeTimeSpanBody consumeTimeSpanBody = (QueryConsumeTimeSpanBody)GroupList.decode((byte[])response.getBody(), QueryConsumeTimeSpanBody.class);
                return consumeTimeSpanBody.getConsumeTimeSpanSet();
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public TopicList getTopicsByCluster(String cluster, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        GetTopicsByClusterRequestHeader requestHeader = new GetTopicsByClusterRequestHeader();
        requestHeader.setCluster(cluster);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)224, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])body, TopicList.class);
                if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
                    HashSet<String> newTopicSet = new HashSet<String>();
                    for (String topic : topicList.getTopicList()) {
                        newTopicSet.add(VirtualEnvUtil.clearProjectGroup(topic, this.projectGroupPrefix));
                    }
                    topicList.setTopicList(newTopicSet);
                }
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void registerMessageFilterClass(String addr, String consumerGroup, String topic, String className, int classCRC, byte[] classBody, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RegisterMessageFilterClassRequestHeader requestHeader = new RegisterMessageFilterClassRequestHeader();
        requestHeader.setConsumerGroup(consumerGroup);
        requestHeader.setClassName(className);
        requestHeader.setTopic(topic);
        requestHeader.setClassCRC(Integer.valueOf(classCRC));
        RemotingCommand request = RemotingCommand.createRequestCommand((int)302, (CommandCustomHeader)requestHeader);
        request.setBody(classBody);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark());
    }

    public TopicList getSystemTopicList(long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)304, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                TopicList tmp;
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])response.getBody(), TopicList.class);
                if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
                    HashSet<String> newTopicSet = new HashSet<String>();
                    for (String topic : topicList.getTopicList()) {
                        newTopicSet.add(VirtualEnvUtil.clearProjectGroup(topic, this.projectGroupPrefix));
                    }
                    topicList.setTopicList(newTopicSet);
                }
                if (!(topicList.getTopicList() == null || topicList.getTopicList().isEmpty() || UtilAll.isBlank((String)topicList.getBrokerAddr()) || (tmp = this.getSystemTopicListFromBroker(topicList.getBrokerAddr(), timeoutMillis)).getTopicList() == null || tmp.getTopicList().isEmpty())) {
                    topicList.getTopicList().addAll(tmp.getTopicList());
                }
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public TopicList getSystemTopicListFromBroker(String addr, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)305, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])body, TopicList.class);
                if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
                    HashSet<String> newTopicSet = new HashSet<String>();
                    for (String topic : topicList.getTopicList()) {
                        newTopicSet.add(VirtualEnvUtil.clearProjectGroup(topic, this.projectGroupPrefix));
                    }
                    topicList.setTopicList(newTopicSet);
                }
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public boolean cleanExpiredConsumeQueue(String addr, long timeoutMillis) throws MQClientException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)306, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        switch (response.getCode()) {
            case 0: {
                return true;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public ConsumerRunningInfo getConsumerRunningInfo(String addr, String consumerGroup, String clientId, boolean jstack, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        GetConsumerRunningInfoRequestHeader requestHeader = new GetConsumerRunningInfoRequestHeader();
        requestHeader.setConsumerGroup(consumerGroup);
        requestHeader.setClientId(clientId);
        requestHeader.setJstackEnable(jstack);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)307, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                ConsumerRunningInfo info = (ConsumerRunningInfo)ConsumerRunningInfo.decode((byte[])body, ConsumerRunningInfo.class);
                return info;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public ConsumeMessageDirectlyResult consumeMessageDirectly(String addr, String consumerGroup, String clientId, String msgId, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        ConsumeMessageDirectlyResultRequestHeader requestHeader = new ConsumeMessageDirectlyResultRequestHeader();
        requestHeader.setConsumerGroup(consumerGroup);
        requestHeader.setClientId(clientId);
        requestHeader.setMsgId(msgId);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)309, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                ConsumeMessageDirectlyResult info = (ConsumeMessageDirectlyResult)ConsumeMessageDirectlyResult.decode((byte[])body, ConsumeMessageDirectlyResult.class);
                return info;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public String getProjectGroupPrefix() {
        return this.projectGroupPrefix;
    }

    public Map<Integer, Long> queryCorrectionOffset(String addr, String topic, String group, Set<String> filterGroup, long timeoutMillis) throws MQClientException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        QueryCorrectionOffsetHeader requestHeader = new QueryCorrectionOffsetHeader();
        requestHeader.setCompareGroup(group);
        requestHeader.setTopic(topic);
        if (filterGroup != null) {
            StringBuilder sb = new StringBuilder();
            String splitor = "";
            for (String s : filterGroup) {
                sb.append(splitor).append(s);
                splitor = ",";
            }
            requestHeader.setFilterGroups(sb.toString());
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)308, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                if (response.getBody() == null) break;
                QueryCorrectionOffsetBody body = (QueryCorrectionOffsetBody)QueryCorrectionOffsetBody.decode((byte[])response.getBody(), QueryCorrectionOffsetBody.class);
                return body.getCorrectionOffsets();
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public TopicList getUnitTopicList(boolean containRetry, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)311, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])response.getBody(), TopicList.class);
                if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
                    HashSet<String> newTopicSet = new HashSet<String>();
                    for (String topic : topicList.getTopicList()) {
                        newTopicSet.add(VirtualEnvUtil.clearProjectGroup(topic, this.projectGroupPrefix));
                    }
                    topicList.setTopicList(newTopicSet);
                }
                if (!containRetry) {
                    Iterator it = topicList.getTopicList().iterator();
                    while (it.hasNext()) {
                        String topic = (String)it.next();
                        if (!topic.startsWith("%RETRY%")) continue;
                        it.remove();
                    }
                }
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public TopicList getHasUnitSubTopicList(boolean containRetry, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)312, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])response.getBody(), TopicList.class);
                if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
                    HashSet<String> newTopicSet = new HashSet<String>();
                    for (String topic : topicList.getTopicList()) {
                        newTopicSet.add(VirtualEnvUtil.clearProjectGroup(topic, this.projectGroupPrefix));
                    }
                    topicList.setTopicList(newTopicSet);
                }
                if (!containRetry) {
                    Iterator it = topicList.getTopicList().iterator();
                    while (it.hasNext()) {
                        String topic = (String)it.next();
                        if (!topic.startsWith("%RETRY%")) continue;
                        it.remove();
                    }
                }
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public TopicList getHasUnitSubUnUnitTopicList(boolean containRetry, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)313, null);
        RemotingCommand response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                byte[] body = response.getBody();
                if (body == null) break;
                TopicList topicList = (TopicList)TopicList.decode((byte[])response.getBody(), TopicList.class);
                if (!UtilAll.isBlank((String)this.projectGroupPrefix)) {
                    HashSet<String> newTopicSet = new HashSet<String>();
                    for (String topic : topicList.getTopicList()) {
                        newTopicSet.add(VirtualEnvUtil.clearProjectGroup(topic, this.projectGroupPrefix));
                    }
                    topicList.setTopicList(newTopicSet);
                }
                if (!containRetry) {
                    Iterator it = topicList.getTopicList().iterator();
                    while (it.hasNext()) {
                        String topic = (String)it.next();
                        if (!topic.startsWith("%RETRY%")) continue;
                        it.remove();
                    }
                }
                return topicList;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    public void cloneGroupOffset(String addr, String srcGroup, String destGroup, String topic, boolean isOffline, long timeoutMillis) throws RemotingException, MQClientException, InterruptedException {
        CloneGroupOffsetRequestHeader requestHeader = new CloneGroupOffsetRequestHeader();
        requestHeader.setSrcGroup(srcGroup);
        requestHeader.setDestGroup(destGroup);
        requestHeader.setTopic(topic);
        requestHeader.setOffline(isOffline);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)314, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, timeoutMillis);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQClientException(response.getCode(), response.getRemark());
    }

    static {
        System.setProperty(RemotingCommand.RemotingVersionKey, Integer.toString(MQVersion.CurrentVersion));
        log = ClientLogger.getLog();
        sendSmartMsg = Boolean.parseBoolean(System.getProperty("com.alibaba.rocketmq.client.sendSmartMsg", "false"));
    }
}

