/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.remoting.protocol;

import com.alibaba.rocketmq.remoting.protocol.LanguageCode;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.alibaba.rocketmq.remoting.protocol.RemotingSerializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class RocketMQSerializable {
    public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    public static byte[] rocketMQProtocolEncode(RemotingCommand cmd) {
        byte[] remarkBytes = null;
        int remarkLen = 0;
        if (cmd.getRemark() != null && cmd.getRemark().length() > 0) {
            remarkBytes = cmd.getRemark().getBytes(RemotingSerializable.CHARSET_UTF8);
            remarkLen = remarkBytes.length;
        }
        byte[] extFieldsBytes = null;
        int extLen = 0;
        if (cmd.getExtFields() != null && !cmd.getExtFields().isEmpty()) {
            extFieldsBytes = RocketMQSerializable.mapSerialize(cmd.getExtFields());
            extLen = extFieldsBytes.length;
        }
        int totalLen = RocketMQSerializable.calTotalLen(remarkLen, extLen);
        ByteBuffer headerBuffer = ByteBuffer.allocate(totalLen);
        headerBuffer.putShort((short)cmd.getCode());
        headerBuffer.put(cmd.getLanguage().getCode());
        headerBuffer.putShort((short)cmd.getVersion());
        headerBuffer.putInt(cmd.getOpaque());
        headerBuffer.putInt(cmd.getFlag());
        if (remarkBytes != null) {
            headerBuffer.putInt(remarkBytes.length);
            headerBuffer.put(remarkBytes);
        } else {
            headerBuffer.putInt(0);
        }
        if (extFieldsBytes != null) {
            headerBuffer.putInt(extFieldsBytes.length);
            headerBuffer.put(extFieldsBytes);
        } else {
            headerBuffer.putInt(0);
        }
        return headerBuffer.array();
    }

    public static byte[] mapSerialize(HashMap<String, String> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        int totalLength = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            int kvLength = 2 + entry.getKey().getBytes(RemotingSerializable.CHARSET_UTF8).length + 4 + entry.getValue().getBytes(RemotingSerializable.CHARSET_UTF8).length;
            totalLength += kvLength;
        }
        ByteBuffer content = ByteBuffer.allocate(totalLength);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            byte[] key = entry.getKey().getBytes(RemotingSerializable.CHARSET_UTF8);
            byte[] val = entry.getValue().getBytes(RemotingSerializable.CHARSET_UTF8);
            content.putShort((short)key.length);
            content.put(key);
            content.putInt(val.length);
            content.put(val);
        }
        return content.array();
    }

    private static int calTotalLen(int remark, int ext) {
        int length = 17 + remark + 4 + ext;
        return length;
    }

    public static RemotingCommand rocketMQProtocolDecode(byte[] headerArray) {
        int extFieldsLength;
        RemotingCommand cmd = new RemotingCommand();
        ByteBuffer headerBuffer = ByteBuffer.wrap(headerArray);
        cmd.setCode(headerBuffer.getShort());
        cmd.setLanguage(LanguageCode.valueOf(headerBuffer.get()));
        cmd.setVersion(headerBuffer.getShort());
        cmd.setOpaque(headerBuffer.getInt());
        cmd.setFlag(headerBuffer.getInt());
        int remarkLength = headerBuffer.getInt();
        if (remarkLength > 0) {
            byte[] remarkContent = new byte[remarkLength];
            headerBuffer.get(remarkContent);
            cmd.setRemark(new String(remarkContent, RemotingSerializable.CHARSET_UTF8));
        }
        if ((extFieldsLength = headerBuffer.getInt()) > 0) {
            byte[] extFieldsBytes = new byte[extFieldsLength];
            headerBuffer.get(extFieldsBytes);
            cmd.setExtFields(RocketMQSerializable.mapDeserialize(extFieldsBytes));
        }
        return cmd;
    }

    public static HashMap<String, String> mapDeserialize(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        short keySize = 0;
        byte[] keyContent = null;
        int valSize = 0;
        byte[] valContent = null;
        while (byteBuffer.hasRemaining()) {
            keySize = byteBuffer.getShort();
            keyContent = new byte[keySize];
            byteBuffer.get(keyContent);
            valSize = byteBuffer.getInt();
            valContent = new byte[valSize];
            byteBuffer.get(valContent);
            map.put(new String(keyContent, RemotingSerializable.CHARSET_UTF8), new String(valContent, RemotingSerializable.CHARSET_UTF8));
        }
        return map;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

