/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.anno.CacheConsts;
import com.alicp.jetcache.autoconfigure.ConfigTree;
import com.alicp.jetcache.autoconfigure.ExternalCacheAutoInit;
import com.alicp.jetcache.autoconfigure.JetCacheCondition;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.redis.lettuce.JetCacheCodec;
import com.alicp.jetcache.redis.lettuce.LettuceConnectionManager;
import com.alicp.jetcache.redis.lettuce.RedisLettuceCacheBuilder;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterslave.MasterSlave;
import io.lettuce.core.masterslave.StatefulRedisMasterSlaveConnection;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={RedisLettuceCondition.class})
public class RedisLettuceAutoConfiguration {
    public static final String AUTO_INIT_BEAN_NAME = "redisLettuceAutoInit";

    @Bean(name={"redisLettuceAutoInit"})
    public RedisLettuceAutoInit redisLettuceAutoInit() {
        return new RedisLettuceAutoInit();
    }

    public static class RedisLettuceAutoInit
    extends ExternalCacheAutoInit {
        public RedisLettuceAutoInit() {
            super("redis.lettuce");
        }

        @Override
        protected CacheBuilder initCache(ConfigTree ct, String cacheAreaWithPrefix) {
            StatefulRedisMasterSlaveConnection c;
            RedisClient client;
            Map<String, Object> map = ct.subTree("uri").getProperties();
            String readFromStr = (String)ct.getProperty("readFrom");
            long asyncResultTimeoutInMillis = Long.parseLong(ct.getProperty("asyncResultTimeoutInMillis", Long.toString(CacheConsts.ASYNC_RESULT_TIMEOUT.toMillis())));
            ReadFrom readFrom = null;
            if (readFromStr != null) {
                readFrom = ReadFrom.valueOf((String)readFromStr.trim());
            }
            StatefulRedisMasterSlaveConnection connection = null;
            if (map == null || map.size() == 0) {
                throw new CacheConfigException("uri is required");
            }
            if (map.size() == 1) {
                String uri = (String)map.values().iterator().next();
                if (readFrom == null) {
                    client = RedisClient.create((String)uri);
                    client.setOptions(ClientOptions.builder().disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).build());
                } else {
                    client = RedisClient.create();
                    client.setOptions(ClientOptions.builder().disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).build());
                    c = MasterSlave.connect((RedisClient)client, (RedisCodec)new JetCacheCodec(), (RedisURI)RedisURI.create((String)uri));
                    c.setReadFrom(readFrom);
                    connection = c;
                }
            } else {
                List list = map.values().stream().map(k -> RedisURI.create((URI)URI.create(k.toString()))).collect(Collectors.toList());
                client = RedisClusterClient.create(list);
                ((RedisClusterClient)client).setOptions(ClusterClientOptions.builder().disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).build());
                if (readFrom != null) {
                    c = ((RedisClusterClient)client).connect((RedisCodec)new JetCacheCodec());
                    c.setReadFrom(readFrom);
                    connection = c;
                }
            }
            ExternalCacheBuilder externalCacheBuilder = ((RedisLettuceCacheBuilder.RedisLettuceCacheBuilderImpl)((RedisLettuceCacheBuilder.RedisLettuceCacheBuilderImpl)RedisLettuceCacheBuilder.createRedisLettuceCacheBuilder().connection(connection)).redisClient((AbstractRedisClient)client)).asyncResultTimeoutInMillis(asyncResultTimeoutInMillis);
            this.parseGeneralConfig((CacheBuilder)externalCacheBuilder, ct);
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".client", client);
            LettuceConnectionManager m = LettuceConnectionManager.defaultManager();
            m.init((AbstractRedisClient)client, (StatefulConnection)connection);
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".connection", m.connection((AbstractRedisClient)client));
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".commands", m.commands((AbstractRedisClient)client));
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".asyncCommands", m.asyncCommands((AbstractRedisClient)client));
            this.autoConfigureBeans.getCustomContainer().put(cacheAreaWithPrefix + ".reactiveCommands", m.reactiveCommands((AbstractRedisClient)client));
            return externalCacheBuilder;
        }
    }

    public static class RedisLettuceCondition
    extends JetCacheCondition {
        public RedisLettuceCondition() {
            super("redis.lettuce");
        }
    }
}

