/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.external;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.embedded.LinkedHashMapCacheBuilder;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.external.ExternalCacheConfig;
import com.alicp.jetcache.external.MockRemoteCacheConfig;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MockRemoteCache<K, V>
extends AbstractExternalCache<K, V> {
    private Cache<ByteBuffer, byte[]> cache;
    private ExternalCacheConfig<K, V> config;
    private static Method getHolder;

    public MockRemoteCache(MockRemoteCacheConfig<K, V> config) {
        super(config);
        this.config = config;
        this.cache = ((LinkedHashMapCacheBuilder.LinkedHashMapCacheBuilderImpl)((LinkedHashMapCacheBuilder.LinkedHashMapCacheBuilderImpl)LinkedHashMapCacheBuilder.createLinkedHashMapCacheBuilder().limit(config.getLimit())).expireAfterWrite(config.getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS)).buildCache();
    }

    @Override
    public CacheConfig<K, V> config() {
        return this.config;
    }

    private ByteBuffer genKey(K key) {
        return ByteBuffer.wrap(this.buildKey(key));
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return this.cache.unwrap(clazz);
    }

    private CacheGetResult convertCacheGetResult(CacheGetResult originResult) {
        try {
            CacheValueHolder originHolder = (CacheValueHolder)getHolder.invoke((Object)originResult, new Object[0]);
            LinkedList list = new LinkedList();
            while (originHolder != null) {
                CacheValueHolder<Object> h = new CacheValueHolder<Object>();
                if (list.size() > 0) {
                    ((CacheValueHolder)list.getLast()).setValue(h);
                }
                list.add(h);
                h.setAccessTime(originHolder.getAccessTime());
                h.setExpireTime(originHolder.getExpireTime());
                Object v = originHolder.getValue();
                if (v != null && !(v instanceof CacheValueHolder)) {
                    h.setValue(this.config.getValueDecoder().apply((byte[])v));
                    break;
                }
                if (originHolder.getValue() != null) continue;
                originHolder = (CacheValueHolder)originHolder.getValue();
            }
            return new CacheGetResult(originResult.getResultCode(), originResult.getMessage(), (CacheValueHolder)list.peekFirst());
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public CacheValueHolder getHolder(K key) {
        try {
            CacheGetResult r = this.GET(key);
            return (CacheValueHolder)getHolder.invoke(r, new Object[0]);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    protected CacheGetResult<V> do_GET(K key) {
        if (key == null) {
            return new CacheGetResult(CacheResultCode.FAIL, "illegal argument", null);
        }
        CacheGetResult r = this.cache.GET(this.genKey(key));
        if (r.isSuccess()) {
            r = this.convertCacheGetResult(r);
        }
        return r;
    }

    @Override
    protected MultiGetResult<K, V> do_GET_ALL(Set<? extends K> keys) {
        if (keys == null) {
            return new MultiGetResult(CacheResultCode.FAIL, "illegal argument", null);
        }
        ArrayList keyList = new ArrayList(keys.size());
        ArrayList newKeyList = new ArrayList(keys.size());
        keys.stream().forEach(k -> {
            ByteBuffer newKey = this.genKey(k);
            keyList.add(k);
            newKeyList.add(newKey);
        });
        MultiGetResult<ByteBuffer, Object> result = this.cache.GET_ALL(new HashSet(newKeyList));
        Map<ByteBuffer, CacheGetResult<byte[]>> resultMap = result.getValues();
        if (resultMap != null) {
            HashMap returnMap = new HashMap();
            for (int i = 0; i < keyList.size(); ++i) {
                Object key = keyList.get(i);
                ByteBuffer newKey = (ByteBuffer)newKeyList.get(i);
                CacheGetResult r = resultMap.get(newKey);
                if (r.getValue() != null) {
                    r = this.convertCacheGetResult(r);
                }
                returnMap.put(key, r);
            }
            result = new MultiGetResult(result.getResultCode(), null, returnMap);
        }
        return result;
    }

    @Override
    protected CacheResult do_PUT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        return this.cache.PUT(this.genKey(key), this.config.getValueEncoder().apply(value), expireAfterWrite, timeUnit);
    }

    @Override
    protected CacheResult do_PUT_ALL(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        if (map == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        HashMap newMap = new HashMap();
        map.entrySet().forEach(e -> newMap.put(this.genKey(e.getKey()), this.config.getValueEncoder().apply(e.getValue())));
        return this.cache.PUT_ALL(newMap, expireAfterWrite, timeUnit);
    }

    @Override
    protected CacheResult do_REMOVE(K key) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        return this.cache.REMOVE(this.genKey(key));
    }

    @Override
    protected CacheResult do_REMOVE_ALL(Set<? extends K> keys) {
        if (keys == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        return this.cache.REMOVE_ALL(keys.stream().map(k -> this.genKey(k)).collect(Collectors.toSet()));
    }

    @Override
    protected CacheResult do_PUT_IF_ABSENT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        return this.cache.PUT_IF_ABSENT(this.genKey(key), this.config.getValueEncoder().apply(value), expireAfterWrite, timeUnit);
    }

    static {
        try {
            getHolder = CacheGetResult.class.getDeclaredMethod("getHolder", new Class[0]);
            getHolder.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new CacheException(e);
        }
    }
}

