/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheMonitor;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.event.CacheGetAllEvent;
import com.alicp.jetcache.event.CacheGetEvent;
import com.alicp.jetcache.event.CacheLoadAllEvent;
import com.alicp.jetcache.event.CacheLoadEvent;
import com.alicp.jetcache.event.CachePutAllEvent;
import com.alicp.jetcache.event.CachePutEvent;
import com.alicp.jetcache.event.CacheRemoveAllEvent;
import com.alicp.jetcache.event.CacheRemoveEvent;
import com.alicp.jetcache.support.CacheStat;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheMonitor
implements CacheMonitor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCacheMonitor.class);
    protected CacheStat cacheStat;
    private String cacheName;

    public DefaultCacheMonitor(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException();
        }
        this.cacheName = cacheName;
        this.resetStat();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void resetStat() {
        this.cacheStat = new CacheStat();
        this.cacheStat.setStatStartTime(System.currentTimeMillis());
        this.cacheStat.setCacheName(this.cacheName);
    }

    public synchronized CacheStat getCacheStat() {
        CacheStat stat = this.cacheStat.clone();
        stat.setStatEndTime(System.currentTimeMillis());
        return stat;
    }

    @Override
    public synchronized void afterOperation(CacheEvent event) {
        if (event instanceof CacheGetEvent) {
            CacheGetEvent e = (CacheGetEvent)event;
            this.afterGet(e.getMillis(), e.getKey(), e.getResult());
        } else if (event instanceof CachePutEvent) {
            CachePutEvent e = (CachePutEvent)event;
            this.afterPut(e.getMillis(), e.getKey(), e.getValue(), e.getResult());
        } else if (event instanceof CacheRemoveEvent) {
            CacheRemoveEvent e = (CacheRemoveEvent)event;
            this.afterRemove(e.getMillis(), e.getKey(), e.getResult());
        } else if (event instanceof CacheLoadEvent) {
            CacheLoadEvent e = (CacheLoadEvent)event;
            this.afterLoad(e.getMillis(), e.getKey(), e.getLoadedValue(), e.isSuccess());
        } else if (event instanceof CacheGetAllEvent) {
            CacheGetAllEvent e = (CacheGetAllEvent)event;
            this.afterGetAll(e.getMillis(), e.getKeys(), e.getResult());
        } else if (event instanceof CacheLoadAllEvent) {
            CacheLoadAllEvent e = (CacheLoadAllEvent)event;
            this.afterLoadAll(e.getMillis(), e.getKeys(), e.getLoadedValue(), e.isSuccess());
        } else if (event instanceof CachePutAllEvent) {
            CachePutAllEvent e = (CachePutAllEvent)event;
            this.afterPutAll(e.getMillis(), e.getMap(), e.getResult());
        } else if (event instanceof CacheRemoveAllEvent) {
            CacheRemoveAllEvent e = (CacheRemoveAllEvent)event;
            this.afterRemoveAll(e.getMillis(), e.getKeys(), e.getResult());
        }
    }

    private void afterGet(long millis, Object key, CacheGetResult result) {
        this.cacheStat.minGetTime = Math.min(this.cacheStat.minGetTime, millis);
        this.cacheStat.maxGetTime = Math.max(this.cacheStat.maxGetTime, millis);
        this.cacheStat.getTimeSum += millis;
        ++this.cacheStat.getCount;
        this.parseSingleGet(result);
    }

    private void parseSingleGet(CacheGetResult result) {
        switch (result.getResultCode()) {
            case SUCCESS: {
                ++this.cacheStat.getHitCount;
                break;
            }
            case NOT_EXISTS: {
                ++this.cacheStat.getMissCount;
                break;
            }
            case EXPIRED: {
                ++this.cacheStat.getExpireCount;
                break;
            }
            case FAIL: {
                ++this.cacheStat.getFailCount;
                break;
            }
            default: {
                logger.warn("jetcache get return unexpected code: " + (Object)((Object)result.getResultCode()));
            }
        }
    }

    private void afterPut(long millis, Object key, Object value, CacheResult result) {
        this.cacheStat.minPutTime = Math.min(this.cacheStat.minPutTime, millis);
        this.cacheStat.maxPutTime = Math.max(this.cacheStat.maxPutTime, millis);
        this.cacheStat.putTimeSum += millis;
        ++this.cacheStat.putCount;
        switch (result.getResultCode()) {
            case SUCCESS: {
                ++this.cacheStat.putSuccessCount;
                break;
            }
            case FAIL: 
            case PART_SUCCESS: {
                ++this.cacheStat.putFailCount;
                break;
            }
            case EXISTS: {
                break;
            }
            default: {
                logger.warn("jetcache PUT return unexpected code: " + (Object)((Object)result.getResultCode()));
            }
        }
    }

    private void afterRemove(long millis, Object key, CacheResult result) {
        this.cacheStat.minRemoveTime = Math.min(this.cacheStat.minRemoveTime, millis);
        this.cacheStat.maxRemoveTime = Math.max(this.cacheStat.maxRemoveTime, millis);
        this.cacheStat.removeTimeSum += millis;
        ++this.cacheStat.removeCount;
        switch (result.getResultCode()) {
            case SUCCESS: 
            case NOT_EXISTS: {
                ++this.cacheStat.removeSuccessCount;
                break;
            }
            case FAIL: 
            case PART_SUCCESS: {
                ++this.cacheStat.removeFailCount;
                break;
            }
            default: {
                logger.warn("jetcache REMOVE return unexpected code: " + (Object)((Object)result.getResultCode()));
            }
        }
    }

    private void afterLoad(long millis, Object key, Object loadedValue, boolean success) {
        this.cacheStat.minLoadTime = Math.min(this.cacheStat.minLoadTime, millis);
        this.cacheStat.maxLoadTime = Math.max(this.cacheStat.maxLoadTime, millis);
        this.cacheStat.loadTimeSum += millis;
        ++this.cacheStat.loadCount;
        if (success) {
            ++this.cacheStat.loadSuccessCount;
        } else {
            ++this.cacheStat.loadFailCount;
        }
    }

    private void afterLoadAll(long millis, Set keys, Map loadedValue, boolean success) {
        if (keys == null) {
            return;
        }
        int count = keys.size();
        this.cacheStat.minLoadTime = Math.min(this.cacheStat.minLoadTime, millis);
        this.cacheStat.maxLoadTime = Math.max(this.cacheStat.maxLoadTime, millis);
        this.cacheStat.loadTimeSum += millis;
        this.cacheStat.loadCount += (long)count;
        if (success) {
            this.cacheStat.loadSuccessCount += (long)count;
        } else {
            this.cacheStat.loadFailCount += (long)count;
        }
    }

    private void afterGetAll(long millis, Set keys, MultiGetResult result) {
        if (keys == null) {
            return;
        }
        int keyCount = keys.size();
        this.cacheStat.minGetTime = Math.min(this.cacheStat.minGetTime, millis);
        this.cacheStat.maxGetTime = Math.max(this.cacheStat.maxGetTime, millis);
        this.cacheStat.getTimeSum += millis;
        this.cacheStat.getCount += (long)keyCount;
        Map resultValues = result.getValues();
        if (resultValues == null) {
            this.cacheStat.getFailCount += (long)keyCount;
        } else {
            Iterator iterator = resultValues.values().iterator();
            while (iterator.hasNext()) {
                CacheGetResult singleResult;
                CacheGetResult r = singleResult = iterator.next();
                this.parseSingleGet(r);
            }
        }
    }

    private void afterRemoveAll(long millis, Set keys, CacheResult result) {
        if (keys == null) {
            return;
        }
        int keyCount = keys.size();
        this.cacheStat.minRemoveTime = Math.min(this.cacheStat.minRemoveTime, millis);
        this.cacheStat.maxRemoveTime = Math.max(this.cacheStat.maxRemoveTime, millis);
        this.cacheStat.removeTimeSum += millis;
        this.cacheStat.removeCount += (long)keyCount;
        if (result.isSuccess()) {
            this.cacheStat.removeSuccessCount += (long)keyCount;
        } else {
            this.cacheStat.removeFailCount += (long)keyCount;
        }
    }

    private void afterPutAll(long millis, Map map, CacheResult result) {
        if (map == null) {
            return;
        }
        int keyCount = map.size();
        this.cacheStat.minPutTime = Math.min(this.cacheStat.minPutTime, millis);
        this.cacheStat.maxPutTime = Math.max(this.cacheStat.maxPutTime, millis);
        this.cacheStat.putTimeSum += millis;
        this.cacheStat.putCount += (long)keyCount;
        if (result.isSuccess()) {
            this.cacheStat.putSuccessCount += (long)keyCount;
        } else {
            this.cacheStat.putFailCount += (long)keyCount;
        }
    }
}

