/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.sample.Queue;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.client.TransactionChecker;
import com.aliyun.mns.client.TransactionOperations;
import com.aliyun.mns.client.TransactionQueue;
import com.aliyun.mns.common.utils.ServiceSettings;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.QueueMeta;

public class TransactionMessageDemo {
    public static void main(String[] args) {
        System.out.println("Start TransactionMessageDemo");
        String transQueueName = "transQueueName";
        String accessKeyId = ServiceSettings.getMNSAccessKeyId();
        String accessKeySecret = ServiceSettings.getMNSAccessKeySecret();
        String endpoint = ServiceSettings.getMNSAccountEndpoint();
        CloudAccount account = new CloudAccount(accessKeyId, accessKeySecret, endpoint);
        MNSClient client = account.getMNSClient();
        QueueMeta queueMeta = new QueueMeta();
        queueMeta.setQueueName(transQueueName);
        queueMeta.setPollingWaitSeconds(15);
        TransactionMessageDemo demo = new TransactionMessageDemo();
        MyTransactionChecker transChecker = demo.new MyTransactionChecker();
        MyTransactionOperations transOperations = demo.new MyTransactionOperations();
        TransactionQueue transQueue = client.createTransQueue(queueMeta, transChecker);
        Message msg = new Message();
        String messageBody = "TransactionMessageDemo";
        msg.setMessageBody(messageBody);
        transQueue.sendTransMessage(msg, transOperations);
        transQueue.delete();
        client.close();
        System.out.println("End TransactionMessageDemo");
    }

    public class MyTransactionOperations
    implements TransactionOperations {
        @Override
        public boolean doTransaction(Message message) {
            boolean transactionResult = false;
            String messageHandler = message.getReceiptHandle();
            String messageBody = message.getMessageBody();
            try {
                transactionResult = true;
            }
            catch (Exception e) {
                transactionResult = false;
            }
            return transactionResult;
        }
    }

    public class MyTransactionChecker
    implements TransactionChecker {
        @Override
        public boolean checkTransactionStatus(Message message) {
            boolean checkResult = false;
            String messageHandler = message.getReceiptHandle();
            try {
                checkResult = true;
            }
            catch (Exception e) {
                checkResult = false;
            }
            return checkResult;
        }
    }
}

