/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.jdbc.OdpsResultSet;
import com.aliyun.odps.jdbc.OdpsResultSetMetaData;
import com.aliyun.odps.jdbc.OdpsStatement;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OdpsForwardResultSet
extends OdpsResultSet
implements ResultSet {
    private TableTunnel.DownloadSession sessionHandle;
    private TunnelRecordReader reader = null;
    private Record reuseRecord = null;
    private Object[] currentRow;
    private long fetchedRows = 0L;
    private final long totalRows;
    private boolean isClosed = false;
    private long startTime;
    private static final long ACCUM_FETCHED_ROWS = 10000L;
    long accumTime;
    long accumKBytes = 0L;
    private static final int READER_REOPEN_TIME_MAX = 5;

    OdpsForwardResultSet(OdpsStatement stmt, OdpsResultSetMetaData meta, TableTunnel.DownloadSession session) throws SQLException {
        super(stmt.getConnection(), stmt, meta);
        this.sessionHandle = session;
        int maxRows = stmt.resultSetMaxRows;
        long recordCount = this.sessionHandle.getRecordCount();
        this.totalRows = maxRows > 0 && (long)maxRows <= recordCount ? (long)maxRows : recordCount;
        this.startTime = System.currentTimeMillis();
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("The result set has been closed");
        }
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        return (int)this.fetchedRows;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.sessionHandle = null;
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.conn.log.fine("the result set has been closed");
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.fetchedRows == this.totalRows) {
            long end = System.currentTimeMillis();
            this.conn.log.fine("It took me " + (end - this.startTime) + " ms to fetch all records");
            this.close();
            return false;
        }
        int retry = 0;
        while (true) {
            try {
                if (this.reader == null) {
                    this.rebuildReader();
                    this.accumTime = System.currentTimeMillis();
                }
                this.reuseRecord = this.reader.read(this.reuseRecord);
                int columns = this.reuseRecord.getColumnCount();
                this.currentRow = new Object[columns];
                for (int i = 0; i < columns; ++i) {
                    this.currentRow[i] = this.reuseRecord.get(i);
                }
                ++this.fetchedRows;
                if (this.fetchedRows % 10000L == 0L && this.fetchedRows != 0L) {
                    long delta = this.reader.getTotalBytes() / 1024L - this.accumKBytes;
                    long duration = System.currentTimeMillis() - this.accumTime;
                    this.conn.log.fine(String.format("fetched %d rows, %d KB, %.2f KB/s", 10000L, delta, Float.valueOf((float)delta / (float)duration * 1000.0f)));
                    this.accumKBytes = this.reader.getTotalBytes() / 1024L;
                    this.accumTime = System.currentTimeMillis();
                }
                return true;
            }
            catch (IOException e) {
                this.conn.log.info("read from a bad file, retry=" + retry);
                if (++retry == 5) {
                    throw new SQLException("to much retries because: " + e.getMessage());
                }
                this.rebuildReader();
                continue;
            }
            break;
        }
    }

    private void rebuildReader() throws SQLException {
        try {
            long count = this.totalRows - this.fetchedRows;
            this.reader = this.sessionHandle.openRecordReader(this.fetchedRows, count, true);
            this.conn.log.fine(String.format("open read record, start=%d, cnt=%d", this.fetchedRows, count));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        catch (TunnelException e) {
            throw new SQLException(e);
        }
    }

    @Override
    protected Object[] rowAtCursor() throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException("the row should be not-null, row=" + this.fetchedRows);
        }
        if (this.currentRow.length == 0) {
            throw new SQLException("the row should have more than 1 column , row=" + this.fetchedRows);
        }
        return this.currentRow;
    }
}

