/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils;

import com.aliyun.odps.OdpsType;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;

public class JdbcColumn {
    public static final String ODPS_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final int ODPS_DECIMAL_PRECISON = 54;
    public static final int ODPS_DECIMAL_SCALE = 18;
    public static final int ODPS_STRING_CHARACTERS = 0x2AAAAA;
    private final String columnName;
    private final String tableName;
    private final String tableSchema;
    private final OdpsType type;
    private final String comment;
    private final int ordinalPos;

    public JdbcColumn(String columnName, String tableName, String tableSchema, OdpsType type, String comment, int ordinalPos) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.tableSchema = tableSchema;
        this.type = type;
        this.comment = comment;
        this.ordinalPos = ordinalPos;
    }

    public static int OdpsTypeToSqlType(OdpsType type) throws SQLException {
        switch (type) {
            case BIGINT: {
                return -5;
            }
            case BOOLEAN: {
                return 16;
            }
            case DOUBLE: {
                return 8;
            }
            case STRING: {
                return 12;
            }
            case DATETIME: {
                return 93;
            }
            case DECIMAL: {
                return 3;
            }
        }
        throw new SQLException("unknown OdpsType");
    }

    public static String columnClassName(OdpsType type) throws SQLException {
        switch (type) {
            case BIGINT: {
                return Long.class.getName();
            }
            case BOOLEAN: {
                return Boolean.class.getName();
            }
            case DOUBLE: {
                return Double.class.getName();
            }
            case STRING: {
                return String.class.getName();
            }
            case DATETIME: {
                return Timestamp.class.getName();
            }
            case DECIMAL: {
                return BigDecimal.class.getName();
            }
        }
        throw new SQLException("unknown OdpsType");
    }

    public static int columnDisplaySize(OdpsType type) throws SQLException {
        switch (type) {
            case BIGINT: {
                return JdbcColumn.columnPrecision(type) + 1;
            }
            case DOUBLE: {
                return 2 + JdbcColumn.columnPrecision(type) + 2 + 4;
            }
            case DECIMAL: {
                return JdbcColumn.columnPrecision(type) + 2;
            }
            case BOOLEAN: 
            case STRING: 
            case DATETIME: {
                return JdbcColumn.columnPrecision(type);
            }
        }
        throw new SQLException("unknown OdpsType");
    }

    public static int columnPrecision(OdpsType type) throws SQLException {
        switch (type) {
            case BIGINT: {
                return 19;
            }
            case BOOLEAN: {
                return 1;
            }
            case DOUBLE: {
                return 15;
            }
            case STRING: {
                return 0x2AAAAA;
            }
            case DATETIME: {
                return ODPS_DATETIME_FORMAT.length();
            }
            case DECIMAL: {
                return 54;
            }
        }
        throw new SQLException("unknown OdpsType");
    }

    public static int columnScale(OdpsType type) throws SQLException {
        switch (type) {
            case DOUBLE: {
                return JdbcColumn.columnPrecision(type);
            }
            case DECIMAL: {
                return 18;
            }
            case BIGINT: 
            case BOOLEAN: 
            case STRING: 
            case DATETIME: {
                return 0;
            }
        }
        throw new SQLException("unknown OdpsType");
    }

    public static boolean columnCaseSensitive(OdpsType type) throws SQLException {
        switch (type) {
            case BIGINT: 
            case BOOLEAN: 
            case DOUBLE: 
            case DATETIME: 
            case DECIMAL: {
                return false;
            }
            case STRING: {
                return true;
            }
        }
        throw new SQLException("unknown OdpsType");
    }

    public static boolean columnSigned(OdpsType type) throws SQLException {
        switch (type) {
            case BIGINT: 
            case DOUBLE: 
            case DECIMAL: {
                return true;
            }
            case BOOLEAN: 
            case STRING: 
            case DATETIME: {
                return false;
            }
        }
        throw new SQLException("unknown OdpsType");
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public int getType() throws SQLException {
        return JdbcColumn.OdpsTypeToSqlType(this.type);
    }

    public String getComment() {
        return this.comment;
    }

    public String getTypeName() {
        return OdpsType.getFullTypeString((OdpsType)this.type, null);
    }

    public int getOrdinalPos() {
        return this.ordinalPos;
    }

    public int getNumPercRaidx() {
        return 10;
    }

    public int getIsNullable() {
        return 1;
    }

    public String getIsNullableString() {
        switch (this.getIsNullable()) {
            case 0: {
                return "NO";
            }
            case 1: {
                return "YES";
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    public int getDecimalDigits() {
        return 0;
    }
}

