/*
 * Copyright 2011-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not
 * use this file except in compliance with the License. A copy of the License is
 * located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;

/**
 * <p>
 * Contains the output of DescribeVpcEndpoints.
 * </p>
 */
public class DescribeVpcEndpointsResult implements Serializable, Cloneable {

    /**
     * <p>
     * Information about the endpoints.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<VpcEndpoint> vpcEndpoints;
    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no
     * additional items to return, the string is empty.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * Information about the endpoints.
     * </p>
     * 
     * @return Information about the endpoints.
     */

    public java.util.List<VpcEndpoint> getVpcEndpoints() {
        if (vpcEndpoints == null) {
            vpcEndpoints = new com.amazonaws.internal.SdkInternalList<VpcEndpoint>();
        }
        return vpcEndpoints;
    }

    /**
     * <p>
     * Information about the endpoints.
     * </p>
     * 
     * @param vpcEndpoints
     *        Information about the endpoints.
     */

    public void setVpcEndpoints(java.util.Collection<VpcEndpoint> vpcEndpoints) {
        if (vpcEndpoints == null) {
            this.vpcEndpoints = null;
            return;
        }

        this.vpcEndpoints = new com.amazonaws.internal.SdkInternalList<VpcEndpoint>(
                vpcEndpoints);
    }

    /**
     * <p>
     * Information about the endpoints.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if
     * any). Use {@link #setVpcEndpoints(java.util.Collection)} or
     * {@link #withVpcEndpoints(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param vpcEndpoints
     *        Information about the endpoints.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeVpcEndpointsResult withVpcEndpoints(
            VpcEndpoint... vpcEndpoints) {
        if (this.vpcEndpoints == null) {
            setVpcEndpoints(new com.amazonaws.internal.SdkInternalList<VpcEndpoint>(
                    vpcEndpoints.length));
        }
        for (VpcEndpoint ele : vpcEndpoints) {
            this.vpcEndpoints.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Information about the endpoints.
     * </p>
     * 
     * @param vpcEndpoints
     *        Information about the endpoints.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeVpcEndpointsResult withVpcEndpoints(
            java.util.Collection<VpcEndpoint> vpcEndpoints) {
        setVpcEndpoints(vpcEndpoints);
        return this;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no
     * additional items to return, the string is empty.
     * </p>
     * 
     * @param nextToken
     *        The token to use when requesting the next set of items. If there
     *        are no additional items to return, the string is empty.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no
     * additional items to return, the string is empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there
     *         are no additional items to return, the string is empty.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no
     * additional items to return, the string is empty.
     * </p>
     * 
     * @param nextToken
     *        The token to use when requesting the next set of items. If there
     *        are no additional items to return, the string is empty.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeVpcEndpointsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getVpcEndpoints() != null)
            sb.append("VpcEndpoints: " + getVpcEndpoints() + ",");
        if (getNextToken() != null)
            sb.append("NextToken: " + getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeVpcEndpointsResult == false)
            return false;
        DescribeVpcEndpointsResult other = (DescribeVpcEndpointsResult) obj;
        if (other.getVpcEndpoints() == null ^ this.getVpcEndpoints() == null)
            return false;
        if (other.getVpcEndpoints() != null
                && other.getVpcEndpoints().equals(this.getVpcEndpoints()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null
                && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime
                * hashCode
                + ((getVpcEndpoints() == null) ? 0 : getVpcEndpoints()
                        .hashCode());
        hashCode = prime * hashCode
                + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public DescribeVpcEndpointsResult clone() {
        try {
            return (DescribeVpcEndpointsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException(
                    "Got a CloneNotSupportedException from Object.clone() "
                            + "even though we're Cloneable!", e);
        }
    }
}
