/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticache.AmazonElastiCacheAsync;
import com.amazonaws.services.elasticache.AmazonElastiCacheClient;
import com.amazonaws.services.elasticache.model.AddTagsToResourceRequest;
import com.amazonaws.services.elasticache.model.AddTagsToResourceResult;
import com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest;
import com.amazonaws.services.elasticache.model.CacheCluster;
import com.amazonaws.services.elasticache.model.CacheParameterGroup;
import com.amazonaws.services.elasticache.model.CacheSecurityGroup;
import com.amazonaws.services.elasticache.model.CacheSubnetGroup;
import com.amazonaws.services.elasticache.model.CopySnapshotRequest;
import com.amazonaws.services.elasticache.model.CreateCacheClusterRequest;
import com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest;
import com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest;
import com.amazonaws.services.elasticache.model.CreateSnapshotRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupResult;
import com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupResult;
import com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteSnapshotRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersResult;
import com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsResult;
import com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersResult;
import com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import com.amazonaws.services.elasticache.model.DescribeEventsRequest;
import com.amazonaws.services.elasticache.model.DescribeEventsResult;
import com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeReplicationGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsResult;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesResult;
import com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest;
import com.amazonaws.services.elasticache.model.DescribeSnapshotsResult;
import com.amazonaws.services.elasticache.model.EngineDefaults;
import com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsRequest;
import com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsResult;
import com.amazonaws.services.elasticache.model.ListTagsForResourceRequest;
import com.amazonaws.services.elasticache.model.ListTagsForResourceResult;
import com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest;
import com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest;
import com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest;
import com.amazonaws.services.elasticache.model.RebootCacheClusterRequest;
import com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest;
import com.amazonaws.services.elasticache.model.RemoveTagsFromResourceResult;
import com.amazonaws.services.elasticache.model.ReplicationGroup;
import com.amazonaws.services.elasticache.model.ReservedCacheNode;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest;
import com.amazonaws.services.elasticache.model.Snapshot;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonElastiCacheAsyncClient
extends AmazonElastiCacheClient
implements AmazonElastiCacheAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonElastiCacheAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonElastiCacheAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonElastiCacheAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(AddTagsToResourceRequest request) {
        return this.addTagsToResourceAsync(request, null);
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(final AddTagsToResourceRequest request, final AsyncHandler<AddTagsToResourceRequest, AddTagsToResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddTagsToResourceResult>(){

            @Override
            public AddTagsToResourceResult call() throws Exception {
                AddTagsToResourceResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.addTagsToResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> authorizeCacheSecurityGroupIngressAsync(AuthorizeCacheSecurityGroupIngressRequest request) {
        return this.authorizeCacheSecurityGroupIngressAsync(request, null);
    }

    @Override
    public Future<CacheSecurityGroup> authorizeCacheSecurityGroupIngressAsync(final AuthorizeCacheSecurityGroupIngressRequest request, final AsyncHandler<AuthorizeCacheSecurityGroupIngressRequest, CacheSecurityGroup> asyncHandler) {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                CacheSecurityGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.authorizeCacheSecurityGroupIngress(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> copySnapshotAsync(CopySnapshotRequest request) {
        return this.copySnapshotAsync(request, null);
    }

    @Override
    public Future<Snapshot> copySnapshotAsync(final CopySnapshotRequest request, final AsyncHandler<CopySnapshotRequest, Snapshot> asyncHandler) {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.copySnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> createCacheClusterAsync(CreateCacheClusterRequest request) {
        return this.createCacheClusterAsync(request, null);
    }

    @Override
    public Future<CacheCluster> createCacheClusterAsync(final CreateCacheClusterRequest request, final AsyncHandler<CreateCacheClusterRequest, CacheCluster> asyncHandler) {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createCacheCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheParameterGroup> createCacheParameterGroupAsync(CreateCacheParameterGroupRequest request) {
        return this.createCacheParameterGroupAsync(request, null);
    }

    @Override
    public Future<CacheParameterGroup> createCacheParameterGroupAsync(final CreateCacheParameterGroupRequest request, final AsyncHandler<CreateCacheParameterGroupRequest, CacheParameterGroup> asyncHandler) {
        return this.executorService.submit(new Callable<CacheParameterGroup>(){

            @Override
            public CacheParameterGroup call() throws Exception {
                CacheParameterGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createCacheParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> createCacheSecurityGroupAsync(CreateCacheSecurityGroupRequest request) {
        return this.createCacheSecurityGroupAsync(request, null);
    }

    @Override
    public Future<CacheSecurityGroup> createCacheSecurityGroupAsync(final CreateCacheSecurityGroupRequest request, final AsyncHandler<CreateCacheSecurityGroupRequest, CacheSecurityGroup> asyncHandler) {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                CacheSecurityGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createCacheSecurityGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheSubnetGroup> createCacheSubnetGroupAsync(CreateCacheSubnetGroupRequest request) {
        return this.createCacheSubnetGroupAsync(request, null);
    }

    @Override
    public Future<CacheSubnetGroup> createCacheSubnetGroupAsync(final CreateCacheSubnetGroupRequest request, final AsyncHandler<CreateCacheSubnetGroupRequest, CacheSubnetGroup> asyncHandler) {
        return this.executorService.submit(new Callable<CacheSubnetGroup>(){

            @Override
            public CacheSubnetGroup call() throws Exception {
                CacheSubnetGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createCacheSubnetGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReplicationGroup> createReplicationGroupAsync(CreateReplicationGroupRequest request) {
        return this.createReplicationGroupAsync(request, null);
    }

    @Override
    public Future<ReplicationGroup> createReplicationGroupAsync(final CreateReplicationGroupRequest request, final AsyncHandler<CreateReplicationGroupRequest, ReplicationGroup> asyncHandler) {
        return this.executorService.submit(new Callable<ReplicationGroup>(){

            @Override
            public ReplicationGroup call() throws Exception {
                ReplicationGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createReplicationGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> createSnapshotAsync(CreateSnapshotRequest request) {
        return this.createSnapshotAsync(request, null);
    }

    @Override
    public Future<Snapshot> createSnapshotAsync(final CreateSnapshotRequest request, final AsyncHandler<CreateSnapshotRequest, Snapshot> asyncHandler) {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.createSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> deleteCacheClusterAsync(DeleteCacheClusterRequest request) {
        return this.deleteCacheClusterAsync(request, null);
    }

    @Override
    public Future<CacheCluster> deleteCacheClusterAsync(final DeleteCacheClusterRequest request, final AsyncHandler<DeleteCacheClusterRequest, CacheCluster> asyncHandler) {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.deleteCacheCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCacheParameterGroupResult> deleteCacheParameterGroupAsync(DeleteCacheParameterGroupRequest request) {
        return this.deleteCacheParameterGroupAsync(request, null);
    }

    @Override
    public Future<DeleteCacheParameterGroupResult> deleteCacheParameterGroupAsync(final DeleteCacheParameterGroupRequest request, final AsyncHandler<DeleteCacheParameterGroupRequest, DeleteCacheParameterGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteCacheParameterGroupResult>(){

            @Override
            public DeleteCacheParameterGroupResult call() throws Exception {
                DeleteCacheParameterGroupResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.deleteCacheParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCacheSecurityGroupResult> deleteCacheSecurityGroupAsync(DeleteCacheSecurityGroupRequest request) {
        return this.deleteCacheSecurityGroupAsync(request, null);
    }

    @Override
    public Future<DeleteCacheSecurityGroupResult> deleteCacheSecurityGroupAsync(final DeleteCacheSecurityGroupRequest request, final AsyncHandler<DeleteCacheSecurityGroupRequest, DeleteCacheSecurityGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteCacheSecurityGroupResult>(){

            @Override
            public DeleteCacheSecurityGroupResult call() throws Exception {
                DeleteCacheSecurityGroupResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.deleteCacheSecurityGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCacheSubnetGroupResult> deleteCacheSubnetGroupAsync(DeleteCacheSubnetGroupRequest request) {
        return this.deleteCacheSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DeleteCacheSubnetGroupResult> deleteCacheSubnetGroupAsync(final DeleteCacheSubnetGroupRequest request, final AsyncHandler<DeleteCacheSubnetGroupRequest, DeleteCacheSubnetGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteCacheSubnetGroupResult>(){

            @Override
            public DeleteCacheSubnetGroupResult call() throws Exception {
                DeleteCacheSubnetGroupResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.deleteCacheSubnetGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReplicationGroup> deleteReplicationGroupAsync(DeleteReplicationGroupRequest request) {
        return this.deleteReplicationGroupAsync(request, null);
    }

    @Override
    public Future<ReplicationGroup> deleteReplicationGroupAsync(final DeleteReplicationGroupRequest request, final AsyncHandler<DeleteReplicationGroupRequest, ReplicationGroup> asyncHandler) {
        return this.executorService.submit(new Callable<ReplicationGroup>(){

            @Override
            public ReplicationGroup call() throws Exception {
                ReplicationGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.deleteReplicationGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> deleteSnapshotAsync(DeleteSnapshotRequest request) {
        return this.deleteSnapshotAsync(request, null);
    }

    @Override
    public Future<Snapshot> deleteSnapshotAsync(final DeleteSnapshotRequest request, final AsyncHandler<DeleteSnapshotRequest, Snapshot> asyncHandler) {
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.deleteSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync(DescribeCacheClustersRequest request) {
        return this.describeCacheClustersAsync(request, null);
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync(final DescribeCacheClustersRequest request, final AsyncHandler<DescribeCacheClustersRequest, DescribeCacheClustersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCacheClustersResult>(){

            @Override
            public DescribeCacheClustersResult call() throws Exception {
                DescribeCacheClustersResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheClusters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync() {
        return this.describeCacheClustersAsync(new DescribeCacheClustersRequest());
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync(AsyncHandler<DescribeCacheClustersRequest, DescribeCacheClustersResult> asyncHandler) {
        return this.describeCacheClustersAsync(new DescribeCacheClustersRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeCacheEngineVersionsResult> describeCacheEngineVersionsAsync(DescribeCacheEngineVersionsRequest request) {
        return this.describeCacheEngineVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeCacheEngineVersionsResult> describeCacheEngineVersionsAsync(final DescribeCacheEngineVersionsRequest request, final AsyncHandler<DescribeCacheEngineVersionsRequest, DescribeCacheEngineVersionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCacheEngineVersionsResult>(){

            @Override
            public DescribeCacheEngineVersionsResult call() throws Exception {
                DescribeCacheEngineVersionsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheEngineVersions(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheEngineVersionsResult> describeCacheEngineVersionsAsync() {
        return this.describeCacheEngineVersionsAsync(new DescribeCacheEngineVersionsRequest());
    }

    @Override
    public Future<DescribeCacheEngineVersionsResult> describeCacheEngineVersionsAsync(AsyncHandler<DescribeCacheEngineVersionsRequest, DescribeCacheEngineVersionsResult> asyncHandler) {
        return this.describeCacheEngineVersionsAsync(new DescribeCacheEngineVersionsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync(DescribeCacheParameterGroupsRequest request) {
        return this.describeCacheParameterGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync(final DescribeCacheParameterGroupsRequest request, final AsyncHandler<DescribeCacheParameterGroupsRequest, DescribeCacheParameterGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCacheParameterGroupsResult>(){

            @Override
            public DescribeCacheParameterGroupsResult call() throws Exception {
                DescribeCacheParameterGroupsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheParameterGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync() {
        return this.describeCacheParameterGroupsAsync(new DescribeCacheParameterGroupsRequest());
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync(AsyncHandler<DescribeCacheParameterGroupsRequest, DescribeCacheParameterGroupsResult> asyncHandler) {
        return this.describeCacheParameterGroupsAsync(new DescribeCacheParameterGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeCacheParametersResult> describeCacheParametersAsync(DescribeCacheParametersRequest request) {
        return this.describeCacheParametersAsync(request, null);
    }

    @Override
    public Future<DescribeCacheParametersResult> describeCacheParametersAsync(final DescribeCacheParametersRequest request, final AsyncHandler<DescribeCacheParametersRequest, DescribeCacheParametersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCacheParametersResult>(){

            @Override
            public DescribeCacheParametersResult call() throws Exception {
                DescribeCacheParametersResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheParameters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync(DescribeCacheSecurityGroupsRequest request) {
        return this.describeCacheSecurityGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync(final DescribeCacheSecurityGroupsRequest request, final AsyncHandler<DescribeCacheSecurityGroupsRequest, DescribeCacheSecurityGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCacheSecurityGroupsResult>(){

            @Override
            public DescribeCacheSecurityGroupsResult call() throws Exception {
                DescribeCacheSecurityGroupsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheSecurityGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync() {
        return this.describeCacheSecurityGroupsAsync(new DescribeCacheSecurityGroupsRequest());
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync(AsyncHandler<DescribeCacheSecurityGroupsRequest, DescribeCacheSecurityGroupsResult> asyncHandler) {
        return this.describeCacheSecurityGroupsAsync(new DescribeCacheSecurityGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeCacheSubnetGroupsResult> describeCacheSubnetGroupsAsync(DescribeCacheSubnetGroupsRequest request) {
        return this.describeCacheSubnetGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeCacheSubnetGroupsResult> describeCacheSubnetGroupsAsync(final DescribeCacheSubnetGroupsRequest request, final AsyncHandler<DescribeCacheSubnetGroupsRequest, DescribeCacheSubnetGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCacheSubnetGroupsResult>(){

            @Override
            public DescribeCacheSubnetGroupsResult call() throws Exception {
                DescribeCacheSubnetGroupsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeCacheSubnetGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheSubnetGroupsResult> describeCacheSubnetGroupsAsync() {
        return this.describeCacheSubnetGroupsAsync(new DescribeCacheSubnetGroupsRequest());
    }

    @Override
    public Future<DescribeCacheSubnetGroupsResult> describeCacheSubnetGroupsAsync(AsyncHandler<DescribeCacheSubnetGroupsRequest, DescribeCacheSubnetGroupsResult> asyncHandler) {
        return this.describeCacheSubnetGroupsAsync(new DescribeCacheSubnetGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(DescribeEngineDefaultParametersRequest request) {
        return this.describeEngineDefaultParametersAsync(request, null);
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(final DescribeEngineDefaultParametersRequest request, final AsyncHandler<DescribeEngineDefaultParametersRequest, EngineDefaults> asyncHandler) {
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                EngineDefaults result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeEngineDefaultParameters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request) {
        return this.describeEventsAsync(request, null);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest request, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync() {
        return this.describeEventsAsync(new DescribeEventsRequest());
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        return this.describeEventsAsync(new DescribeEventsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeReplicationGroupsResult> describeReplicationGroupsAsync(DescribeReplicationGroupsRequest request) {
        return this.describeReplicationGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeReplicationGroupsResult> describeReplicationGroupsAsync(final DescribeReplicationGroupsRequest request, final AsyncHandler<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeReplicationGroupsResult>(){

            @Override
            public DescribeReplicationGroupsResult call() throws Exception {
                DescribeReplicationGroupsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeReplicationGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReplicationGroupsResult> describeReplicationGroupsAsync() {
        return this.describeReplicationGroupsAsync(new DescribeReplicationGroupsRequest());
    }

    @Override
    public Future<DescribeReplicationGroupsResult> describeReplicationGroupsAsync(AsyncHandler<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResult> asyncHandler) {
        return this.describeReplicationGroupsAsync(new DescribeReplicationGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeReservedCacheNodesResult> describeReservedCacheNodesAsync(DescribeReservedCacheNodesRequest request) {
        return this.describeReservedCacheNodesAsync(request, null);
    }

    @Override
    public Future<DescribeReservedCacheNodesResult> describeReservedCacheNodesAsync(final DescribeReservedCacheNodesRequest request, final AsyncHandler<DescribeReservedCacheNodesRequest, DescribeReservedCacheNodesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeReservedCacheNodesResult>(){

            @Override
            public DescribeReservedCacheNodesResult call() throws Exception {
                DescribeReservedCacheNodesResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeReservedCacheNodes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedCacheNodesResult> describeReservedCacheNodesAsync() {
        return this.describeReservedCacheNodesAsync(new DescribeReservedCacheNodesRequest());
    }

    @Override
    public Future<DescribeReservedCacheNodesResult> describeReservedCacheNodesAsync(AsyncHandler<DescribeReservedCacheNodesRequest, DescribeReservedCacheNodesResult> asyncHandler) {
        return this.describeReservedCacheNodesAsync(new DescribeReservedCacheNodesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeReservedCacheNodesOfferingsResult> describeReservedCacheNodesOfferingsAsync(DescribeReservedCacheNodesOfferingsRequest request) {
        return this.describeReservedCacheNodesOfferingsAsync(request, null);
    }

    @Override
    public Future<DescribeReservedCacheNodesOfferingsResult> describeReservedCacheNodesOfferingsAsync(final DescribeReservedCacheNodesOfferingsRequest request, final AsyncHandler<DescribeReservedCacheNodesOfferingsRequest, DescribeReservedCacheNodesOfferingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeReservedCacheNodesOfferingsResult>(){

            @Override
            public DescribeReservedCacheNodesOfferingsResult call() throws Exception {
                DescribeReservedCacheNodesOfferingsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeReservedCacheNodesOfferings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedCacheNodesOfferingsResult> describeReservedCacheNodesOfferingsAsync() {
        return this.describeReservedCacheNodesOfferingsAsync(new DescribeReservedCacheNodesOfferingsRequest());
    }

    @Override
    public Future<DescribeReservedCacheNodesOfferingsResult> describeReservedCacheNodesOfferingsAsync(AsyncHandler<DescribeReservedCacheNodesOfferingsRequest, DescribeReservedCacheNodesOfferingsResult> asyncHandler) {
        return this.describeReservedCacheNodesOfferingsAsync(new DescribeReservedCacheNodesOfferingsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(DescribeSnapshotsRequest request) {
        return this.describeSnapshotsAsync(request, null);
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(final DescribeSnapshotsRequest request, final AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                DescribeSnapshotsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.describeSnapshots(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync() {
        return this.describeSnapshotsAsync(new DescribeSnapshotsRequest());
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) {
        return this.describeSnapshotsAsync(new DescribeSnapshotsRequest(), asyncHandler);
    }

    @Override
    public Future<ListAllowedNodeTypeModificationsResult> listAllowedNodeTypeModificationsAsync(ListAllowedNodeTypeModificationsRequest request) {
        return this.listAllowedNodeTypeModificationsAsync(request, null);
    }

    @Override
    public Future<ListAllowedNodeTypeModificationsResult> listAllowedNodeTypeModificationsAsync(final ListAllowedNodeTypeModificationsRequest request, final AsyncHandler<ListAllowedNodeTypeModificationsRequest, ListAllowedNodeTypeModificationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAllowedNodeTypeModificationsResult>(){

            @Override
            public ListAllowedNodeTypeModificationsResult call() throws Exception {
                ListAllowedNodeTypeModificationsResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.listAllowedNodeTypeModifications(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAllowedNodeTypeModificationsResult> listAllowedNodeTypeModificationsAsync() {
        return this.listAllowedNodeTypeModificationsAsync(new ListAllowedNodeTypeModificationsRequest());
    }

    @Override
    public Future<ListAllowedNodeTypeModificationsResult> listAllowedNodeTypeModificationsAsync(AsyncHandler<ListAllowedNodeTypeModificationsRequest, ListAllowedNodeTypeModificationsResult> asyncHandler) {
        return this.listAllowedNodeTypeModificationsAsync(new ListAllowedNodeTypeModificationsRequest(), asyncHandler);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.listTagsForResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> modifyCacheClusterAsync(ModifyCacheClusterRequest request) {
        return this.modifyCacheClusterAsync(request, null);
    }

    @Override
    public Future<CacheCluster> modifyCacheClusterAsync(final ModifyCacheClusterRequest request, final AsyncHandler<ModifyCacheClusterRequest, CacheCluster> asyncHandler) {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.modifyCacheCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyCacheParameterGroupResult> modifyCacheParameterGroupAsync(ModifyCacheParameterGroupRequest request) {
        return this.modifyCacheParameterGroupAsync(request, null);
    }

    @Override
    public Future<ModifyCacheParameterGroupResult> modifyCacheParameterGroupAsync(final ModifyCacheParameterGroupRequest request, final AsyncHandler<ModifyCacheParameterGroupRequest, ModifyCacheParameterGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<ModifyCacheParameterGroupResult>(){

            @Override
            public ModifyCacheParameterGroupResult call() throws Exception {
                ModifyCacheParameterGroupResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.modifyCacheParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheSubnetGroup> modifyCacheSubnetGroupAsync(ModifyCacheSubnetGroupRequest request) {
        return this.modifyCacheSubnetGroupAsync(request, null);
    }

    @Override
    public Future<CacheSubnetGroup> modifyCacheSubnetGroupAsync(final ModifyCacheSubnetGroupRequest request, final AsyncHandler<ModifyCacheSubnetGroupRequest, CacheSubnetGroup> asyncHandler) {
        return this.executorService.submit(new Callable<CacheSubnetGroup>(){

            @Override
            public CacheSubnetGroup call() throws Exception {
                CacheSubnetGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.modifyCacheSubnetGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReplicationGroup> modifyReplicationGroupAsync(ModifyReplicationGroupRequest request) {
        return this.modifyReplicationGroupAsync(request, null);
    }

    @Override
    public Future<ReplicationGroup> modifyReplicationGroupAsync(final ModifyReplicationGroupRequest request, final AsyncHandler<ModifyReplicationGroupRequest, ReplicationGroup> asyncHandler) {
        return this.executorService.submit(new Callable<ReplicationGroup>(){

            @Override
            public ReplicationGroup call() throws Exception {
                ReplicationGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.modifyReplicationGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReservedCacheNode> purchaseReservedCacheNodesOfferingAsync(PurchaseReservedCacheNodesOfferingRequest request) {
        return this.purchaseReservedCacheNodesOfferingAsync(request, null);
    }

    @Override
    public Future<ReservedCacheNode> purchaseReservedCacheNodesOfferingAsync(final PurchaseReservedCacheNodesOfferingRequest request, final AsyncHandler<PurchaseReservedCacheNodesOfferingRequest, ReservedCacheNode> asyncHandler) {
        return this.executorService.submit(new Callable<ReservedCacheNode>(){

            @Override
            public ReservedCacheNode call() throws Exception {
                ReservedCacheNode result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.purchaseReservedCacheNodesOffering(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> rebootCacheClusterAsync(RebootCacheClusterRequest request) {
        return this.rebootCacheClusterAsync(request, null);
    }

    @Override
    public Future<CacheCluster> rebootCacheClusterAsync(final RebootCacheClusterRequest request, final AsyncHandler<RebootCacheClusterRequest, CacheCluster> asyncHandler) {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.rebootCacheCluster(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(RemoveTagsFromResourceRequest request) {
        return this.removeTagsFromResourceAsync(request, null);
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(final RemoveTagsFromResourceRequest request, final AsyncHandler<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveTagsFromResourceResult>(){

            @Override
            public RemoveTagsFromResourceResult call() throws Exception {
                RemoveTagsFromResourceResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.removeTagsFromResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResetCacheParameterGroupResult> resetCacheParameterGroupAsync(ResetCacheParameterGroupRequest request) {
        return this.resetCacheParameterGroupAsync(request, null);
    }

    @Override
    public Future<ResetCacheParameterGroupResult> resetCacheParameterGroupAsync(final ResetCacheParameterGroupRequest request, final AsyncHandler<ResetCacheParameterGroupRequest, ResetCacheParameterGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<ResetCacheParameterGroupResult>(){

            @Override
            public ResetCacheParameterGroupResult call() throws Exception {
                ResetCacheParameterGroupResult result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.resetCacheParameterGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> revokeCacheSecurityGroupIngressAsync(RevokeCacheSecurityGroupIngressRequest request) {
        return this.revokeCacheSecurityGroupIngressAsync(request, null);
    }

    @Override
    public Future<CacheSecurityGroup> revokeCacheSecurityGroupIngressAsync(final RevokeCacheSecurityGroupIngressRequest request, final AsyncHandler<RevokeCacheSecurityGroupIngressRequest, CacheSecurityGroup> asyncHandler) {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                CacheSecurityGroup result;
                try {
                    result = AmazonElastiCacheAsyncClient.this.revokeCacheSecurityGroupIngress(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

