/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.RecoveryScan;
import com.atomikos.datasource.xa.SiblingMapper;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XID;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.SysException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public abstract class XATransactionalResource
implements TransactionalResource {
    private static final Logger LOGGER = LoggerFactory.createLogger(XATransactionalResource.class);
    protected XAResource xares_;
    protected String servername;
    protected Hashtable recoveredXidMap;
    protected Hashtable rootTransactionToSiblingMapperMap;
    protected XidFactory xidFact;
    private boolean closed;
    private boolean weakCompare;
    private boolean compareAlwaysTrue;
    private String branchIdentifier;
    private static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);
    private static final int MAX_LONG_LEN = MAX_LONG_STR.getBytes().length;

    public XATransactionalResource(String servername) {
        this.servername = servername;
        this.rootTransactionToSiblingMapperMap = new Hashtable();
        if (servername.getBytes().length > 64 - MAX_LONG_LEN) {
            throw new RuntimeException("Max length of resource name exceeded: should be less than " + (64 - MAX_LONG_LEN));
        }
        this.xidFact = new DefaultXidFactory();
        this.closed = false;
        this.weakCompare = false;
        this.compareAlwaysTrue = false;
    }

    public XATransactionalResource(String servername, XidFactory factory) {
        this(servername);
        this.xidFact = factory;
    }

    protected abstract XAResource refreshXAConnection() throws ResourceException;

    public XidFactory getXidFactory() {
        return this.xidFact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSiblingMap(String root) {
        Hashtable hashtable = this.rootTransactionToSiblingMapperMap;
        synchronized (hashtable) {
            this.rootTransactionToSiblingMapperMap.remove(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SiblingMapper getSiblingMap(String root) {
        Hashtable hashtable = this.rootTransactionToSiblingMapperMap;
        synchronized (hashtable) {
            if (this.rootTransactionToSiblingMapperMap.containsKey(root)) {
                return (SiblingMapper)this.rootTransactionToSiblingMapperMap.get(root);
            }
            SiblingMapper map = new SiblingMapper(this, root);
            this.rootTransactionToSiblingMapperMap.put(root, map);
            return map;
        }
    }

    protected boolean needsRefresh() {
        boolean ret;
        block3: {
            ret = true;
            try {
                if (this.xares_ != null) {
                    this.xares_.isSameRM(this.xares_);
                    ret = false;
                }
            }
            catch (XAException xa) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.logDebug(this.servername + ": XAResource needs refresh?", (Throwable)xa);
            }
        }
        return ret;
    }

    public void useWeakCompare(boolean weakCompare) {
        this.weakCompare = weakCompare;
    }

    public boolean usesWeakCompare() {
        return this.weakCompare;
    }

    public void setAcceptAllXAResources(boolean val) {
        this.compareAlwaysTrue = val;
    }

    public boolean acceptsAllXAResources() {
        return this.compareAlwaysTrue;
    }

    public boolean usesXAResource(XAResource xares) {
        if (this.acceptsAllXAResources()) {
            return true;
        }
        XAResource xaresource = this.getXAResource();
        if (xaresource == null) {
            return false;
        }
        boolean ret = false;
        if (!xares.getClass().getName().equals(xaresource.getClass().getName())) {
            ret = false;
        } else {
            try {
                if (xares.isSameRM(xaresource)) {
                    ret = true;
                } else if (this.usesWeakCompare()) {
                    ret = true;
                } else {
                    LOGGER.logDebug("XAResources claim to be different: " + xares + " and " + xaresource);
                }
            }
            catch (XAException xe) {
                throw new SysException("Error in XAResource comparison: " + xe.getMessage(), (Throwable)xe);
            }
        }
        return ret;
    }

    public synchronized XAResource getXAResource() {
        if (this.needsRefresh()) {
            LOGGER.logDebug(this.servername + ": refreshing XAResource...");
            this.xares_ = this.refreshXAConnection();
            LOGGER.logInfo(this.servername + ": refreshed XAResource");
        }
        return this.xares_;
    }

    public ResourceTransaction getResourceTransaction(CompositeTransaction ct) throws ResourceException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        if (ct == null) {
            return null;
        }
        Stack lineage = ct.getLineage();
        String root = null;
        if (lineage == null || lineage.isEmpty()) {
            root = ct.getTid();
        } else {
            Stack tmp = (Stack)lineage.clone();
            while (!tmp.isEmpty()) {
                CompositeTransaction next = (CompositeTransaction)tmp.pop();
                if (!next.isRoot()) continue;
                root = next.getTid();
            }
        }
        return this.getSiblingMap(root).findOrCreateBranchForTransaction(ct);
    }

    public String getName() {
        return this.servername;
    }

    public void close() throws ResourceException {
        this.closed = true;
    }

    public boolean isClosed() throws ResourceException {
        return this.closed;
    }

    public boolean isSameRM(RecoverableResource res) throws ResourceException {
        if (res == null || !(res instanceof XATransactionalResource)) {
            return false;
        }
        XATransactionalResource xatxres = (XATransactionalResource)res;
        if (xatxres.servername == null || this.servername == null) {
            return false;
        }
        return xatxres.servername.equals(this.servername);
    }

    public void setRecoveryService(RecoveryService recoveryService) throws ResourceException {
        if (recoveryService != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("Installing recovery service on resource " + this.getName());
            }
            this.branchIdentifier = recoveryService.getName();
            recoveryService.recover();
        }
    }

    public synchronized boolean recover(Participant participant) throws ResourceException {
        boolean recovered = true;
        if (this.closed) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        if (!(participant instanceof XAResourceTransaction)) {
            throw new ResourceException("Wrong argument class: " + participant.getClass().getName());
        }
        XAResource xaresource = this.getXAResource();
        if (xaresource == null) {
            LOGGER.logWarning("XATransactionalResource " + this.getName() + ": XAResource is null");
            return false;
        }
        XAResourceTransaction xarestx = (XAResourceTransaction)participant;
        this.recoverXidsFromResourceIfNecessary();
        if (!this.recoveredXidMap.containsKey(xarestx.getXid())) {
            recovered = false;
        }
        if (recovered || this.getName().equals(xarestx.getResourceName())) {
            xarestx.setRecoveredXAResource(this.getXAResource());
            xarestx.setResource(this);
        }
        this.recoveredXidMap.remove(xarestx.getXid());
        return recovered;
    }

    protected void recover() throws ResourceException {
        this.recoveredXidMap = new Hashtable();
        if (this.branchIdentifier == null) {
            LOGGER.logDebug("No recoveryService set yet!");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("recovery initiated for resource " + this.getName() + " with branchIdentifier " + this.branchIdentifier);
        }
        try {
            RecoveryScan.recoverXids(this.getXAResource(), new RecoveryScan.XidSelector(){

                @Override
                public boolean selects(Xid vendorXid) {
                    boolean ret = false;
                    String branch = new String(vendorXid.getBranchQualifier());
                    Xid xid = XATransactionalResource.this.wrapWithOurOwnXidToHaveCorrectEqualsAndHashCode(vendorXid);
                    if (branch.startsWith(XATransactionalResource.this.branchIdentifier)) {
                        ret = true;
                        XATransactionalResource.this.recoveredXidMap.put(xid, new Object());
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.logInfo("Resource " + XATransactionalResource.this.servername + " recovering XID: " + xid);
                        }
                    } else if (LOGGER.isInfoEnabled()) {
                        LOGGER.logInfo("Resource " + XATransactionalResource.this.servername + ": XID " + xid + " with branch " + branch + " is not under my responsibility");
                    }
                    return ret;
                }
            });
        }
        catch (NullPointerException ora) {
            if (this.getXAResource().getClass().getName().toLowerCase().indexOf("oracle") >= 0) {
                LOGGER.logWarning("ORACLE NOT CONFIGURED FOR XA? PLEASE CONTACT YOUR DBA TO FIX THIS...");
            }
            throw ora;
        }
        catch (XAException xaerr) {
            LOGGER.logWarning("Error in recovery", (Throwable)xaerr);
            throw new ResourceException("Error in recovery", (Throwable)xaerr);
        }
    }

    private Xid wrapWithOurOwnXidToHaveCorrectEqualsAndHashCode(Xid xid) {
        return new XID(xid);
    }

    public void endRecovery() throws ResourceException {
        if (this.closed) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        if (this.getXAResource() != null) {
            this.recoverXidsFromResourceIfNecessary();
            this.performPresumedAbortForRemainingXids();
        }
        this.resetForNextRecoveryScan();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("endRecovery() done for resource " + this.getName());
        }
    }

    private void performPresumedAbortForRemainingXids() {
        Enumeration toAbortList = this.recoveredXidMap.keys();
        XAResource xaresource = this.getXAResource();
        while (toAbortList.hasMoreElements()) {
            XID xid = (XID)toAbortList.nextElement();
            try {
                xaresource.rollback(xid);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.logInfo("XAResource.rollback ( " + xid + " ) called " + "on resource " + this.servername);
            }
            catch (XAException xaerr) {}
        }
    }

    private void resetForNextRecoveryScan() {
        this.recoveredXidMap = null;
    }

    private void recoverXidsFromResourceIfNecessary() {
        if (this.recoveredXidMap == null) {
            this.recover();
        }
    }

    public void setXidFactory(XidFactory factory) {
        this.xidFact = factory;
    }

    protected Xid createXid(String tid) {
        if (this.branchIdentifier == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        return this.getXidFactory().createXid(tid, this.branchIdentifier);
    }
}

