/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.util.Context;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusMeter;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusTracer;
import java.util.List;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

class ServiceBusSenderInstrumentation {
    private final ServiceBusMeter meter;
    private final ServiceBusTracer tracer;

    ServiceBusSenderInstrumentation(Tracer tracer, Meter meter, String fullyQualifiedName, String entityPath) {
        this.tracer = new ServiceBusTracer(tracer, fullyQualifiedName, entityPath);
        this.meter = new ServiceBusMeter(meter, fullyQualifiedName, entityPath, null);
    }

    ServiceBusTracer getTracer() {
        return this.tracer;
    }

    <T> Mono<T> instrumentSendBatch(String spanName, Mono<T> publisher, List<ServiceBusMessage> batch) {
        if (!this.tracer.isEnabled() && !this.meter.isBatchSendEnabled()) {
            return publisher;
        }
        if (this.tracer.isEnabled()) {
            return publisher.doOnEach(signal -> {
                Context span = (Context)signal.getContextView().getOrDefault((Object)"otel-context-key", (Object)Context.NONE);
                this.meter.reportBatchSend(batch.size(), signal.getThrowable(), span);
                this.tracer.endSpan(signal.getThrowable(), span, null);
            }).contextWrite((ContextView)reactor.util.context.Context.of((Object)"otel-context-key", (Object)this.tracer.startSpanWithLinks(spanName, batch, ServiceBusMessage::getContext, Context.NONE)));
        }
        return publisher.doOnEach(signal -> this.meter.reportBatchSend(batch.size(), signal.getThrowable(), Context.NONE));
    }
}

