/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.models.AuthorizationRuleImpl;
import com.azure.messaging.servicebus.administration.implementation.models.EntityAvailabilityStatus;
import com.azure.messaging.servicebus.administration.implementation.models.MessageCountDetails;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescription;
import com.azure.messaging.servicebus.administration.models.AuthorizationRule;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.messaging.servicebus.administration.models.SharedAccessAuthorizationRule;
import com.azure.messaging.servicebus.implementation.MessageUtils;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TopicProperties {
    private Duration autoDeleteOnIdle;
    private Duration defaultMessageTimeToLive;
    private Duration duplicateDetectionHistoryTimeWindow;
    private final boolean enableBatchedOperations;
    private boolean enableExpress;
    private Boolean enableSubscriptionPartitioning;
    private final EntityAvailabilityStatus entityAvailabilityStatus;
    private boolean filteringMessagesBeforePublishing;
    private Boolean isAnonymousAccessible;
    private final List<AuthorizationRule> authorizationRules;
    private EntityStatus status;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final OffsetDateTime accessedAt;
    private long maxSizeInMegabytes;
    private long maxMessageSizeInKilobytes;
    private final MessageCountDetails messageCountDetails;
    private boolean requiresDuplicateDetection;
    private final long sizeInBytes;
    private final int subscriptionCount;
    private boolean supportOrdering;
    private final boolean enablePartitioning;
    private String userMetadata;
    private String topicName;

    TopicProperties(TopicDescription topic) {
        Objects.requireNonNull(topic, "'options' cannot be null.");
        this.accessedAt = topic.getAccessedAt();
        this.authorizationRules = topic.getAuthorizationRules().stream().map(SharedAccessAuthorizationRule::new).collect(Collectors.toList());
        this.autoDeleteOnIdle = topic.getAutoDeleteOnIdle();
        this.createdAt = topic.getCreatedAt();
        this.defaultMessageTimeToLive = topic.getDefaultMessageTimeToLive();
        this.duplicateDetectionHistoryTimeWindow = topic.getDuplicateDetectionHistoryTimeWindow();
        this.filteringMessagesBeforePublishing = MessageUtils.toPrimitive(topic.isFilteringMessagesBeforePublishing());
        this.enableBatchedOperations = MessageUtils.toPrimitive(topic.isEnableBatchedOperations());
        this.enableExpress = MessageUtils.toPrimitive(topic.isEnableExpress());
        this.enablePartitioning = MessageUtils.toPrimitive(topic.isEnablePartitioning());
        this.enableSubscriptionPartitioning = topic.isEnableSubscriptionPartitioning();
        this.entityAvailabilityStatus = topic.getEntityAvailabilityStatus();
        this.isAnonymousAccessible = topic.isAnonymousAccessible();
        this.maxSizeInMegabytes = MessageUtils.toPrimitive(topic.getMaxSizeInMegabytes());
        this.maxMessageSizeInKilobytes = MessageUtils.toPrimitive(topic.getMaxMessageSizeInKilobytes());
        this.messageCountDetails = topic.getMessageCountDetails();
        this.requiresDuplicateDetection = MessageUtils.toPrimitive(topic.isRequiresDuplicateDetection());
        this.sizeInBytes = MessageUtils.toPrimitive(topic.getSizeInBytes());
        this.status = topic.getStatus();
        this.subscriptionCount = MessageUtils.toPrimitive(topic.getSubscriptionCount());
        this.supportOrdering = MessageUtils.toPrimitive(topic.isSupportOrdering());
        this.updatedAt = topic.getUpdatedAt();
        this.userMetadata = topic.getUserMetadata();
    }

    public String getName() {
        return this.topicName;
    }

    TopicProperties setName(String topicName) {
        this.topicName = topicName;
        return this;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public TopicProperties setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public long getMaxSizeInMegabytes() {
        return this.maxSizeInMegabytes;
    }

    public TopicProperties setMaxSizeInMegabytes(long maxSizeInMegabytes) {
        this.maxSizeInMegabytes = maxSizeInMegabytes;
        return this;
    }

    public boolean isDuplicateDetectionRequired() {
        return this.requiresDuplicateDetection;
    }

    public TopicProperties setDuplicateDetectionRequired(boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
        return this;
    }

    public Duration getDuplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    public TopicProperties setDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    public boolean isBatchedOperationsEnabled() {
        return this.enableBatchedOperations;
    }

    public List<AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public TopicProperties setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public boolean isOrderingSupported() {
        return this.supportOrdering;
    }

    public TopicProperties setOrderingSupported(boolean supportOrdering) {
        this.supportOrdering = supportOrdering;
        return this;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public TopicProperties setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public boolean isPartitioningEnabled() {
        return this.enablePartitioning;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public TopicProperties setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    long getSizeInBytes() {
        return this.sizeInBytes;
    }

    boolean isFilteringMessagesBeforePublishing() {
        return this.filteringMessagesBeforePublishing;
    }

    TopicProperties setFilteringMessagesBeforePublishing(boolean filteringMessagesBeforePublishing) {
        this.filteringMessagesBeforePublishing = filteringMessagesBeforePublishing;
        return this;
    }

    boolean isAnonymousAccessible() {
        return this.isAnonymousAccessible;
    }

    TopicProperties setIsAnonymousAccessible(boolean isAnonymousAccessible) {
        this.isAnonymousAccessible = isAnonymousAccessible;
        return this;
    }

    OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    MessageCountDetails getMessageCountDetails() {
        return this.messageCountDetails;
    }

    int getSubscriptionCount() {
        return this.subscriptionCount;
    }

    EntityAvailabilityStatus getEntityAvailabilityStatus() {
        return this.entityAvailabilityStatus;
    }

    boolean isEnableSubscriptionPartitioning() {
        return this.enableSubscriptionPartitioning;
    }

    TopicProperties setEnableSubscriptionPartitioning(boolean enableSubscriptionPartitioning) {
        this.enableSubscriptionPartitioning = enableSubscriptionPartitioning;
        return this;
    }

    boolean isEnableExpress() {
        return this.enableExpress;
    }

    TopicProperties setEnableExpress(boolean enableExpress) {
        this.enableExpress = enableExpress;
        return this;
    }

    public long getMaxMessageSizeInKilobytes() {
        return this.maxMessageSizeInKilobytes;
    }

    public TopicProperties setMaxMessageSizeInKilobytes(long maxMessageSizeInKilobytes) {
        this.maxMessageSizeInKilobytes = maxMessageSizeInKilobytes;
        return this;
    }

    static {
        EntityHelper.setTopicAccessor(new EntityHelper.TopicAccessor(){

            @Override
            public TopicProperties toModel(TopicDescription options) {
                return new TopicProperties(options);
            }

            @Override
            public TopicDescription toImplementation(TopicProperties topic, List<AuthorizationRuleImpl> rules) {
                TopicDescription description = new TopicDescription().setAccessedAt(topic.getAccessedAt()).setAutoDeleteOnIdle(topic.getAutoDeleteOnIdle()).setCreatedAt(topic.getCreatedAt()).setDefaultMessageTimeToLive(topic.getDefaultMessageTimeToLive()).setDuplicateDetectionHistoryTimeWindow(topic.getDuplicateDetectionHistoryTimeWindow()).setEnablePartitioning(topic.isPartitioningEnabled()).setEnableSubscriptionPartitioning(topic.isEnableSubscriptionPartitioning()).setEnableExpress(topic.enableExpress).setEnableBatchedOperations(topic.enableBatchedOperations).setEntityAvailabilityStatus(topic.entityAvailabilityStatus).setFilteringMessagesBeforePublishing(topic.isFilteringMessagesBeforePublishing()).setIsAnonymousAccessible(topic.isAnonymousAccessible).setMaxSizeInMegabytes(topic.getMaxSizeInMegabytes()).setMaxMessageSizeInKilobytes(topic.getMaxMessageSizeInKilobytes()).setMessageCountDetails(topic.getMessageCountDetails()).setSupportOrdering(topic.supportOrdering).setSubscriptionCount(topic.getSubscriptionCount()).setStatus(topic.getStatus()).setSizeInBytes(topic.getSizeInBytes()).setRequiresDuplicateDetection(topic.isDuplicateDetectionRequired()).setUpdatedAt(topic.getUpdatedAt()).setUserMetadata(topic.getUserMetadata());
                if (!rules.isEmpty()) {
                    description.setAuthorizationRules(rules);
                }
                if (topic.getMaxMessageSizeInKilobytes() != 0L) {
                    description.setMaxMessageSizeInKilobytes(topic.getMaxMessageSizeInKilobytes());
                }
                return description;
            }

            @Override
            public void setName(TopicProperties topicProperties, String name) {
                topicProperties.setName(name);
            }
        });
    }
}

